/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;

public class Tables {
    public static boolean doesTableExist(AmazonDynamoDB dynamo, String tableName) {
        try {
            TableDescription table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
            return TableStatus.ACTIVE.toString().equals(table.getTableStatus());
        }
        catch (ResourceNotFoundException rnfe) {
            return false;
        }
    }

    public static void waitForTableToBecomeActive(AmazonDynamoDB dynamo, String tableName) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 600000L;
        while (System.currentTimeMillis() < endTime) {
            try {
                TableDescription table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
                if (table != null && table.getTableStatus().equals(TableStatus.ACTIVE.toString())) {
                    return;
                }
            }
            catch (ResourceNotFoundException rnfe) {
                // empty catch block
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new AmazonClientException("Interrupted while waiting for table to become active", e);
            }
        }
        throw new AmazonClientException("Table " + tableName + " never became active");
    }
}

