/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeVTLDevicesRequestMarshaller
implements Marshaller<Request<DescribeVTLDevicesRequest>, DescribeVTLDevicesRequest> {
    @Override
    public Request<DescribeVTLDevicesRequest> marshall(DescribeVTLDevicesRequest describeVTLDevicesRequest) {
        if (describeVTLDevicesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVTLDevicesRequest> request = new DefaultRequest<DescribeVTLDevicesRequest>(describeVTLDevicesRequest, "AWSStorageGateway");
        String target = "StorageGateway_20130630.DescribeVTLDevices";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ListWithAutoConstructFlag vTLDeviceARNsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeVTLDevicesRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value(describeVTLDevicesRequest.getGatewayARN());
            }
            if (!((vTLDeviceARNsList = (ListWithAutoConstructFlag)describeVTLDevicesRequest.getVTLDeviceARNs()) == null || vTLDeviceARNsList.isAutoConstruct() && vTLDeviceARNsList.isEmpty())) {
                jsonWriter.key("VTLDeviceARNs");
                jsonWriter.array();
                for (String vTLDeviceARNsListValue : vTLDeviceARNsList) {
                    if (vTLDeviceARNsListValue == null) continue;
                    jsonWriter.value(vTLDeviceARNsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeVTLDevicesRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(describeVTLDevicesRequest.getMarker());
            }
            if (describeVTLDevicesRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeVTLDevicesRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

