/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteHealthCheckRequest;
import com.amazonaws.services.route53.model.DeleteHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetHealthCheckRequest;
import com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.transform.ChangeResourceRecordSetsRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ChangeResourceRecordSetsResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.CreateHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.CreateHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.CreateHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.CreateHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.DelegationSetNotAvailableExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetChangeRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetChangeResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.HealthCheckAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HealthCheckInUseExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HostedZoneAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HostedZoneNotEmptyExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidChangeBatchExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidDomainNameExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListHealthChecksRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListHealthChecksResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListHostedZonesRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListHostedZonesResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListResourceRecordSetsRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListResourceRecordSetsResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchChangeExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchHealthCheckExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchHostedZoneExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.PriorRequestNotCompleteExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.TooManyHealthChecksExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.TooManyHostedZonesExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRoute53Client
extends AmazonWebServiceClient
implements AmazonRoute53 {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS3Signer signer;

    public AmazonRoute53Client() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRoute53Client(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRoute53Client(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRoute53Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidDomainNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidChangeBatchExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyHealthChecksExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyHostedZonesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HostedZoneAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HostedZoneNotEmptyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DelegationSetNotAvailableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchChangeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidInputExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HealthCheckInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HealthCheckAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchHostedZoneExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchHealthCheckExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PriorRequestNotCompleteExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("route53.amazonaws.com");
        this.signer = new AWS3Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53/request.handlers"));
    }

    @Override
    public ListResourceRecordSetsResult listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListResourceRecordSetsRequest> request = new ListResourceRecordSetsRequestMarshaller().marshall(listResourceRecordSetsRequest);
        return this.invoke(request, new ListResourceRecordSetsResultStaxUnmarshaller());
    }

    @Override
    public ChangeResourceRecordSetsResult changeResourceRecordSets(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ChangeResourceRecordSetsRequest> request = new ChangeResourceRecordSetsRequestMarshaller().marshall(changeResourceRecordSetsRequest);
        return this.invoke(request, new ChangeResourceRecordSetsResultStaxUnmarshaller());
    }

    @Override
    public CreateHostedZoneResult createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateHostedZoneRequest> request = new CreateHostedZoneRequestMarshaller().marshall(createHostedZoneRequest);
        return this.invoke(request, new CreateHostedZoneResultStaxUnmarshaller());
    }

    @Override
    public GetHealthCheckResult getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetHealthCheckRequest> request = new GetHealthCheckRequestMarshaller().marshall(getHealthCheckRequest);
        return this.invoke(request, new GetHealthCheckResultStaxUnmarshaller());
    }

    @Override
    public CreateHealthCheckResult createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateHealthCheckRequest> request = new CreateHealthCheckRequestMarshaller().marshall(createHealthCheckRequest);
        return this.invoke(request, new CreateHealthCheckResultStaxUnmarshaller());
    }

    @Override
    public GetChangeResult getChange(GetChangeRequest getChangeRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetChangeRequest> request = new GetChangeRequestMarshaller().marshall(getChangeRequest);
        return this.invoke(request, new GetChangeResultStaxUnmarshaller());
    }

    @Override
    public DeleteHealthCheckResult deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteHealthCheckRequest> request = new DeleteHealthCheckRequestMarshaller().marshall(deleteHealthCheckRequest);
        return this.invoke(request, new DeleteHealthCheckResultStaxUnmarshaller());
    }

    @Override
    public GetHostedZoneResult getHostedZone(GetHostedZoneRequest getHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetHostedZoneRequest> request = new GetHostedZoneRequestMarshaller().marshall(getHostedZoneRequest);
        return this.invoke(request, new GetHostedZoneResultStaxUnmarshaller());
    }

    @Override
    public ListHostedZonesResult listHostedZones(ListHostedZonesRequest listHostedZonesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListHostedZonesRequest> request = new ListHostedZonesRequestMarshaller().marshall(listHostedZonesRequest);
        return this.invoke(request, new ListHostedZonesResultStaxUnmarshaller());
    }

    @Override
    public DeleteHostedZoneResult deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteHostedZoneRequest> request = new DeleteHostedZoneRequestMarshaller().marshall(deleteHostedZoneRequest);
        return this.invoke(request, new DeleteHostedZoneResultStaxUnmarshaller());
    }

    @Override
    public ListHealthChecksResult listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListHealthChecksRequest> request = new ListHealthChecksRequestMarshaller().marshall(listHealthChecksRequest);
        return this.invoke(request, new ListHealthChecksResultStaxUnmarshaller());
    }

    @Override
    public ListHostedZonesResult listHostedZones() throws AmazonServiceException, AmazonClientException {
        return this.listHostedZones(new ListHostedZonesRequest());
    }

    @Override
    public ListHealthChecksResult listHealthChecks() throws AmazonServiceException, AmazonClientException {
        return this.listHealthChecks(new ListHealthChecksRequest());
    }

    @Override
    protected String getServiceAbbreviation() {
        return "route53";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext(originalRequest);
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

