/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClientFactory;
import com.amazonaws.http.HttpMethodReleaseInputStream;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.internal.CustomBackoffStrategy;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.ResponseMetadataCache;
import com.amazonaws.util.TimingInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class AmazonHttpClient {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final Log requestLog;
    static final Log log;
    private final HttpClient httpClient;
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private final ClientConfiguration config;
    private final ResponseMetadataCache responseMetadataCache = new ResponseMetadataCache(50);
    private final RequestMetricCollector requestMetricCollector;
    private static final Random random;
    private static final HttpRequestFactory httpRequestFactory;
    private static final HttpClientFactory httpClientFactory;
    @Deprecated
    public static final String PROFILING_SYSTEM_PROPERTY = "com.amazonaws.sdk.enableRuntimeProfiling";

    public AmazonHttpClient(ClientConfiguration config) {
        this(config, null);
    }

    public AmazonHttpClient(ClientConfiguration config, RequestMetricCollector requestMetricCollector) {
        this.config = config;
        this.httpClient = httpClientFactory.createHttpClient(config);
        this.requestMetricCollector = requestMetricCollector;
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    public void disableStrictHostnameVerification() {
        if (System.getProperty("com.amazonaws.sdk.disableCertChecking") != null) {
            return;
        }
        try {
            SchemeRegistry schemeRegistry = this.httpClient.getConnectionManager().getSchemeRegistry();
            SSLSocketFactory sf = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to access default SSL context to disable strict hostname verification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        if (executionContext == null) {
            throw new AmazonClientException("Internal SDK Error: No execution context parameter specified.");
        }
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        T response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            T t = response = (T)this.execute0(request, responseHandler, errorResponseHandler, executionContext);
            return t;
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            RequestMetricCollector c = this.requestMetricCollector(request);
            c.collectMetrics(request, response);
        }
    }

    private <T> T execute0(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        request.setAWSRequestMetrics(executionContext.getAwsRequestMetrics());
        List<RequestHandler> requestHandlers = executionContext.getRequestHandlers();
        if (requestHandlers == null) {
            requestHandlers = new ArrayList<RequestHandler>();
        }
        for (RequestHandler requestHandler : requestHandlers) {
            requestHandler.beforeRequest(request);
        }
        AWSRequestMetrics metrics = executionContext.getAwsRequestMetrics();
        T response = null;
        try {
            response = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
            TimingInfo timingInfo = metrics.getTimingInfo().endTiming();
            for (RequestHandler handler : requestHandlers) {
                handler.afterResponse(request, response, timingInfo);
            }
            return response;
        }
        catch (AmazonClientException e) {
            for (RequestHandler handler : requestHandlers) {
                handler.afterError(request, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeHelper(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        boolean leaveHttpConnectionOpen = false;
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.addProperty(AWSRequestMetrics.Field.ServiceName, (Object)request.getServiceName());
        awsRequestMetrics.addProperty(AWSRequestMetrics.Field.ServiceEndpoint, (Object)request.getEndpoint());
        this.setUserAgent(request);
        int requestCount = 0;
        URI redirectedURI = null;
        HttpEntity entity = null;
        AmazonServiceException exception = null;
        HashMap<String, String> originalParameters = new HashMap<String, String>();
        originalParameters.putAll(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>();
        originalHeaders.putAll(request.getHeaders());
        while (true) {
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RequestCount, (long)(++requestCount));
            if (requestCount > 1) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
            }
            HttpRequestBase httpRequest = null;
            org.apache.http.HttpResponse response = null;
            try {
                if (executionContext.getSigner() != null && executionContext.getCredentials() != null) {
                    awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestSigningTime);
                    try {
                        executionContext.getSigner().sign(request, executionContext.getCredentials());
                    }
                    finally {
                        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestSigningTime);
                    }
                }
                if (requestLog.isDebugEnabled()) {
                    requestLog.debug((Object)("Sending Request: " + request.toString()));
                }
                if ((httpRequest = httpRequestFactory.createHttpRequest(request, this.config, entity, executionContext)) instanceof HttpEntityEnclosingRequest) {
                    entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
                }
                if (redirectedURI != null) {
                    httpRequest.setURI(redirectedURI);
                }
                if (requestCount > 1) {
                    awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RetryPauseTime);
                    try {
                        this.pauseExponentially(requestCount, exception, executionContext.getCustomBackoffStrategy());
                    }
                    finally {
                        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RetryPauseTime);
                    }
                }
                if (entity != null) {
                    InputStream content = entity.getContent();
                    if (requestCount > 1) {
                        if (content.markSupported()) {
                            content.reset();
                            content.mark(-1);
                        }
                    } else if (content.markSupported()) {
                        content.mark(-1);
                    }
                }
                exception = null;
                awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpRequestTime);
                try {
                    response = this.httpClient.execute((HttpUriRequest)httpRequest);
                }
                finally {
                    awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpRequestTime);
                }
                if (this.isRequestSuccessful(response)) {
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)response.getStatusLine().getStatusCode());
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    T content = this.handleResponse(request, responseHandler, httpRequest, response, executionContext);
                    return content;
                }
                if (AmazonHttpClient.isTemporaryRedirect(response)) {
                    Header[] locationHeaders = response.getHeaders("location");
                    String redirectedLocation = locationHeaders[0].getValue();
                    log.debug((Object)("Redirecting to: " + redirectedLocation));
                    redirectedURI = URI.create(redirectedLocation);
                    httpRequest.setURI(redirectedURI);
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)response.getStatusLine().getStatusCode());
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.RedirectLocation, (Object)redirectedLocation);
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                exception = this.handleErrorResponse(request, errorResponseHandler, httpRequest, response);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)exception.getRequestId());
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSErrorCode, (Object)exception.getErrorCode());
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)exception.getStatusCode());
                if (!this.shouldRetry(httpRequest, exception, requestCount)) {
                    throw exception;
                }
                if (this.isClockSkewError(exception)) {
                    int timeOffset = this.parseClockSkewOffset(response, exception);
                    SDKGlobalConfiguration.setGlobalTimeOffset(timeOffset);
                }
                this.resetRequestAfterError(request, exception);
                continue;
            }
            catch (IOException ioe) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Unable to execute HTTP request: " + ioe.getMessage()), (Throwable)ioe);
                }
                awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.Exception);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.Exception, (Object)ioe.toString());
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                if (!this.shouldRetry(httpRequest, ioe, requestCount)) {
                    throw new AmazonClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                }
                this.resetRequestAfterError(request, ioe);
                continue;
            }
            catch (RuntimeException e) {
                throw this.handleUnexpectedFailure(e, awsRequestMetrics);
            }
            catch (Error e) {
                throw this.handleUnexpectedFailure(e, awsRequestMetrics);
            }
            finally {
                if (leaveHttpConnectionOpen) continue;
                try {
                    if (response == null || response.getEntity() == null || response.getEntity().getContent() == null) continue;
                    response.getEntity().getContent().close();
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot close the response content.", (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private <T extends Throwable> T handleUnexpectedFailure(T t, AWSRequestMetrics awsRequestMetrics) {
        log.warn((Object)"Unexpected failure", t);
        awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.Exception);
        return t;
    }

    private void resetRequestAfterError(Request<?> request, Exception cause) throws AmazonClientException {
        if (request.getContent() == null) {
            return;
        }
        if (!request.getContent().markSupported()) {
            throw new AmazonClientException("Encountered an exception and stream is not resettable", cause);
        }
        try {
            request.getContent().reset();
        }
        catch (IOException e) {
            throw new AmazonClientException("Encountered an exception and couldn't reset the stream to retry", cause);
        }
    }

    private void setUserAgent(Request<?> request) {
        String userAgentMarker;
        RequestClientOptions opts;
        AmazonWebServiceRequest awsreq;
        String userAgent = this.config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        if (userAgent != null) {
            request.addHeader(HEADER_USER_AGENT, userAgent);
        }
        if ((awsreq = request.getOriginalRequest()) != null && (opts = awsreq.getRequestClientOptions()) != null && (userAgentMarker = opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            request.addHeader(HEADER_USER_AGENT, AmazonHttpClient.createUserAgentString(userAgent, userAgentMarker));
        }
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString.trim() + " " + userAgent.trim();
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.httpClient.getConnectionManager());
        this.httpClient.getConnectionManager().shutdown();
    }

    private boolean shouldRetry(HttpRequestBase method, Exception exception, int requestCount) {
        HttpEntity entity;
        int retries = requestCount - 1;
        if (retries >= this.config.getMaxErrorRetry()) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Entity not repeatable");
            }
            return false;
        }
        if (exception instanceof IOException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            }
            return true;
        }
        if (exception instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)exception;
            if (ase.getStatusCode() == 500 || ase.getStatusCode() == 503) {
                return true;
            }
            if (AmazonHttpClient.isThrottlingException(ase)) {
                return true;
            }
            if (this.isClockSkewError(ase)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isTemporaryRedirect(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status == 307 && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private boolean isRequestSuccessful(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleResponse(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse, ExecutionContext executionContext) throws IOException {
        HttpResponse httpResponse = this.createResponse(method, request, apacheHttpResponse);
        if (responseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)method;
            httpResponse.setContent(new HttpMethodReleaseInputStream(httpEntityEnclosingRequest));
        }
        try {
            AmazonWebServiceResponse<T> awsResponse;
            CountingInputStream countingInputStream = null;
            if (System.getProperty(PROFILING_SYSTEM_PROPERTY) != null) {
                countingInputStream = new CountingInputStream(httpResponse.getContent());
                httpResponse.setContent(countingInputStream);
            }
            AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            try {
                awsResponse = responseHandler.handle(httpResponse);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            }
            if (countingInputStream != null) {
                awsRequestMetrics.setCounter(AWSRequestMetrics.Field.BytesProcessed, countingInputStream.getByteCount());
            }
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata");
            }
            this.responseMetadataCache.add(request.getOriginalRequest(), awsResponse.getResponseMetadata());
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((Object)("Received successful response: " + apacheHttpResponse.getStatusLine().getStatusCode() + ", AWS Request ID: " + awsResponse.getRequestId()));
            }
            awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)awsResponse.getRequestId());
            return awsResponse.getResult();
        }
        catch (CRC32MismatchException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + ")";
            throw new AmazonClientException(errorMessage, e);
        }
    }

    private AmazonServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<AmazonServiceException> errorResponseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        int status = apacheHttpResponse.getStatusLine().getStatusCode();
        HttpResponse response = this.createResponse(method, request, apacheHttpResponse);
        if (errorResponseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityEnclosingRequest = (HttpEntityEnclosingRequestBase)method;
            response.setContent(new HttpMethodReleaseInputStream((HttpEntityEnclosingRequest)entityEnclosingRequest));
        }
        AmazonServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
            requestLog.debug((Object)("Received error response: " + exception.toString()));
        }
        catch (Exception e) {
            if (status == 413) {
                exception = new AmazonServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(413);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (status == 503 && "Service Unavailable".equalsIgnoreCase(apacheHttpResponse.getStatusLine().getReasonPhrase())) {
                exception = new AmazonServiceException("Service unavailable");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(503);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + ")";
            throw new AmazonClientException(errorMessage, e);
        }
        exception.setStatusCode(status);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private void pauseExponentially(int requestCount, AmazonServiceException previousException, CustomBackoffStrategy backoffStrategy) {
        int retries = requestCount - 1;
        long delay = 0L;
        if (backoffStrategy != null) {
            delay = backoffStrategy.getBackoffPeriod(retries);
        } else {
            long scaleFactor = 300L;
            if (AmazonHttpClient.isThrottlingException(previousException)) {
                scaleFactor = 500 + random.nextInt(100);
            }
            delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        }
        delay = Math.min(delay, 20000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    public static boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Throttling".equals(ase.getErrorCode()) || "ThrottlingException".equals(ase.getErrorCode()) || "ProvisionedThroughputExceededException".equals(ase.getErrorCode());
    }

    public static boolean isRequestEntityTooLargeException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Request entity too large".equals(ase.getErrorCode());
    }

    public boolean isClockSkewError(AmazonServiceException exception) {
        if (exception == null) {
            return false;
        }
        return "RequestTimeTooSkewed".equals(exception.getErrorCode()) || "RequestExpired".equals(exception.getErrorCode()) || "InvalidSignatureException".equals(exception.getErrorCode()) || "SignatureDoesNotMatch".equals(exception.getErrorCode());
    }

    private String getServerDateFromException(String body) {
        int startPos = body.indexOf("(");
        int endPos = 0;
        endPos = body.contains(" + 15") ? body.indexOf(" + 15") : body.indexOf(" - 15");
        String msg = body.substring(startPos + 1, endPos);
        return msg;
    }

    private int parseClockSkewOffset(org.apache.http.HttpResponse response, AmazonServiceException exception) {
        DateUtils dateUtils = new DateUtils();
        Date deviceDate = new Date();
        Date serverDate = null;
        String serverDateStr = null;
        Header[] responseDateHeader = response.getHeaders("Date");
        try {
            if (responseDateHeader.length == 0) {
                serverDateStr = this.getServerDateFromException(exception.getMessage());
                serverDate = dateUtils.parseCompressedIso8601Date(serverDateStr);
            } else {
                serverDateStr = responseDateHeader[0].getValue();
                serverDate = dateUtils.parseRfc822Date(serverDateStr);
            }
        }
        catch (ParseException e) {
            log.warn((Object)("Unable to parse clock skew offset from response: " + serverDateStr), (Throwable)e);
            return 0;
        }
        catch (RuntimeException e) {
            log.warn((Object)("Unable to parse clock skew offset from response: " + serverDateStr), (Throwable)e);
            return 0;
        }
        long diff = deviceDate.getTime() - serverDate.getTime();
        return (int)(diff / 1000L);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private RequestMetricCollector requestMetricCollector(Request<?> req) {
        AmazonWebServiceRequest origReq = req.getOriginalRequest();
        RequestMetricCollector mc = origReq.getRequestMetricCollector();
        if (mc != null) {
            return mc;
        }
        mc = this.requestMetricCollector;
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    static {
        String jvmVersion;
        requestLog = LogFactory.getLog((String)"com.amazonaws.request");
        log = LogFactory.getLog(AmazonHttpClient.class);
        random = new Random();
        httpRequestFactory = new HttpRequestFactory();
        httpClientFactory = new HttpClientFactory();
        List<String> problematicJvmVersions = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17");
        if (problematicJvmVersions.contains(jvmVersion = System.getProperty("java.version"))) {
            log.warn((Object)("Detected a possible problem with the current JVM version (" + jvmVersion + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update."));
        }
    }
}

