/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.directconnect.AmazonDirectConnect;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectResult;
import com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.amazonaws.services.directconnect.model.ConfirmConnectionResult;
import com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.amazonaws.services.directconnect.model.CreateConnectionResult;
import com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.amazonaws.services.directconnect.model.CreateInterconnectResult;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.amazonaws.services.directconnect.model.DeleteConnectionResult;
import com.amazonaws.services.directconnect.model.DeleteInterconnectRequest;
import com.amazonaws.services.directconnect.model.DeleteInterconnectResult;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsResult;
import com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest;
import com.amazonaws.services.directconnect.model.DescribeInterconnectsResult;
import com.amazonaws.services.directconnect.model.DescribeLocationsRequest;
import com.amazonaws.services.directconnect.model.DescribeLocationsResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesResult;
import com.amazonaws.services.directconnect.model.transform.AllocateConnectionOnInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocateConnectionOnInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsOnInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsOnInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeInterconnectsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeInterconnectsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeLocationsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeLocationsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DirectConnectClientExceptionUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DirectConnectServerExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonDirectConnectClient
extends AmazonWebServiceClient
implements AmazonDirectConnect {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDirectConnect.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonDirectConnectClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonDirectConnectClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new DirectConnectServerExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DirectConnectClientExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("directconnect.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("directconnect");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/directconnect/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLocationsResult describeLocations(DescribeLocationsRequest describeLocationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeLocationsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeLocationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeLocationsRequestMarshaller().marshall(describeLocationsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeLocationsResultJsonUnmarshaller unmarshaller = new DescribeLocationsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeLocationsResult> responseHandler = new JsonResponseHandler<DescribeLocationsResult>(unmarshaller);
        return (DescribeLocationsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPublicVirtualInterfaceResult confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ConfirmPublicVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(confirmPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ConfirmPublicVirtualInterfaceRequestMarshaller().marshall(confirmPublicVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ConfirmPublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new ConfirmPublicVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<ConfirmPublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<ConfirmPublicVirtualInterfaceResult>(unmarshaller);
        return (ConfirmPublicVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePrivateVirtualInterfaceResult createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreatePrivateVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(createPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CreatePrivateVirtualInterfaceRequestMarshaller().marshall(createPrivateVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        CreatePrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new CreatePrivateVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<CreatePrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<CreatePrivateVirtualInterfaceResult>(unmarshaller);
        return (CreatePrivateVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualInterfaceResult deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteVirtualInterfaceRequestMarshaller().marshall(deleteVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DeleteVirtualInterfaceResultJsonUnmarshaller unmarshaller = new DeleteVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<DeleteVirtualInterfaceResult> responseHandler = new JsonResponseHandler<DeleteVirtualInterfaceResult>(unmarshaller);
        return (DeleteVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePublicVirtualInterfaceResult createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreatePublicVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(createPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CreatePublicVirtualInterfaceRequestMarshaller().marshall(createPublicVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        CreatePublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new CreatePublicVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<CreatePublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<CreatePublicVirtualInterfaceResult>(unmarshaller);
        return (CreatePublicVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInterconnectResult createInterconnect(CreateInterconnectRequest createInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateInterconnectRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(createInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CreateInterconnectRequestMarshaller().marshall(createInterconnectRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        CreateInterconnectResultJsonUnmarshaller unmarshaller = new CreateInterconnectResultJsonUnmarshaller();
        JsonResponseHandler<CreateInterconnectResult> responseHandler = new JsonResponseHandler<CreateInterconnectResult>(unmarshaller);
        return (CreateInterconnectResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeVirtualInterfacesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualInterfacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeVirtualInterfacesRequestMarshaller().marshall(describeVirtualInterfacesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeVirtualInterfacesResultJsonUnmarshaller unmarshaller = new DescribeVirtualInterfacesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeVirtualInterfacesResult> responseHandler = new JsonResponseHandler<DescribeVirtualInterfacesResult>(unmarshaller);
        return (DescribeVirtualInterfacesResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmConnectionResult confirmConnection(ConfirmConnectionRequest confirmConnectionRequest) throws AmazonServiceException, AmazonClientException {
        Request<ConfirmConnectionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(confirmConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ConfirmConnectionRequestMarshaller().marshall(confirmConnectionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ConfirmConnectionResultJsonUnmarshaller unmarshaller = new ConfirmConnectionResultJsonUnmarshaller();
        JsonResponseHandler<ConfirmConnectionResult> responseHandler = new JsonResponseHandler<ConfirmConnectionResult>(unmarshaller);
        return (ConfirmConnectionResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInterconnectsResult describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeInterconnectsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeInterconnectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeInterconnectsRequestMarshaller().marshall(describeInterconnectsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeInterconnectsResultJsonUnmarshaller unmarshaller = new DescribeInterconnectsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeInterconnectsResult> responseHandler = new JsonResponseHandler<DescribeInterconnectsResult>(unmarshaller);
        return (DescribeInterconnectsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeVirtualGatewaysRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualGatewaysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeVirtualGatewaysRequestMarshaller().marshall(describeVirtualGatewaysRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeVirtualGatewaysResultJsonUnmarshaller unmarshaller = new DescribeVirtualGatewaysResultJsonUnmarshaller();
        JsonResponseHandler<DescribeVirtualGatewaysResult> responseHandler = new JsonResponseHandler<DescribeVirtualGatewaysResult>(unmarshaller);
        return (DescribeVirtualGatewaysResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPrivateVirtualInterfaceResult confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ConfirmPrivateVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(confirmPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ConfirmPrivateVirtualInterfaceRequestMarshaller().marshall(confirmPrivateVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<ConfirmPrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<ConfirmPrivateVirtualInterfaceResult>(unmarshaller);
        return (ConfirmPrivateVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsResult describeConnections(DescribeConnectionsRequest describeConnectionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeConnectionsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeConnectionsRequestMarshaller().marshall(describeConnectionsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeConnectionsResultJsonUnmarshaller unmarshaller = new DescribeConnectionsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeConnectionsResult> responseHandler = new JsonResponseHandler<DescribeConnectionsResult>(unmarshaller);
        return (DescribeConnectionsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePublicVirtualInterfaceResult allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<AllocatePublicVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(allocatePublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new AllocatePublicVirtualInterfaceRequestMarshaller().marshall(allocatePublicVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        AllocatePublicVirtualInterfaceResultJsonUnmarshaller unmarshaller = new AllocatePublicVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<AllocatePublicVirtualInterfaceResult> responseHandler = new JsonResponseHandler<AllocatePublicVirtualInterfaceResult>(unmarshaller);
        return (AllocatePublicVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePrivateVirtualInterfaceResult allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        Request<AllocatePrivateVirtualInterfaceRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(allocatePrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new AllocatePrivateVirtualInterfaceRequestMarshaller().marshall(allocatePrivateVirtualInterfaceRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        AllocatePrivateVirtualInterfaceResultJsonUnmarshaller unmarshaller = new AllocatePrivateVirtualInterfaceResultJsonUnmarshaller();
        JsonResponseHandler<AllocatePrivateVirtualInterfaceResult> responseHandler = new JsonResponseHandler<AllocatePrivateVirtualInterfaceResult>(unmarshaller);
        return (AllocatePrivateVirtualInterfaceResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest deleteConnectionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteConnectionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteConnectionRequestMarshaller().marshall(deleteConnectionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DeleteConnectionResultJsonUnmarshaller unmarshaller = new DeleteConnectionResultJsonUnmarshaller();
        JsonResponseHandler<DeleteConnectionResult> responseHandler = new JsonResponseHandler<DeleteConnectionResult>(unmarshaller);
        return (DeleteConnectionResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsOnInterconnectResult describeConnectionsOnInterconnect(DescribeConnectionsOnInterconnectRequest describeConnectionsOnInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeConnectionsOnInterconnectRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsOnInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeConnectionsOnInterconnectRequestMarshaller().marshall(describeConnectionsOnInterconnectRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeConnectionsOnInterconnectResultJsonUnmarshaller unmarshaller = new DescribeConnectionsOnInterconnectResultJsonUnmarshaller();
        JsonResponseHandler<DescribeConnectionsOnInterconnectResult> responseHandler = new JsonResponseHandler<DescribeConnectionsOnInterconnectResult>(unmarshaller);
        return (DescribeConnectionsOnInterconnectResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateConnectionOnInterconnectResult allocateConnectionOnInterconnect(AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        Request<AllocateConnectionOnInterconnectRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(allocateConnectionOnInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new AllocateConnectionOnInterconnectRequestMarshaller().marshall(allocateConnectionOnInterconnectRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        AllocateConnectionOnInterconnectResultJsonUnmarshaller unmarshaller = new AllocateConnectionOnInterconnectResultJsonUnmarshaller();
        JsonResponseHandler<AllocateConnectionOnInterconnectResult> responseHandler = new JsonResponseHandler<AllocateConnectionOnInterconnectResult>(unmarshaller);
        return (AllocateConnectionOnInterconnectResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionResult createConnection(CreateConnectionRequest createConnectionRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateConnectionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(createConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CreateConnectionRequestMarshaller().marshall(createConnectionRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        CreateConnectionResultJsonUnmarshaller unmarshaller = new CreateConnectionResultJsonUnmarshaller();
        JsonResponseHandler<CreateConnectionResult> responseHandler = new JsonResponseHandler<CreateConnectionResult>(unmarshaller);
        return (CreateConnectionResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInterconnectResult deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteInterconnectRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteInterconnectRequestMarshaller().marshall(deleteInterconnectRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DeleteInterconnectResultJsonUnmarshaller unmarshaller = new DeleteInterconnectResultJsonUnmarshaller();
        JsonResponseHandler<DeleteInterconnectResult> responseHandler = new JsonResponseHandler<DeleteInterconnectResult>(unmarshaller);
        return (DeleteInterconnectResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeLocationsResult describeLocations() throws AmazonServiceException, AmazonClientException {
        return this.describeLocations(new DescribeLocationsRequest());
    }

    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces() throws AmazonServiceException, AmazonClientException {
        return this.describeVirtualInterfaces(new DescribeVirtualInterfacesRequest());
    }

    @Override
    public DescribeInterconnectsResult describeInterconnects() throws AmazonServiceException, AmazonClientException {
        return this.describeInterconnects(new DescribeInterconnectsRequest());
    }

    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways() throws AmazonServiceException, AmazonClientException {
        return this.describeVirtualGateways(new DescribeVirtualGatewaysRequest());
    }

    @Override
    public DescribeConnectionsResult describeConnections() throws AmazonServiceException, AmazonClientException {
        return this.describeConnections(new DescribeConnectionsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "directconnect";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

