/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadataParser;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionUtils {
    private static final String REGIONS_FILE_OVERRIDE = "com.amazonaws.regions.RegionUtils.fileOverride";
    private static final String DISABLE_REMOTE_REGIONS_FILE = "com.amazonaws.regions.RegionUtils.disableRemote";
    private static final String CLOUDFRONT_DISTRO = "https://d3s62xsdspbbg2.cloudfront.net/endpoints.xml";
    private static final String S3_BUCKET_ORIGIN_ENDPOINT = "https://aws-sdk-configurations.s3.amazonaws.com/endpoints.xml";
    private static final String FALLBACK = "/etc/regions.xml";
    private static final int CONNECTION_TIMEOUT = 50000;
    private static final int SOCKET_TIMEOUT = 50000;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private static List<Region> regions;

    public static synchronized List<Region> getRegions() {
        if (regions == null) {
            RegionUtils.init();
        }
        return regions;
    }

    public static synchronized List<Region> getRegionsForService(String serviceAbbreviation) {
        LinkedList<Region> regions = new LinkedList<Region>();
        for (Region r : RegionUtils.getRegions()) {
            if (!r.isServiceSupported(serviceAbbreviation)) continue;
            regions.add(r);
        }
        return regions;
    }

    public static Region getRegion(String regionName) {
        for (Region r : RegionUtils.getRegions()) {
            if (!r.getName().equals(regionName)) continue;
            return r;
        }
        return null;
    }

    public static Region getRegionByEndpoint(String endpoint) {
        URI targetEndpointUri = RegionUtils.getUriByEndpoint(endpoint);
        String targetHost = targetEndpointUri.getHost();
        for (Region region : RegionUtils.getRegions()) {
            for (String serviceEndpoint : region.getServiceEndpoints().values()) {
                URI serviceEndpointUrl = RegionUtils.getUriByEndpoint(serviceEndpoint);
                if (!serviceEndpointUrl.getHost().equals(targetHost)) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + endpoint);
    }

    public static synchronized void init() {
        String overrideFilePath = System.getProperty(REGIONS_FILE_OVERRIDE);
        if (overrideFilePath != null) {
            try {
                RegionUtils.loadRegionsFromOverrideFile(overrideFilePath);
            }
            catch (FileNotFoundException exception) {
                throw new RuntimeException("Couldn't find regions override file specified: " + overrideFilePath, exception);
            }
        }
        if (System.getProperty(DISABLE_REMOTE_REGIONS_FILE) == null) {
            InputStream regionsFile;
            try {
                regionsFile = RegionUtils.getRegionsFileFromCloudfront();
                RegionUtils.initRegions(regionsFile, true);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to initialize regional endpoints from cloudfront", (Throwable)e);
                regions = null;
            }
            if (regions == null) {
                try {
                    regionsFile = RegionUtils.getRegionsFileFromS3Bucket();
                    RegionUtils.initRegions(regionsFile, true);
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to initialize regional endpoints from S3 bucket", (Throwable)e);
                    regions = null;
                }
            }
        }
        if (regions == null) {
            RegionUtils.initSDKRegions();
        }
    }

    private static void loadRegionsFromOverrideFile(String overrideFilePath) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using local override of the regions file (" + overrideFilePath + ") to initiate regions data..."));
        }
        File regionsFile = new File(overrideFilePath);
        FileInputStream override = new FileInputStream(regionsFile);
        try {
            RegionUtils.initRegions(override, false);
        }
        catch (IOException exception) {
            log.warn((Object)("Failed to parse regional endpoints from override file " + overrideFilePath), (Throwable)exception);
        }
    }

    private static void initRegions(InputStream regionsFile, boolean enableEndpointVerification) throws IOException {
        RegionMetadataParser parser = new RegionMetadataParser();
        regions = parser.parseRegionMetadata(regionsFile, enableEndpointVerification);
    }

    private static void initSDKRegions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the regions from the region file bundled with the SDK...");
        }
        try {
            InputStream inputStream = RegionUtils.class.getResourceAsStream(FALLBACK);
            RegionUtils.initRegions(inputStream, true);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to initialize region metadata: " + exception.getMessage(), exception);
        }
    }

    private static InputStream getRegionsFileFromCloudfront() throws IOException {
        String endpointsUrl = CLOUDFRONT_DISTRO;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retreiving regions file from the cloudfront distribution: " + endpointsUrl));
        }
        return RegionUtils.fetchFile(endpointsUrl);
    }

    private static InputStream getRegionsFileFromS3Bucket() throws IOException {
        String endpointsUrl = S3_BUCKET_ORIGIN_ENDPOINT;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retreiving regions file from the S3 bucket: " + endpointsUrl));
        }
        return RegionUtils.fetchFile(endpointsUrl);
    }

    private static InputStream fetchFile(String url) throws IOException {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent((HttpParams)httpClientParams, (String)VersionInfoUtils.getUserAgent());
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)50000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)50000);
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)httpClientParams);
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return entity.getContent();
        }
        return null;
    }

    private static URI getUriByEndpoint(String endpoint) {
        URI targetEndpointUri = null;
        try {
            targetEndpointUri = new URI(endpoint);
            if (targetEndpointUri.getHost() == null) {
                targetEndpointUri = new URI("http://" + endpoint);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage(), e);
        }
        return targetEndpointUri;
    }
}

