/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebootInstancesRequestMarshaller
implements Marshaller<Request<RebootInstancesRequest>, RebootInstancesRequest> {
    @Override
    public Request<RebootInstancesRequest> marshall(RebootInstancesRequest rebootInstancesRequest) {
        if (rebootInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RebootInstancesRequest> request = new DefaultRequest<RebootInstancesRequest>(rebootInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RebootInstances");
        request.addParameter("Version", "2013-06-15");
        List<String> instanceIdsList = rebootInstancesRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        return request;
    }
}

