/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.storagegateway.AWSStorageGateway;
import com.amazonaws.services.storagegateway.model.ActivateGatewayRequest;
import com.amazonaws.services.storagegateway.model.ActivateGatewayResult;
import com.amazonaws.services.storagegateway.model.AddCacheRequest;
import com.amazonaws.services.storagegateway.model.AddCacheResult;
import com.amazonaws.services.storagegateway.model.AddUploadBufferRequest;
import com.amazonaws.services.storagegateway.model.AddUploadBufferResult;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageResult;
import com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest;
import com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeResult;
import com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest;
import com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointResult;
import com.amazonaws.services.storagegateway.model.CreateSnapshotRequest;
import com.amazonaws.services.storagegateway.model.CreateSnapshotResult;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeResult;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.DeleteChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.DeleteGatewayRequest;
import com.amazonaws.services.storagegateway.model.DeleteGatewayResult;
import com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleResult;
import com.amazonaws.services.storagegateway.model.DeleteVolumeRequest;
import com.amazonaws.services.storagegateway.model.DeleteVolumeResult;
import com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.DescribeCacheRequest;
import com.amazonaws.services.storagegateway.model.DescribeCacheResult;
import com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest;
import com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesResult;
import com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.DescribeChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest;
import com.amazonaws.services.storagegateway.model.DescribeGatewayInformationResult;
import com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest;
import com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeResult;
import com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleResult;
import com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest;
import com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesResult;
import com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest;
import com.amazonaws.services.storagegateway.model.DescribeUploadBufferResult;
import com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest;
import com.amazonaws.services.storagegateway.model.DescribeWorkingStorageResult;
import com.amazonaws.services.storagegateway.model.ListGatewaysRequest;
import com.amazonaws.services.storagegateway.model.ListGatewaysResult;
import com.amazonaws.services.storagegateway.model.ListLocalDisksRequest;
import com.amazonaws.services.storagegateway.model.ListLocalDisksResult;
import com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest;
import com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsResult;
import com.amazonaws.services.storagegateway.model.ListVolumesRequest;
import com.amazonaws.services.storagegateway.model.ListVolumesResult;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayResult;
import com.amazonaws.services.storagegateway.model.StartGatewayRequest;
import com.amazonaws.services.storagegateway.model.StartGatewayResult;
import com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest;
import com.amazonaws.services.storagegateway.model.UpdateGatewayInformationResult;
import com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest;
import com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowResult;
import com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest;
import com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeResult;
import com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleResult;
import com.amazonaws.services.storagegateway.model.transform.ActivateGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ActivateGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddCacheRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddCacheResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddUploadBufferRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddUploadBufferResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddWorkingStorageRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddWorkingStorageResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateCachediSCSIVolumeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateCachediSCSIVolumeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateSnapshotFromVolumeRecoveryPointRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateSnapshotFromVolumeRecoveryPointResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateSnapshotRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateStorediSCSIVolumeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateStorediSCSIVolumeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteBandwidthRateLimitRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteBandwidthRateLimitResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteChapCredentialsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteChapCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteSnapshotScheduleRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteSnapshotScheduleResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteVolumeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteVolumeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeBandwidthRateLimitRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeBandwidthRateLimitResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeCacheRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeCacheResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeCachediSCSIVolumesRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeCachediSCSIVolumesResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeChapCredentialsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeChapCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeGatewayInformationRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeGatewayInformationResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeMaintenanceStartTimeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeMaintenanceStartTimeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeSnapshotScheduleRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeSnapshotScheduleResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeStorediSCSIVolumesRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeStorediSCSIVolumesResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeUploadBufferRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeUploadBufferResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeWorkingStorageRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeWorkingStorageResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.InvalidGatewayRequestExceptionUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListGatewaysRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListGatewaysResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListLocalDisksRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListLocalDisksResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListVolumeRecoveryPointsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListVolumeRecoveryPointsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListVolumesRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListVolumesResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ShutdownGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ShutdownGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.StartGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.StartGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateBandwidthRateLimitRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateBandwidthRateLimitResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateChapCredentialsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateChapCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewayInformationRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewayInformationResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewaySoftwareNowRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewaySoftwareNowResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateMaintenanceStartTimeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateMaintenanceStartTimeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateSnapshotScheduleRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateSnapshotScheduleResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSStorageGatewayClient
extends AmazonWebServiceClient
implements AWSStorageGateway {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSStorageGateway.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AWSStorageGatewayClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSStorageGatewayClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSStorageGatewayClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSStorageGatewayClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSStorageGatewayClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSStorageGatewayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new InvalidGatewayRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("storagegateway.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/storagegateway/request.handlers"));
    }

    @Override
    public DeleteBandwidthRateLimitResult deleteBandwidthRateLimit(DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteBandwidthRateLimitRequest> request = new DeleteBandwidthRateLimitRequestMarshaller().marshall(deleteBandwidthRateLimitRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteBandwidthRateLimitResultJsonUnmarshaller unmarshaller = new DeleteBandwidthRateLimitResultJsonUnmarshaller();
        JsonResponseHandler<DeleteBandwidthRateLimitResult> responseHandler = new JsonResponseHandler<DeleteBandwidthRateLimitResult>(unmarshaller);
        return (DeleteBandwidthRateLimitResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListGatewaysResult listGateways(ListGatewaysRequest listGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListGatewaysRequest> request = new ListGatewaysRequestMarshaller().marshall(listGatewaysRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListGatewaysResultJsonUnmarshaller unmarshaller = new ListGatewaysResultJsonUnmarshaller();
        JsonResponseHandler<ListGatewaysResult> responseHandler = new JsonResponseHandler<ListGatewaysResult>(unmarshaller);
        return (ListGatewaysResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeleteChapCredentialsResult deleteChapCredentials(DeleteChapCredentialsRequest deleteChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteChapCredentialsRequest> request = new DeleteChapCredentialsRequestMarshaller().marshall(deleteChapCredentialsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteChapCredentialsResultJsonUnmarshaller unmarshaller = new DeleteChapCredentialsResultJsonUnmarshaller();
        JsonResponseHandler<DeleteChapCredentialsResult> responseHandler = new JsonResponseHandler<DeleteChapCredentialsResult>(unmarshaller);
        return (DeleteChapCredentialsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateStorediSCSIVolumeResult createStorediSCSIVolume(CreateStorediSCSIVolumeRequest createStorediSCSIVolumeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateStorediSCSIVolumeRequest> request = new CreateStorediSCSIVolumeRequestMarshaller().marshall(createStorediSCSIVolumeRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateStorediSCSIVolumeResultJsonUnmarshaller unmarshaller = new CreateStorediSCSIVolumeResultJsonUnmarshaller();
        JsonResponseHandler<CreateStorediSCSIVolumeResult> responseHandler = new JsonResponseHandler<CreateStorediSCSIVolumeResult>(unmarshaller);
        return (CreateStorediSCSIVolumeResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdateGatewayInformationResult updateGatewayInformation(UpdateGatewayInformationRequest updateGatewayInformationRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdateGatewayInformationRequest> request = new UpdateGatewayInformationRequestMarshaller().marshall(updateGatewayInformationRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdateGatewayInformationResultJsonUnmarshaller unmarshaller = new UpdateGatewayInformationResultJsonUnmarshaller();
        JsonResponseHandler<UpdateGatewayInformationResult> responseHandler = new JsonResponseHandler<UpdateGatewayInformationResult>(unmarshaller);
        return (UpdateGatewayInformationResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public StartGatewayResult startGateway(StartGatewayRequest startGatewayRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<StartGatewayRequest> request = new StartGatewayRequestMarshaller().marshall(startGatewayRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        StartGatewayResultJsonUnmarshaller unmarshaller = new StartGatewayResultJsonUnmarshaller();
        JsonResponseHandler<StartGatewayResult> responseHandler = new JsonResponseHandler<StartGatewayResult>(unmarshaller);
        return (StartGatewayResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdateMaintenanceStartTimeResult updateMaintenanceStartTime(UpdateMaintenanceStartTimeRequest updateMaintenanceStartTimeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdateMaintenanceStartTimeRequest> request = new UpdateMaintenanceStartTimeRequestMarshaller().marshall(updateMaintenanceStartTimeRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdateMaintenanceStartTimeResultJsonUnmarshaller unmarshaller = new UpdateMaintenanceStartTimeResultJsonUnmarshaller();
        JsonResponseHandler<UpdateMaintenanceStartTimeResult> responseHandler = new JsonResponseHandler<UpdateMaintenanceStartTimeResult>(unmarshaller);
        return (UpdateMaintenanceStartTimeResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListVolumesResult listVolumes(ListVolumesRequest listVolumesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListVolumesRequest> request = new ListVolumesRequestMarshaller().marshall(listVolumesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListVolumesResultJsonUnmarshaller unmarshaller = new ListVolumesResultJsonUnmarshaller();
        JsonResponseHandler<ListVolumesResult> responseHandler = new JsonResponseHandler<ListVolumesResult>(unmarshaller);
        return (ListVolumesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListLocalDisksResult listLocalDisks(ListLocalDisksRequest listLocalDisksRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListLocalDisksRequest> request = new ListLocalDisksRequestMarshaller().marshall(listLocalDisksRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListLocalDisksResultJsonUnmarshaller unmarshaller = new ListLocalDisksResultJsonUnmarshaller();
        JsonResponseHandler<ListLocalDisksResult> responseHandler = new JsonResponseHandler<ListLocalDisksResult>(unmarshaller);
        return (ListLocalDisksResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeStorediSCSIVolumesResult describeStorediSCSIVolumes(DescribeStorediSCSIVolumesRequest describeStorediSCSIVolumesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeStorediSCSIVolumesRequest> request = new DescribeStorediSCSIVolumesRequestMarshaller().marshall(describeStorediSCSIVolumesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeStorediSCSIVolumesResultJsonUnmarshaller unmarshaller = new DescribeStorediSCSIVolumesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeStorediSCSIVolumesResult> responseHandler = new JsonResponseHandler<DescribeStorediSCSIVolumesResult>(unmarshaller);
        return (DescribeStorediSCSIVolumesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeleteVolumeResult deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteVolumeRequest> request = new DeleteVolumeRequestMarshaller().marshall(deleteVolumeRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteVolumeResultJsonUnmarshaller unmarshaller = new DeleteVolumeResultJsonUnmarshaller();
        JsonResponseHandler<DeleteVolumeResult> responseHandler = new JsonResponseHandler<DeleteVolumeResult>(unmarshaller);
        return (DeleteVolumeResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeBandwidthRateLimitResult describeBandwidthRateLimit(DescribeBandwidthRateLimitRequest describeBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeBandwidthRateLimitRequest> request = new DescribeBandwidthRateLimitRequestMarshaller().marshall(describeBandwidthRateLimitRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeBandwidthRateLimitResultJsonUnmarshaller unmarshaller = new DescribeBandwidthRateLimitResultJsonUnmarshaller();
        JsonResponseHandler<DescribeBandwidthRateLimitResult> responseHandler = new JsonResponseHandler<DescribeBandwidthRateLimitResult>(unmarshaller);
        return (DescribeBandwidthRateLimitResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeMaintenanceStartTimeResult describeMaintenanceStartTime(DescribeMaintenanceStartTimeRequest describeMaintenanceStartTimeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeMaintenanceStartTimeRequest> request = new DescribeMaintenanceStartTimeRequestMarshaller().marshall(describeMaintenanceStartTimeRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeMaintenanceStartTimeResultJsonUnmarshaller unmarshaller = new DescribeMaintenanceStartTimeResultJsonUnmarshaller();
        JsonResponseHandler<DescribeMaintenanceStartTimeResult> responseHandler = new JsonResponseHandler<DescribeMaintenanceStartTimeResult>(unmarshaller);
        return (DescribeMaintenanceStartTimeResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateSnapshotRequest> request = new CreateSnapshotRequestMarshaller().marshall(createSnapshotRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateSnapshotResultJsonUnmarshaller unmarshaller = new CreateSnapshotResultJsonUnmarshaller();
        JsonResponseHandler<CreateSnapshotResult> responseHandler = new JsonResponseHandler<CreateSnapshotResult>(unmarshaller);
        return (CreateSnapshotResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeChapCredentialsResult describeChapCredentials(DescribeChapCredentialsRequest describeChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeChapCredentialsRequest> request = new DescribeChapCredentialsRequestMarshaller().marshall(describeChapCredentialsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeChapCredentialsResultJsonUnmarshaller unmarshaller = new DescribeChapCredentialsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeChapCredentialsResult> responseHandler = new JsonResponseHandler<DescribeChapCredentialsResult>(unmarshaller);
        return (DescribeChapCredentialsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeCacheResult describeCache(DescribeCacheRequest describeCacheRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeCacheRequest> request = new DescribeCacheRequestMarshaller().marshall(describeCacheRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeCacheResultJsonUnmarshaller unmarshaller = new DescribeCacheResultJsonUnmarshaller();
        JsonResponseHandler<DescribeCacheResult> responseHandler = new JsonResponseHandler<DescribeCacheResult>(unmarshaller);
        return (DescribeCacheResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeSnapshotScheduleResult describeSnapshotSchedule(DescribeSnapshotScheduleRequest describeSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeSnapshotScheduleRequest> request = new DescribeSnapshotScheduleRequestMarshaller().marshall(describeSnapshotScheduleRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeSnapshotScheduleResultJsonUnmarshaller unmarshaller = new DescribeSnapshotScheduleResultJsonUnmarshaller();
        JsonResponseHandler<DescribeSnapshotScheduleResult> responseHandler = new JsonResponseHandler<DescribeSnapshotScheduleResult>(unmarshaller);
        return (DescribeSnapshotScheduleResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateCachediSCSIVolumeResult createCachediSCSIVolume(CreateCachediSCSIVolumeRequest createCachediSCSIVolumeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateCachediSCSIVolumeRequest> request = new CreateCachediSCSIVolumeRequestMarshaller().marshall(createCachediSCSIVolumeRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateCachediSCSIVolumeResultJsonUnmarshaller unmarshaller = new CreateCachediSCSIVolumeResultJsonUnmarshaller();
        JsonResponseHandler<CreateCachediSCSIVolumeResult> responseHandler = new JsonResponseHandler<CreateCachediSCSIVolumeResult>(unmarshaller);
        return (CreateCachediSCSIVolumeResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ShutdownGatewayResult shutdownGateway(ShutdownGatewayRequest shutdownGatewayRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ShutdownGatewayRequest> request = new ShutdownGatewayRequestMarshaller().marshall(shutdownGatewayRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ShutdownGatewayResultJsonUnmarshaller unmarshaller = new ShutdownGatewayResultJsonUnmarshaller();
        JsonResponseHandler<ShutdownGatewayResult> responseHandler = new JsonResponseHandler<ShutdownGatewayResult>(unmarshaller);
        return (ShutdownGatewayResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdateGatewaySoftwareNowResult updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdateGatewaySoftwareNowRequest> request = new UpdateGatewaySoftwareNowRequestMarshaller().marshall(updateGatewaySoftwareNowRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdateGatewaySoftwareNowResultJsonUnmarshaller unmarshaller = new UpdateGatewaySoftwareNowResultJsonUnmarshaller();
        JsonResponseHandler<UpdateGatewaySoftwareNowResult> responseHandler = new JsonResponseHandler<UpdateGatewaySoftwareNowResult>(unmarshaller);
        return (UpdateGatewaySoftwareNowResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeWorkingStorageResult describeWorkingStorage(DescribeWorkingStorageRequest describeWorkingStorageRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeWorkingStorageRequest> request = new DescribeWorkingStorageRequestMarshaller().marshall(describeWorkingStorageRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeWorkingStorageResultJsonUnmarshaller unmarshaller = new DescribeWorkingStorageResultJsonUnmarshaller();
        JsonResponseHandler<DescribeWorkingStorageResult> responseHandler = new JsonResponseHandler<DescribeWorkingStorageResult>(unmarshaller);
        return (DescribeWorkingStorageResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public AddCacheResult addCache(AddCacheRequest addCacheRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AddCacheRequest> request = new AddCacheRequestMarshaller().marshall(addCacheRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        AddCacheResultJsonUnmarshaller unmarshaller = new AddCacheResultJsonUnmarshaller();
        JsonResponseHandler<AddCacheResult> responseHandler = new JsonResponseHandler<AddCacheResult>(unmarshaller);
        return (AddCacheResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeleteGatewayResult deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteGatewayRequest> request = new DeleteGatewayRequestMarshaller().marshall(deleteGatewayRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteGatewayResultJsonUnmarshaller unmarshaller = new DeleteGatewayResultJsonUnmarshaller();
        JsonResponseHandler<DeleteGatewayResult> responseHandler = new JsonResponseHandler<DeleteGatewayResult>(unmarshaller);
        return (DeleteGatewayResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateSnapshotFromVolumeRecoveryPointResult createSnapshotFromVolumeRecoveryPoint(CreateSnapshotFromVolumeRecoveryPointRequest createSnapshotFromVolumeRecoveryPointRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateSnapshotFromVolumeRecoveryPointRequest> request = new CreateSnapshotFromVolumeRecoveryPointRequestMarshaller().marshall(createSnapshotFromVolumeRecoveryPointRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateSnapshotFromVolumeRecoveryPointResultJsonUnmarshaller unmarshaller = new CreateSnapshotFromVolumeRecoveryPointResultJsonUnmarshaller();
        JsonResponseHandler<CreateSnapshotFromVolumeRecoveryPointResult> responseHandler = new JsonResponseHandler<CreateSnapshotFromVolumeRecoveryPointResult>(unmarshaller);
        return (CreateSnapshotFromVolumeRecoveryPointResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdateSnapshotScheduleResult updateSnapshotSchedule(UpdateSnapshotScheduleRequest updateSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdateSnapshotScheduleRequest> request = new UpdateSnapshotScheduleRequestMarshaller().marshall(updateSnapshotScheduleRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdateSnapshotScheduleResultJsonUnmarshaller unmarshaller = new UpdateSnapshotScheduleResultJsonUnmarshaller();
        JsonResponseHandler<UpdateSnapshotScheduleResult> responseHandler = new JsonResponseHandler<UpdateSnapshotScheduleResult>(unmarshaller);
        return (UpdateSnapshotScheduleResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ActivateGatewayResult activateGateway(ActivateGatewayRequest activateGatewayRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ActivateGatewayRequest> request = new ActivateGatewayRequestMarshaller().marshall(activateGatewayRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ActivateGatewayResultJsonUnmarshaller unmarshaller = new ActivateGatewayResultJsonUnmarshaller();
        JsonResponseHandler<ActivateGatewayResult> responseHandler = new JsonResponseHandler<ActivateGatewayResult>(unmarshaller);
        return (ActivateGatewayResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdateBandwidthRateLimitResult updateBandwidthRateLimit(UpdateBandwidthRateLimitRequest updateBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdateBandwidthRateLimitRequest> request = new UpdateBandwidthRateLimitRequestMarshaller().marshall(updateBandwidthRateLimitRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdateBandwidthRateLimitResultJsonUnmarshaller unmarshaller = new UpdateBandwidthRateLimitResultJsonUnmarshaller();
        JsonResponseHandler<UpdateBandwidthRateLimitResult> responseHandler = new JsonResponseHandler<UpdateBandwidthRateLimitResult>(unmarshaller);
        return (UpdateBandwidthRateLimitResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeleteSnapshotScheduleResult deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteSnapshotScheduleRequest> request = new DeleteSnapshotScheduleRequestMarshaller().marshall(deleteSnapshotScheduleRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeleteSnapshotScheduleResultJsonUnmarshaller unmarshaller = new DeleteSnapshotScheduleResultJsonUnmarshaller();
        JsonResponseHandler<DeleteSnapshotScheduleResult> responseHandler = new JsonResponseHandler<DeleteSnapshotScheduleResult>(unmarshaller);
        return (DeleteSnapshotScheduleResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdateChapCredentialsResult updateChapCredentials(UpdateChapCredentialsRequest updateChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdateChapCredentialsRequest> request = new UpdateChapCredentialsRequestMarshaller().marshall(updateChapCredentialsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdateChapCredentialsResultJsonUnmarshaller unmarshaller = new UpdateChapCredentialsResultJsonUnmarshaller();
        JsonResponseHandler<UpdateChapCredentialsResult> responseHandler = new JsonResponseHandler<UpdateChapCredentialsResult>(unmarshaller);
        return (UpdateChapCredentialsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public AddUploadBufferResult addUploadBuffer(AddUploadBufferRequest addUploadBufferRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AddUploadBufferRequest> request = new AddUploadBufferRequestMarshaller().marshall(addUploadBufferRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        AddUploadBufferResultJsonUnmarshaller unmarshaller = new AddUploadBufferResultJsonUnmarshaller();
        JsonResponseHandler<AddUploadBufferResult> responseHandler = new JsonResponseHandler<AddUploadBufferResult>(unmarshaller);
        return (AddUploadBufferResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListVolumeRecoveryPointsResult listVolumeRecoveryPoints(ListVolumeRecoveryPointsRequest listVolumeRecoveryPointsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListVolumeRecoveryPointsRequest> request = new ListVolumeRecoveryPointsRequestMarshaller().marshall(listVolumeRecoveryPointsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListVolumeRecoveryPointsResultJsonUnmarshaller unmarshaller = new ListVolumeRecoveryPointsResultJsonUnmarshaller();
        JsonResponseHandler<ListVolumeRecoveryPointsResult> responseHandler = new JsonResponseHandler<ListVolumeRecoveryPointsResult>(unmarshaller);
        return (ListVolumeRecoveryPointsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeUploadBufferResult describeUploadBuffer(DescribeUploadBufferRequest describeUploadBufferRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeUploadBufferRequest> request = new DescribeUploadBufferRequestMarshaller().marshall(describeUploadBufferRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeUploadBufferResultJsonUnmarshaller unmarshaller = new DescribeUploadBufferResultJsonUnmarshaller();
        JsonResponseHandler<DescribeUploadBufferResult> responseHandler = new JsonResponseHandler<DescribeUploadBufferResult>(unmarshaller);
        return (DescribeUploadBufferResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public AddWorkingStorageResult addWorkingStorage(AddWorkingStorageRequest addWorkingStorageRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AddWorkingStorageRequest> request = new AddWorkingStorageRequestMarshaller().marshall(addWorkingStorageRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        AddWorkingStorageResultJsonUnmarshaller unmarshaller = new AddWorkingStorageResultJsonUnmarshaller();
        JsonResponseHandler<AddWorkingStorageResult> responseHandler = new JsonResponseHandler<AddWorkingStorageResult>(unmarshaller);
        return (AddWorkingStorageResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeCachediSCSIVolumesResult describeCachediSCSIVolumes(DescribeCachediSCSIVolumesRequest describeCachediSCSIVolumesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeCachediSCSIVolumesRequest> request = new DescribeCachediSCSIVolumesRequestMarshaller().marshall(describeCachediSCSIVolumesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeCachediSCSIVolumesResultJsonUnmarshaller unmarshaller = new DescribeCachediSCSIVolumesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeCachediSCSIVolumesResult> responseHandler = new JsonResponseHandler<DescribeCachediSCSIVolumesResult>(unmarshaller);
        return (DescribeCachediSCSIVolumesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeGatewayInformationResult describeGatewayInformation(DescribeGatewayInformationRequest describeGatewayInformationRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeGatewayInformationRequest> request = new DescribeGatewayInformationRequestMarshaller().marshall(describeGatewayInformationRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeGatewayInformationResultJsonUnmarshaller unmarshaller = new DescribeGatewayInformationResultJsonUnmarshaller();
        JsonResponseHandler<DescribeGatewayInformationResult> responseHandler = new JsonResponseHandler<DescribeGatewayInformationResult>(unmarshaller);
        return (DescribeGatewayInformationResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListGatewaysResult listGateways() throws AmazonServiceException, AmazonClientException {
        return this.listGateways(new ListGatewaysRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "storagegateway";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (X)result;
    }
}

