/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.ClusterParameterGroup;
import com.amazonaws.services.redshift.model.ClusterSecurityGroup;
import com.amazonaws.services.redshift.model.ClusterSubnetGroup;
import com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterRequest;
import com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DefaultClusterParameters;
import com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeClusterParametersResult;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsResult;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterVersionsResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest;
import com.amazonaws.services.redshift.model.DescribeEventsRequest;
import com.amazonaws.services.redshift.model.DescribeEventsResult;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsResult;
import com.amazonaws.services.redshift.model.DescribeReservedNodesRequest;
import com.amazonaws.services.redshift.model.DescribeReservedNodesResult;
import com.amazonaws.services.redshift.model.DescribeResizeRequest;
import com.amazonaws.services.redshift.model.DescribeResizeResult;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ModifyClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.ModifyClusterRequest;
import com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest;
import com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import com.amazonaws.services.redshift.model.RebootClusterRequest;
import com.amazonaws.services.redshift.model.ReservedNode;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest;
import com.amazonaws.services.redshift.model.ResetClusterParameterGroupResult;
import com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest;
import com.amazonaws.services.redshift.model.Snapshot;
import com.amazonaws.services.redshift.model.transform.AccessToSnapshotDeniedExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.AuthorizationAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.AuthorizationNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.AuthorizationQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.AuthorizeClusterSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.AuthorizeSnapshotAccessRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterParameterGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterParameterGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterParameterGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterParameterGroupStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSecurityGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSecurityGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSecurityGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSecurityGroupStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSnapshotAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSnapshotNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSnapshotQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSubnetGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSubnetGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSubnetGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSubnetGroupStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ClusterSubnetQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.CopyClusterSnapshotRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.CreateClusterParameterGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.CreateClusterRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.CreateClusterSecurityGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.CreateClusterSnapshotRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.CreateClusterSubnetGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DefaultClusterParametersStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DeleteClusterParameterGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DeleteClusterRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DeleteClusterSecurityGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DeleteClusterSnapshotRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DeleteClusterSubnetGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterParameterGroupsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterParameterGroupsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterParametersRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterParametersResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterSecurityGroupsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterSecurityGroupsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterSnapshotsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterSnapshotsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterSubnetGroupsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterSubnetGroupsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterVersionsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClusterVersionsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClustersRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeClustersResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeDefaultClusterParametersRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeOrderableClusterOptionsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeOrderableClusterOptionsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeReservedNodeOfferingsRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeReservedNodeOfferingsResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeReservedNodesRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeReservedNodesResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeResizeRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.DescribeResizeResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InsufficientClusterCapacityExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidClusterParameterGroupStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidClusterSecurityGroupStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidClusterSnapshotStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidClusterStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidClusterSubnetGroupStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidClusterSubnetStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidRestoreExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidSubnetExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.InvalidVPCNetworkStateExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ModifyClusterParameterGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.ModifyClusterParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ModifyClusterRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.ModifyClusterSubnetGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.NumberOfNodesPerClusterLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.NumberOfNodesQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.PurchaseReservedNodeOfferingRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.RebootClusterRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.ReservedNodeAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ReservedNodeNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ReservedNodeOfferingNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ReservedNodeQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ReservedNodeStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ResetClusterParameterGroupRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.ResetClusterParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.ResizeNotFoundExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.RestoreFromClusterSnapshotRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.RevokeClusterSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.RevokeSnapshotAccessRequestMarshaller;
import com.amazonaws.services.redshift.model.transform.SnapshotStaxUnmarshaller;
import com.amazonaws.services.redshift.model.transform.SubnetAlreadyInUseExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.UnauthorizedOperationExceptionUnmarshaller;
import com.amazonaws.services.redshift.model.transform.UnsupportedOptionExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRedshiftClient
extends AmazonWebServiceClient
implements AmazonRedshift {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonRedshiftClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRedshiftClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRedshiftClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRedshiftClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRedshiftClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRedshiftClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new ReservedNodeAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidClusterSubnetStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AccessToSnapshotDeniedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberOfNodesQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSnapshotQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRestoreExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientClusterCapacityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSnapshotNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidSubnetExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSecurityGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSubnetGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedNodeQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidVPCNetworkStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterParameterGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedNodeOfferingNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSecurityGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidClusterSubnetGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnsupportedOptionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubnetAlreadyInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedNodeNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSnapshotAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnauthorizedOperationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NumberOfNodesPerClusterLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidClusterStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterParameterGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidClusterParameterGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidClusterSnapshotStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSecurityGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidClusterSecurityGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSubnetGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResizeNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterParameterGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSubnetQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterSubnetGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("redshift.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/redshift/request.handlers"));
    }

    @Override
    public Snapshot revokeSnapshotAccess(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) throws AmazonServiceException, AmazonClientException {
        Request<RevokeSnapshotAccessRequest> request = new RevokeSnapshotAccessRequestMarshaller().marshall(revokeSnapshotAccessRequest);
        return this.invoke(request, new SnapshotStaxUnmarshaller());
    }

    @Override
    public ClusterSubnetGroup modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyClusterSubnetGroupRequest> request = new ModifyClusterSubnetGroupRequestMarshaller().marshall(modifyClusterSubnetGroupRequest);
        return this.invoke(request, new ClusterSubnetGroupStaxUnmarshaller());
    }

    @Override
    public ReservedNode purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) throws AmazonServiceException, AmazonClientException {
        Request<PurchaseReservedNodeOfferingRequest> request = new PurchaseReservedNodeOfferingRequestMarshaller().marshall(purchaseReservedNodeOfferingRequest);
        return this.invoke(request, new ReservedNodeStaxUnmarshaller());
    }

    @Override
    public Cluster modifyCluster(ModifyClusterRequest modifyClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyClusterRequest> request = new ModifyClusterRequestMarshaller().marshall(modifyClusterRequest);
        return this.invoke(request, new ClusterStaxUnmarshaller());
    }

    @Override
    public ModifyClusterParameterGroupResult modifyClusterParameterGroup(ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyClusterParameterGroupRequest> request = new ModifyClusterParameterGroupRequestMarshaller().marshall(modifyClusterParameterGroupRequest);
        return this.invoke(request, new ModifyClusterParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public DescribeClusterSecurityGroupsResult describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClusterSecurityGroupsRequest> request = new DescribeClusterSecurityGroupsRequestMarshaller().marshall(describeClusterSecurityGroupsRequest);
        return this.invoke(request, new DescribeClusterSecurityGroupsResultStaxUnmarshaller());
    }

    @Override
    public Snapshot copyClusterSnapshot(CopyClusterSnapshotRequest copyClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<CopyClusterSnapshotRequest> request = new CopyClusterSnapshotRequestMarshaller().marshall(copyClusterSnapshotRequest);
        return this.invoke(request, new SnapshotStaxUnmarshaller());
    }

    @Override
    public DescribeOrderableClusterOptionsResult describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeOrderableClusterOptionsRequest> request = new DescribeOrderableClusterOptionsRequestMarshaller().marshall(describeOrderableClusterOptionsRequest);
        return this.invoke(request, new DescribeOrderableClusterOptionsResultStaxUnmarshaller());
    }

    @Override
    public ClusterSubnetGroup createClusterSubnetGroup(CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateClusterSubnetGroupRequest> request = new CreateClusterSubnetGroupRequestMarshaller().marshall(createClusterSubnetGroupRequest);
        return this.invoke(request, new ClusterSubnetGroupStaxUnmarshaller());
    }

    @Override
    public Cluster rebootCluster(RebootClusterRequest rebootClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<RebootClusterRequest> request = new RebootClusterRequestMarshaller().marshall(rebootClusterRequest);
        return this.invoke(request, new ClusterStaxUnmarshaller());
    }

    @Override
    public void deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteClusterSubnetGroupRequest> request = new DeleteClusterSubnetGroupRequestMarshaller().marshall(deleteClusterSubnetGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeClusterSubnetGroupsResult describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClusterSubnetGroupsRequest> request = new DescribeClusterSubnetGroupsRequestMarshaller().marshall(describeClusterSubnetGroupsRequest);
        return this.invoke(request, new DescribeClusterSubnetGroupsResultStaxUnmarshaller());
    }

    @Override
    public Cluster deleteCluster(DeleteClusterRequest deleteClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteClusterRequest> request = new DeleteClusterRequestMarshaller().marshall(deleteClusterRequest);
        return this.invoke(request, new ClusterStaxUnmarshaller());
    }

    @Override
    public Snapshot createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateClusterSnapshotRequest> request = new CreateClusterSnapshotRequestMarshaller().marshall(createClusterSnapshotRequest);
        return this.invoke(request, new SnapshotStaxUnmarshaller());
    }

    @Override
    public Cluster createCluster(CreateClusterRequest createClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateClusterRequest> request = new CreateClusterRequestMarshaller().marshall(createClusterRequest);
        return this.invoke(request, new ClusterStaxUnmarshaller());
    }

    @Override
    public Snapshot deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteClusterSnapshotRequest> request = new DeleteClusterSnapshotRequestMarshaller().marshall(deleteClusterSnapshotRequest);
        return this.invoke(request, new SnapshotStaxUnmarshaller());
    }

    @Override
    public void deleteClusterParameterGroup(DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteClusterParameterGroupRequest> request = new DeleteClusterParameterGroupRequestMarshaller().marshall(deleteClusterParameterGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public ClusterSecurityGroup authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<AuthorizeClusterSecurityGroupIngressRequest> request = new AuthorizeClusterSecurityGroupIngressRequestMarshaller().marshall(authorizeClusterSecurityGroupIngressRequest);
        return this.invoke(request, new ClusterSecurityGroupStaxUnmarshaller());
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventsRequest> request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
        return this.invoke(request, new DescribeEventsResultStaxUnmarshaller());
    }

    @Override
    public void deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteClusterSecurityGroupRequest> request = new DeleteClusterSecurityGroupRequestMarshaller().marshall(deleteClusterSecurityGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeReservedNodesResult describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedNodesRequest> request = new DescribeReservedNodesRequestMarshaller().marshall(describeReservedNodesRequest);
        return this.invoke(request, new DescribeReservedNodesResultStaxUnmarshaller());
    }

    @Override
    public ResetClusterParameterGroupResult resetClusterParameterGroup(ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResetClusterParameterGroupRequest> request = new ResetClusterParameterGroupRequestMarshaller().marshall(resetClusterParameterGroupRequest);
        return this.invoke(request, new ResetClusterParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public DefaultClusterParameters describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDefaultClusterParametersRequest> request = new DescribeDefaultClusterParametersRequestMarshaller().marshall(describeDefaultClusterParametersRequest);
        return this.invoke(request, new DefaultClusterParametersStaxUnmarshaller());
    }

    @Override
    public ClusterSecurityGroup createClusterSecurityGroup(CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateClusterSecurityGroupRequest> request = new CreateClusterSecurityGroupRequestMarshaller().marshall(createClusterSecurityGroupRequest);
        return this.invoke(request, new ClusterSecurityGroupStaxUnmarshaller());
    }

    @Override
    public Snapshot authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) throws AmazonServiceException, AmazonClientException {
        Request<AuthorizeSnapshotAccessRequest> request = new AuthorizeSnapshotAccessRequestMarshaller().marshall(authorizeSnapshotAccessRequest);
        return this.invoke(request, new SnapshotStaxUnmarshaller());
    }

    @Override
    public DescribeReservedNodeOfferingsResult describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedNodeOfferingsRequest> request = new DescribeReservedNodeOfferingsRequestMarshaller().marshall(describeReservedNodeOfferingsRequest);
        return this.invoke(request, new DescribeReservedNodeOfferingsResultStaxUnmarshaller());
    }

    @Override
    public DescribeResizeResult describeResize(DescribeResizeRequest describeResizeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeResizeRequest> request = new DescribeResizeRequestMarshaller().marshall(describeResizeRequest);
        return this.invoke(request, new DescribeResizeResultStaxUnmarshaller());
    }

    @Override
    public DescribeClusterVersionsResult describeClusterVersions(DescribeClusterVersionsRequest describeClusterVersionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClusterVersionsRequest> request = new DescribeClusterVersionsRequestMarshaller().marshall(describeClusterVersionsRequest);
        return this.invoke(request, new DescribeClusterVersionsResultStaxUnmarshaller());
    }

    @Override
    public DescribeClusterParametersResult describeClusterParameters(DescribeClusterParametersRequest describeClusterParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClusterParametersRequest> request = new DescribeClusterParametersRequestMarshaller().marshall(describeClusterParametersRequest);
        return this.invoke(request, new DescribeClusterParametersResultStaxUnmarshaller());
    }

    @Override
    public ClusterSecurityGroup revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<RevokeClusterSecurityGroupIngressRequest> request = new RevokeClusterSecurityGroupIngressRequestMarshaller().marshall(revokeClusterSecurityGroupIngressRequest);
        return this.invoke(request, new ClusterSecurityGroupStaxUnmarshaller());
    }

    @Override
    public DescribeClustersResult describeClusters(DescribeClustersRequest describeClustersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClustersRequest> request = new DescribeClustersRequestMarshaller().marshall(describeClustersRequest);
        return this.invoke(request, new DescribeClustersResultStaxUnmarshaller());
    }

    @Override
    public DescribeClusterSnapshotsResult describeClusterSnapshots(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClusterSnapshotsRequest> request = new DescribeClusterSnapshotsRequestMarshaller().marshall(describeClusterSnapshotsRequest);
        return this.invoke(request, new DescribeClusterSnapshotsResultStaxUnmarshaller());
    }

    @Override
    public ClusterParameterGroup createClusterParameterGroup(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateClusterParameterGroupRequest> request = new CreateClusterParameterGroupRequestMarshaller().marshall(createClusterParameterGroupRequest);
        return this.invoke(request, new ClusterParameterGroupStaxUnmarshaller());
    }

    @Override
    public DescribeClusterParameterGroupsResult describeClusterParameterGroups(DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeClusterParameterGroupsRequest> request = new DescribeClusterParameterGroupsRequestMarshaller().marshall(describeClusterParameterGroupsRequest);
        return this.invoke(request, new DescribeClusterParameterGroupsResultStaxUnmarshaller());
    }

    @Override
    public Cluster restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<RestoreFromClusterSnapshotRequest> request = new RestoreFromClusterSnapshotRequestMarshaller().marshall(restoreFromClusterSnapshotRequest);
        return this.invoke(request, new ClusterStaxUnmarshaller());
    }

    @Override
    public DescribeClusterSecurityGroupsResult describeClusterSecurityGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeClusterSecurityGroups(new DescribeClusterSecurityGroupsRequest());
    }

    @Override
    public DescribeOrderableClusterOptionsResult describeOrderableClusterOptions() throws AmazonServiceException, AmazonClientException {
        return this.describeOrderableClusterOptions(new DescribeOrderableClusterOptionsRequest());
    }

    @Override
    public DescribeClusterSubnetGroupsResult describeClusterSubnetGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeClusterSubnetGroups(new DescribeClusterSubnetGroupsRequest());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    @Override
    public DescribeReservedNodesResult describeReservedNodes() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedNodes(new DescribeReservedNodesRequest());
    }

    @Override
    public DescribeReservedNodeOfferingsResult describeReservedNodeOfferings() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedNodeOfferings(new DescribeReservedNodeOfferingsRequest());
    }

    @Override
    public DescribeClusterVersionsResult describeClusterVersions() throws AmazonServiceException, AmazonClientException {
        return this.describeClusterVersions(new DescribeClusterVersionsRequest());
    }

    @Override
    public DescribeClustersResult describeClusters() throws AmazonServiceException, AmazonClientException {
        return this.describeClusters(new DescribeClustersRequest());
    }

    @Override
    public DescribeClusterSnapshotsResult describeClusterSnapshots() throws AmazonServiceException, AmazonClientException {
        return this.describeClusterSnapshots(new DescribeClusterSnapshotsRequest());
    }

    @Override
    public DescribeClusterParameterGroupsResult describeClusterParameterGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeClusterParameterGroups(new DescribeClusterParameterGroupsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "redshift";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

