/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.AppType;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAppRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String appId;
    private String name;
    private String description;
    private String type;
    private Source appSource;
    private ListWithAutoConstructFlag<String> domains;
    private Boolean enableSsl;
    private SslConfiguration sslConfiguration;
    private Map<String, String> attributes;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public UpdateAppRequest withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateAppRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateAppRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public UpdateAppRequest withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(AppType type) {
        this.type = type.toString();
    }

    public UpdateAppRequest withType(AppType type) {
        this.type = type.toString();
        return this;
    }

    public Source getAppSource() {
        return this.appSource;
    }

    public void setAppSource(Source appSource) {
        this.appSource = appSource;
    }

    public UpdateAppRequest withAppSource(Source appSource) {
        this.appSource = appSource;
        return this;
    }

    public List<String> getDomains() {
        if (this.domains == null) {
            this.domains = new ListWithAutoConstructFlag();
            this.domains.setAutoConstruct(true);
        }
        return this.domains;
    }

    public void setDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
        domainsCopy.addAll(domains);
        this.domains = domainsCopy;
    }

    public UpdateAppRequest withDomains(String ... domains) {
        if (this.getDomains() == null) {
            this.setDomains(new ArrayList<String>(domains.length));
        }
        for (String value : domains) {
            this.getDomains().add(value);
        }
        return this;
    }

    public UpdateAppRequest withDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
        } else {
            ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
            domainsCopy.addAll(domains);
            this.domains = domainsCopy;
        }
        return this;
    }

    public Boolean isEnableSsl() {
        return this.enableSsl;
    }

    public void setEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
    }

    public UpdateAppRequest withEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Boolean getEnableSsl() {
        return this.enableSsl;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public void setSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public UpdateAppRequest withSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public UpdateAppRequest withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public UpdateAppRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public UpdateAppRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppId() != null) {
            sb.append("AppId: " + this.getAppId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getAppSource() != null) {
            sb.append("AppSource: " + this.getAppSource() + ",");
        }
        if (this.getDomains() != null) {
            sb.append("Domains: " + this.getDomains() + ",");
        }
        if (this.isEnableSsl() != null) {
            sb.append("EnableSsl: " + this.isEnableSsl() + ",");
        }
        if (this.getSslConfiguration() != null) {
            sb.append("SslConfiguration: " + this.getSslConfiguration() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAppSource() == null ? 0 : this.getAppSource().hashCode());
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : ((Object)this.getDomains()).hashCode());
        hashCode = 31 * hashCode + (this.isEnableSsl() == null ? 0 : this.isEnableSsl().hashCode());
        hashCode = 31 * hashCode + (this.getSslConfiguration() == null ? 0 : this.getSslConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest)obj;
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAppSource() == null ^ this.getAppSource() == null) {
            return false;
        }
        if (other.getAppSource() != null && !other.getAppSource().equals(this.getAppSource())) {
            return false;
        }
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !((Object)other.getDomains()).equals(this.getDomains())) {
            return false;
        }
        if (other.isEnableSsl() == null ^ this.isEnableSsl() == null) {
            return false;
        }
        if (other.isEnableSsl() != null && !other.isEnableSsl().equals(this.isEnableSsl())) {
            return false;
        }
        if (other.getSslConfiguration() == null ^ this.getSslConfiguration() == null) {
            return false;
        }
        if (other.getSslConfiguration() != null && !other.getSslConfiguration().equals(this.getSslConfiguration())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || ((Object)other.getAttributes()).equals(this.getAttributes());
    }
}

