/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddJobFlowStepsRequestMarshaller
implements Marshaller<Request<AddJobFlowStepsRequest>, AddJobFlowStepsRequest> {
    @Override
    public Request<AddJobFlowStepsRequest> marshall(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        if (addJobFlowStepsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddJobFlowStepsRequest> request = new DefaultRequest<AddJobFlowStepsRequest>(addJobFlowStepsRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "AddJobFlowSteps");
        request.addParameter("Version", "2009-03-31");
        if (addJobFlowStepsRequest.getJobFlowId() != null) {
            request.addParameter("JobFlowId", StringUtils.fromString(addJobFlowStepsRequest.getJobFlowId()));
        }
        List<StepConfig> stepsList = addJobFlowStepsRequest.getSteps();
        int stepsListIndex = 1;
        for (StepConfig stepsListValue : stepsList) {
            StepConfig stepConfigMember = stepsListValue;
            if (stepConfigMember != null) {
                HadoopJarStepConfig hadoopJarStepConfigHadoopJarStep;
                if (stepConfigMember.getName() != null) {
                    request.addParameter("Steps.member." + stepsListIndex + ".Name", StringUtils.fromString(stepConfigMember.getName()));
                }
                if (stepConfigMember.getActionOnFailure() != null) {
                    request.addParameter("Steps.member." + stepsListIndex + ".ActionOnFailure", StringUtils.fromString(stepConfigMember.getActionOnFailure()));
                }
                if ((hadoopJarStepConfigHadoopJarStep = stepConfigMember.getHadoopJarStep()) != null) {
                    List<KeyValue> propertiesList = hadoopJarStepConfigHadoopJarStep.getProperties();
                    int propertiesListIndex = 1;
                    for (KeyValue propertiesListValue : propertiesList) {
                        KeyValue keyValueMember = propertiesListValue;
                        if (keyValueMember != null) {
                            if (keyValueMember.getKey() != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Properties.member." + propertiesListIndex + ".Key", StringUtils.fromString(keyValueMember.getKey()));
                            }
                            if (keyValueMember.getValue() != null) {
                                request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Properties.member." + propertiesListIndex + ".Value", StringUtils.fromString(keyValueMember.getValue()));
                            }
                        }
                        ++propertiesListIndex;
                    }
                    if (hadoopJarStepConfigHadoopJarStep.getJar() != null) {
                        request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Jar", StringUtils.fromString(hadoopJarStepConfigHadoopJarStep.getJar()));
                    }
                    if (hadoopJarStepConfigHadoopJarStep.getMainClass() != null) {
                        request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.MainClass", StringUtils.fromString(hadoopJarStepConfigHadoopJarStep.getMainClass()));
                    }
                    List<String> argsList = hadoopJarStepConfigHadoopJarStep.getArgs();
                    int argsListIndex = 1;
                    for (String argsListValue : argsList) {
                        if (argsListValue != null) {
                            request.addParameter("Steps.member." + stepsListIndex + ".HadoopJarStep.Args.member." + argsListIndex, StringUtils.fromString(argsListValue));
                        }
                        ++argsListIndex;
                    }
                }
            }
            ++stepsListIndex;
        }
        return request;
    }
}

