/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.ImportInstanceVolumeDetailItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInstanceTaskDetails
implements Serializable {
    private ListWithAutoConstructFlag<ImportInstanceVolumeDetailItem> volumes;
    private String instanceId;
    private String platform;
    private String description;

    public List<ImportInstanceVolumeDetailItem> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new ListWithAutoConstructFlag();
            this.volumes.setAutoConstruct(true);
        }
        return this.volumes;
    }

    public void setVolumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
        volumesCopy.addAll(volumes);
        this.volumes = volumesCopy;
    }

    public ImportInstanceTaskDetails withVolumes(ImportInstanceVolumeDetailItem ... volumes) {
        if (this.getVolumes() == null) {
            this.setVolumes(new ArrayList<ImportInstanceVolumeDetailItem>(volumes.length));
        }
        for (ImportInstanceVolumeDetailItem value : volumes) {
            this.getVolumes().add(value);
        }
        return this;
    }

    public ImportInstanceTaskDetails withVolumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
        if (volumes == null) {
            this.volumes = null;
        } else {
            ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
            volumesCopy.addAll(volumes);
            this.volumes = volumesCopy;
        }
        return this;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ImportInstanceTaskDetails withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public ImportInstanceTaskDetails withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImportInstanceTaskDetails withDescription(String description) {
        this.description = description;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumes() != null) {
            sb.append("Volumes: " + this.getVolumes() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: " + this.getPlatform() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : ((Object)this.getVolumes()).hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails)obj;
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !((Object)other.getVolumes()).equals(this.getVolumes())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }
}

