/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.internal.EC2MetadataClient;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider {
    protected volatile AWSCredentials credentials;
    protected volatile Date credentialsExpiration;

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.loadCredentials();
        }
        if (this.expired()) {
            throw new AmazonClientException("The credentials received from the Amazon EC2 metadata service have expired");
        }
        return this.credentials;
    }

    public void refresh() {
        this.credentials = null;
    }

    protected boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null) {
            boolean withinExpirationThreshold;
            int thresholdInMilliseconds = 300000;
            boolean bl = withinExpirationThreshold = this.credentialsExpiration.getTime() - System.currentTimeMillis() < (long)thresholdInMilliseconds;
            if (withinExpirationThreshold) {
                return true;
            }
        }
        return false;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    private synchronized void loadCredentials() {
        if (this.needsToLoadCredentials()) {
            try {
                String credentialsResponse = new EC2MetadataClient().getDefaultCredentials();
                JSONObject jsonObject = new JSONObject(credentialsResponse);
                this.credentials = jsonObject.has("Token") ? new BasicSessionCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("SecretAccessKey"), jsonObject.getString("Token")) : new BasicAWSCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("SecretAccessKey"));
                if (jsonObject.has("Expiration")) {
                    String expiration = jsonObject.getString("Expiration");
                    expiration = expiration.replaceAll("\\+0000$", "Z");
                    this.credentialsExpiration = new DateUtils().parseIso8601Date(expiration);
                }
            }
            catch (IOException e) {
                throw new AmazonClientException("Unable to load credentials from Amazon EC2 metadata service", e);
            }
            catch (JSONException e) {
                throw new AmazonClientException("Unable to parse credentials from Amazon EC2 metadata service", e);
            }
            catch (ParseException e) {
                throw new AmazonClientException("Unable to parse credentials expiration date from Amazon EC2 metadata service", e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

