/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Subnet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSubnetGroup
implements Serializable {
    private String dBSubnetGroupName;
    private String dBSubnetGroupDescription;
    private String vpcId;
    private String subnetGroupStatus;
    private ListWithAutoConstructFlag<Subnet> subnets;

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    public DBSubnetGroup withDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
        return this;
    }

    public String getDBSubnetGroupDescription() {
        return this.dBSubnetGroupDescription;
    }

    public void setDBSubnetGroupDescription(String dBSubnetGroupDescription) {
        this.dBSubnetGroupDescription = dBSubnetGroupDescription;
    }

    public DBSubnetGroup withDBSubnetGroupDescription(String dBSubnetGroupDescription) {
        this.dBSubnetGroupDescription = dBSubnetGroupDescription;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public DBSubnetGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getSubnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public void setSubnetGroupStatus(String subnetGroupStatus) {
        this.subnetGroupStatus = subnetGroupStatus;
    }

    public DBSubnetGroup withSubnetGroupStatus(String subnetGroupStatus) {
        this.subnetGroupStatus = subnetGroupStatus;
        return this;
    }

    public List<Subnet> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ListWithAutoConstructFlag();
            this.subnets.setAutoConstruct(true);
        }
        return this.subnets;
    }

    public void setSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public DBSubnetGroup withSubnets(Subnet ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<Subnet>(subnets.length));
        }
        for (Subnet value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public DBSubnetGroup withSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: " + this.getDBSubnetGroupName() + ",");
        }
        if (this.getDBSubnetGroupDescription() != null) {
            sb.append("DBSubnetGroupDescription: " + this.getDBSubnetGroupDescription() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getSubnetGroupStatus() != null) {
            sb.append("SubnetGroupStatus: " + this.getSubnetGroupStatus() + ",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBSubnetGroupName() == null ? 0 : this.getDBSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroupDescription() == null ? 0 : this.getDBSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetGroupStatus() == null ? 0 : this.getSubnetGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : ((Object)this.getSubnets()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSubnetGroup)) {
            return false;
        }
        DBSubnetGroup other = (DBSubnetGroup)obj;
        if (other.getDBSubnetGroupName() == null ^ this.getDBSubnetGroupName() == null) {
            return false;
        }
        if (other.getDBSubnetGroupName() != null && !other.getDBSubnetGroupName().equals(this.getDBSubnetGroupName())) {
            return false;
        }
        if (other.getDBSubnetGroupDescription() == null ^ this.getDBSubnetGroupDescription() == null) {
            return false;
        }
        if (other.getDBSubnetGroupDescription() != null && !other.getDBSubnetGroupDescription().equals(this.getDBSubnetGroupDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetGroupStatus() == null ^ this.getSubnetGroupStatus() == null) {
            return false;
        }
        if (other.getSubnetGroupStatus() != null && !other.getSubnetGroupStatus().equals(this.getSubnetGroupStatus())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || ((Object)other.getSubnets()).equals(this.getSubnets());
    }
}

