/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.ValidationError;
import com.amazonaws.services.datapipeline.model.ValidationWarning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutPipelineDefinitionResult
implements Serializable {
    private ListWithAutoConstructFlag<ValidationError> validationErrors;
    private ListWithAutoConstructFlag<ValidationWarning> validationWarnings;
    private Boolean errored;

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors == null) {
            this.validationErrors = new ListWithAutoConstructFlag();
            this.validationErrors.setAutoConstruct(true);
        }
        return this.validationErrors;
    }

    public void setValidationErrors(Collection<ValidationError> validationErrors) {
        if (validationErrors == null) {
            this.validationErrors = null;
            return;
        }
        ListWithAutoConstructFlag validationErrorsCopy = new ListWithAutoConstructFlag(validationErrors.size());
        validationErrorsCopy.addAll(validationErrors);
        this.validationErrors = validationErrorsCopy;
    }

    public PutPipelineDefinitionResult withValidationErrors(ValidationError ... validationErrors) {
        if (this.getValidationErrors() == null) {
            this.setValidationErrors(new ArrayList<ValidationError>(validationErrors.length));
        }
        for (ValidationError value : validationErrors) {
            this.getValidationErrors().add(value);
        }
        return this;
    }

    public PutPipelineDefinitionResult withValidationErrors(Collection<ValidationError> validationErrors) {
        if (validationErrors == null) {
            this.validationErrors = null;
        } else {
            ListWithAutoConstructFlag validationErrorsCopy = new ListWithAutoConstructFlag(validationErrors.size());
            validationErrorsCopy.addAll(validationErrors);
            this.validationErrors = validationErrorsCopy;
        }
        return this;
    }

    public List<ValidationWarning> getValidationWarnings() {
        if (this.validationWarnings == null) {
            this.validationWarnings = new ListWithAutoConstructFlag();
            this.validationWarnings.setAutoConstruct(true);
        }
        return this.validationWarnings;
    }

    public void setValidationWarnings(Collection<ValidationWarning> validationWarnings) {
        if (validationWarnings == null) {
            this.validationWarnings = null;
            return;
        }
        ListWithAutoConstructFlag validationWarningsCopy = new ListWithAutoConstructFlag(validationWarnings.size());
        validationWarningsCopy.addAll(validationWarnings);
        this.validationWarnings = validationWarningsCopy;
    }

    public PutPipelineDefinitionResult withValidationWarnings(ValidationWarning ... validationWarnings) {
        if (this.getValidationWarnings() == null) {
            this.setValidationWarnings(new ArrayList<ValidationWarning>(validationWarnings.length));
        }
        for (ValidationWarning value : validationWarnings) {
            this.getValidationWarnings().add(value);
        }
        return this;
    }

    public PutPipelineDefinitionResult withValidationWarnings(Collection<ValidationWarning> validationWarnings) {
        if (validationWarnings == null) {
            this.validationWarnings = null;
        } else {
            ListWithAutoConstructFlag validationWarningsCopy = new ListWithAutoConstructFlag(validationWarnings.size());
            validationWarningsCopy.addAll(validationWarnings);
            this.validationWarnings = validationWarningsCopy;
        }
        return this;
    }

    public Boolean isErrored() {
        return this.errored;
    }

    public void setErrored(Boolean errored) {
        this.errored = errored;
    }

    public PutPipelineDefinitionResult withErrored(Boolean errored) {
        this.errored = errored;
        return this;
    }

    public Boolean getErrored() {
        return this.errored;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValidationErrors() != null) {
            sb.append("ValidationErrors: " + this.getValidationErrors() + ",");
        }
        if (this.getValidationWarnings() != null) {
            sb.append("ValidationWarnings: " + this.getValidationWarnings() + ",");
        }
        if (this.isErrored() != null) {
            sb.append("Errored: " + this.isErrored());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValidationErrors() == null ? 0 : ((Object)this.getValidationErrors()).hashCode());
        hashCode = 31 * hashCode + (this.getValidationWarnings() == null ? 0 : ((Object)this.getValidationWarnings()).hashCode());
        hashCode = 31 * hashCode + (this.isErrored() == null ? 0 : this.isErrored().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionResult)) {
            return false;
        }
        PutPipelineDefinitionResult other = (PutPipelineDefinitionResult)obj;
        if (other.getValidationErrors() == null ^ this.getValidationErrors() == null) {
            return false;
        }
        if (other.getValidationErrors() != null && !((Object)other.getValidationErrors()).equals(this.getValidationErrors())) {
            return false;
        }
        if (other.getValidationWarnings() == null ^ this.getValidationWarnings() == null) {
            return false;
        }
        if (other.getValidationWarnings() != null && !((Object)other.getValidationWarnings()).equals(this.getValidationWarnings())) {
            return false;
        }
        if (other.isErrored() == null ^ this.isErrored() == null) {
            return false;
        }
        return other.isErrored() == null || other.isErrored().equals(this.isErrored());
    }
}

