/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vpc
implements Serializable {
    private String vpcId;
    private String state;
    private String cidrBlock;
    private String dhcpOptionsId;
    private ListWithAutoConstructFlag<Tag> tags;
    private String instanceTenancy;
    private Boolean isDefault;

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Vpc withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Vpc withState(String state) {
        this.state = state;
        return this;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public Vpc withCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
        return this;
    }

    public String getDhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public void setDhcpOptionsId(String dhcpOptionsId) {
        this.dhcpOptionsId = dhcpOptionsId;
    }

    public Vpc withDhcpOptionsId(String dhcpOptionsId) {
        this.dhcpOptionsId = dhcpOptionsId;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Vpc withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Vpc withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getInstanceTenancy() {
        return this.instanceTenancy;
    }

    public void setInstanceTenancy(String instanceTenancy) {
        this.instanceTenancy = instanceTenancy;
    }

    public Vpc withInstanceTenancy(String instanceTenancy) {
        this.instanceTenancy = instanceTenancy;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Vpc withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: " + this.getCidrBlock() + ",");
        }
        if (this.getDhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: " + this.getDhcpOptionsId() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getInstanceTenancy() != null) {
            sb.append("InstanceTenancy: " + this.getInstanceTenancy() + ",");
        }
        if (this.isDefault() != null) {
            sb.append("IsDefault: " + this.isDefault());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getDhcpOptionsId() == null ? 0 : this.getDhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTenancy() == null ? 0 : this.getInstanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.isDefault() == null ? 0 : this.isDefault().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc)obj;
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getDhcpOptionsId() == null ^ this.getDhcpOptionsId() == null) {
            return false;
        }
        if (other.getDhcpOptionsId() != null && !other.getDhcpOptionsId().equals(this.getDhcpOptionsId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getInstanceTenancy() == null ^ this.getInstanceTenancy() == null) {
            return false;
        }
        if (other.getInstanceTenancy() != null && !other.getInstanceTenancy().equals(this.getInstanceTenancy())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        return other.isDefault() == null || other.isDefault().equals(this.isDefault());
    }
}

