/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudwatch.model.ComparisonOperator;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.StateValue;
import com.amazonaws.services.cloudwatch.model.Statistic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricAlarm
implements Serializable {
    private String alarmName;
    private String alarmArn;
    private String alarmDescription;
    private Date alarmConfigurationUpdatedTimestamp;
    private Boolean actionsEnabled;
    private ListWithAutoConstructFlag<String> oKActions;
    private ListWithAutoConstructFlag<String> alarmActions;
    private ListWithAutoConstructFlag<String> insufficientDataActions;
    private String stateValue;
    private String stateReason;
    private String stateReasonData;
    private Date stateUpdatedTimestamp;
    private String metricName;
    private String namespace;
    private String statistic;
    private ListWithAutoConstructFlag<Dimension> dimensions;
    private Integer period;
    private String unit;
    private Integer evaluationPeriods;
    private Double threshold;
    private String comparisonOperator;

    public String getAlarmName() {
        return this.alarmName;
    }

    public void setAlarmName(String alarmName) {
        this.alarmName = alarmName;
    }

    public MetricAlarm withAlarmName(String alarmName) {
        this.alarmName = alarmName;
        return this;
    }

    public String getAlarmArn() {
        return this.alarmArn;
    }

    public void setAlarmArn(String alarmArn) {
        this.alarmArn = alarmArn;
    }

    public MetricAlarm withAlarmArn(String alarmArn) {
        this.alarmArn = alarmArn;
        return this;
    }

    public String getAlarmDescription() {
        return this.alarmDescription;
    }

    public void setAlarmDescription(String alarmDescription) {
        this.alarmDescription = alarmDescription;
    }

    public MetricAlarm withAlarmDescription(String alarmDescription) {
        this.alarmDescription = alarmDescription;
        return this;
    }

    public Date getAlarmConfigurationUpdatedTimestamp() {
        return this.alarmConfigurationUpdatedTimestamp;
    }

    public void setAlarmConfigurationUpdatedTimestamp(Date alarmConfigurationUpdatedTimestamp) {
        this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
    }

    public MetricAlarm withAlarmConfigurationUpdatedTimestamp(Date alarmConfigurationUpdatedTimestamp) {
        this.alarmConfigurationUpdatedTimestamp = alarmConfigurationUpdatedTimestamp;
        return this;
    }

    public Boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public void setActionsEnabled(Boolean actionsEnabled) {
        this.actionsEnabled = actionsEnabled;
    }

    public MetricAlarm withActionsEnabled(Boolean actionsEnabled) {
        this.actionsEnabled = actionsEnabled;
        return this;
    }

    public Boolean getActionsEnabled() {
        return this.actionsEnabled;
    }

    public List<String> getOKActions() {
        if (this.oKActions == null) {
            this.oKActions = new ListWithAutoConstructFlag();
            this.oKActions.setAutoConstruct(true);
        }
        return this.oKActions;
    }

    public void setOKActions(Collection<String> oKActions) {
        if (oKActions == null) {
            this.oKActions = null;
            return;
        }
        ListWithAutoConstructFlag oKActionsCopy = new ListWithAutoConstructFlag(oKActions.size());
        oKActionsCopy.addAll(oKActions);
        this.oKActions = oKActionsCopy;
    }

    public MetricAlarm withOKActions(String ... oKActions) {
        if (this.getOKActions() == null) {
            this.setOKActions(new ArrayList<String>(oKActions.length));
        }
        for (String value : oKActions) {
            this.getOKActions().add(value);
        }
        return this;
    }

    public MetricAlarm withOKActions(Collection<String> oKActions) {
        if (oKActions == null) {
            this.oKActions = null;
        } else {
            ListWithAutoConstructFlag oKActionsCopy = new ListWithAutoConstructFlag(oKActions.size());
            oKActionsCopy.addAll(oKActions);
            this.oKActions = oKActionsCopy;
        }
        return this;
    }

    public List<String> getAlarmActions() {
        if (this.alarmActions == null) {
            this.alarmActions = new ListWithAutoConstructFlag();
            this.alarmActions.setAutoConstruct(true);
        }
        return this.alarmActions;
    }

    public void setAlarmActions(Collection<String> alarmActions) {
        if (alarmActions == null) {
            this.alarmActions = null;
            return;
        }
        ListWithAutoConstructFlag alarmActionsCopy = new ListWithAutoConstructFlag(alarmActions.size());
        alarmActionsCopy.addAll(alarmActions);
        this.alarmActions = alarmActionsCopy;
    }

    public MetricAlarm withAlarmActions(String ... alarmActions) {
        if (this.getAlarmActions() == null) {
            this.setAlarmActions(new ArrayList<String>(alarmActions.length));
        }
        for (String value : alarmActions) {
            this.getAlarmActions().add(value);
        }
        return this;
    }

    public MetricAlarm withAlarmActions(Collection<String> alarmActions) {
        if (alarmActions == null) {
            this.alarmActions = null;
        } else {
            ListWithAutoConstructFlag alarmActionsCopy = new ListWithAutoConstructFlag(alarmActions.size());
            alarmActionsCopy.addAll(alarmActions);
            this.alarmActions = alarmActionsCopy;
        }
        return this;
    }

    public List<String> getInsufficientDataActions() {
        if (this.insufficientDataActions == null) {
            this.insufficientDataActions = new ListWithAutoConstructFlag();
            this.insufficientDataActions.setAutoConstruct(true);
        }
        return this.insufficientDataActions;
    }

    public void setInsufficientDataActions(Collection<String> insufficientDataActions) {
        if (insufficientDataActions == null) {
            this.insufficientDataActions = null;
            return;
        }
        ListWithAutoConstructFlag insufficientDataActionsCopy = new ListWithAutoConstructFlag(insufficientDataActions.size());
        insufficientDataActionsCopy.addAll(insufficientDataActions);
        this.insufficientDataActions = insufficientDataActionsCopy;
    }

    public MetricAlarm withInsufficientDataActions(String ... insufficientDataActions) {
        if (this.getInsufficientDataActions() == null) {
            this.setInsufficientDataActions(new ArrayList<String>(insufficientDataActions.length));
        }
        for (String value : insufficientDataActions) {
            this.getInsufficientDataActions().add(value);
        }
        return this;
    }

    public MetricAlarm withInsufficientDataActions(Collection<String> insufficientDataActions) {
        if (insufficientDataActions == null) {
            this.insufficientDataActions = null;
        } else {
            ListWithAutoConstructFlag insufficientDataActionsCopy = new ListWithAutoConstructFlag(insufficientDataActions.size());
            insufficientDataActionsCopy.addAll(insufficientDataActions);
            this.insufficientDataActions = insufficientDataActionsCopy;
        }
        return this;
    }

    public String getStateValue() {
        return this.stateValue;
    }

    public void setStateValue(String stateValue) {
        this.stateValue = stateValue;
    }

    public MetricAlarm withStateValue(String stateValue) {
        this.stateValue = stateValue;
        return this;
    }

    public void setStateValue(StateValue stateValue) {
        this.stateValue = stateValue.toString();
    }

    public MetricAlarm withStateValue(StateValue stateValue) {
        this.stateValue = stateValue.toString();
        return this;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public void setStateReason(String stateReason) {
        this.stateReason = stateReason;
    }

    public MetricAlarm withStateReason(String stateReason) {
        this.stateReason = stateReason;
        return this;
    }

    public String getStateReasonData() {
        return this.stateReasonData;
    }

    public void setStateReasonData(String stateReasonData) {
        this.stateReasonData = stateReasonData;
    }

    public MetricAlarm withStateReasonData(String stateReasonData) {
        this.stateReasonData = stateReasonData;
        return this;
    }

    public Date getStateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public void setStateUpdatedTimestamp(Date stateUpdatedTimestamp) {
        this.stateUpdatedTimestamp = stateUpdatedTimestamp;
    }

    public MetricAlarm withStateUpdatedTimestamp(Date stateUpdatedTimestamp) {
        this.stateUpdatedTimestamp = stateUpdatedTimestamp;
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public MetricAlarm withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public MetricAlarm withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public void setStatistic(String statistic) {
        this.statistic = statistic;
    }

    public MetricAlarm withStatistic(String statistic) {
        this.statistic = statistic;
        return this;
    }

    public void setStatistic(Statistic statistic) {
        this.statistic = statistic.toString();
    }

    public MetricAlarm withStatistic(Statistic statistic) {
        this.statistic = statistic.toString();
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new ListWithAutoConstructFlag();
            this.dimensions.setAutoConstruct(true);
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
        dimensionsCopy.addAll(dimensions);
        this.dimensions = dimensionsCopy;
    }

    public MetricAlarm withDimensions(Dimension ... dimensions) {
        if (this.getDimensions() == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension value : dimensions) {
            this.getDimensions().add(value);
        }
        return this;
    }

    public MetricAlarm withDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
        } else {
            ListWithAutoConstructFlag dimensionsCopy = new ListWithAutoConstructFlag(dimensions.size());
            dimensionsCopy.addAll(dimensions);
            this.dimensions = dimensionsCopy;
        }
        return this;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public MetricAlarm withPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MetricAlarm withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public void setUnit(StandardUnit unit) {
        this.unit = unit.toString();
    }

    public MetricAlarm withUnit(StandardUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public Integer getEvaluationPeriods() {
        return this.evaluationPeriods;
    }

    public void setEvaluationPeriods(Integer evaluationPeriods) {
        this.evaluationPeriods = evaluationPeriods;
    }

    public MetricAlarm withEvaluationPeriods(Integer evaluationPeriods) {
        this.evaluationPeriods = evaluationPeriods;
        return this;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public MetricAlarm withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public String getComparisonOperator() {
        return this.comparisonOperator;
    }

    public void setComparisonOperator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public MetricAlarm withComparisonOperator(String comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
        return this;
    }

    public void setComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator.toString();
    }

    public MetricAlarm withComparisonOperator(ComparisonOperator comparisonOperator) {
        this.comparisonOperator = comparisonOperator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlarmName() != null) {
            sb.append("AlarmName: " + this.getAlarmName() + ",");
        }
        if (this.getAlarmArn() != null) {
            sb.append("AlarmArn: " + this.getAlarmArn() + ",");
        }
        if (this.getAlarmDescription() != null) {
            sb.append("AlarmDescription: " + this.getAlarmDescription() + ",");
        }
        if (this.getAlarmConfigurationUpdatedTimestamp() != null) {
            sb.append("AlarmConfigurationUpdatedTimestamp: " + this.getAlarmConfigurationUpdatedTimestamp() + ",");
        }
        if (this.isActionsEnabled() != null) {
            sb.append("ActionsEnabled: " + this.isActionsEnabled() + ",");
        }
        if (this.getOKActions() != null) {
            sb.append("OKActions: " + this.getOKActions() + ",");
        }
        if (this.getAlarmActions() != null) {
            sb.append("AlarmActions: " + this.getAlarmActions() + ",");
        }
        if (this.getInsufficientDataActions() != null) {
            sb.append("InsufficientDataActions: " + this.getInsufficientDataActions() + ",");
        }
        if (this.getStateValue() != null) {
            sb.append("StateValue: " + this.getStateValue() + ",");
        }
        if (this.getStateReason() != null) {
            sb.append("StateReason: " + this.getStateReason() + ",");
        }
        if (this.getStateReasonData() != null) {
            sb.append("StateReasonData: " + this.getStateReasonData() + ",");
        }
        if (this.getStateUpdatedTimestamp() != null) {
            sb.append("StateUpdatedTimestamp: " + this.getStateUpdatedTimestamp() + ",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: " + this.getMetricName() + ",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: " + this.getNamespace() + ",");
        }
        if (this.getStatistic() != null) {
            sb.append("Statistic: " + this.getStatistic() + ",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: " + this.getDimensions() + ",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: " + this.getPeriod() + ",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: " + this.getUnit() + ",");
        }
        if (this.getEvaluationPeriods() != null) {
            sb.append("EvaluationPeriods: " + this.getEvaluationPeriods() + ",");
        }
        if (this.getThreshold() != null) {
            sb.append("Threshold: " + this.getThreshold() + ",");
        }
        if (this.getComparisonOperator() != null) {
            sb.append("ComparisonOperator: " + this.getComparisonOperator());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlarmName() == null ? 0 : this.getAlarmName().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmArn() == null ? 0 : this.getAlarmArn().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmDescription() == null ? 0 : this.getAlarmDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmConfigurationUpdatedTimestamp() == null ? 0 : this.getAlarmConfigurationUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.isActionsEnabled() == null ? 0 : this.isActionsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getOKActions() == null ? 0 : ((Object)this.getOKActions()).hashCode());
        hashCode = 31 * hashCode + (this.getAlarmActions() == null ? 0 : ((Object)this.getAlarmActions()).hashCode());
        hashCode = 31 * hashCode + (this.getInsufficientDataActions() == null ? 0 : ((Object)this.getInsufficientDataActions()).hashCode());
        hashCode = 31 * hashCode + (this.getStateValue() == null ? 0 : this.getStateValue().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getStateReasonData() == null ? 0 : this.getStateReasonData().hashCode());
        hashCode = 31 * hashCode + (this.getStateUpdatedTimestamp() == null ? 0 : this.getStateUpdatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getStatistic() == null ? 0 : this.getStatistic().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : ((Object)this.getDimensions()).hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationPeriods() == null ? 0 : this.getEvaluationPeriods().hashCode());
        hashCode = 31 * hashCode + (this.getThreshold() == null ? 0 : this.getThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getComparisonOperator() == null ? 0 : this.getComparisonOperator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricAlarm)) {
            return false;
        }
        MetricAlarm other = (MetricAlarm)obj;
        if (other.getAlarmName() == null ^ this.getAlarmName() == null) {
            return false;
        }
        if (other.getAlarmName() != null && !other.getAlarmName().equals(this.getAlarmName())) {
            return false;
        }
        if (other.getAlarmArn() == null ^ this.getAlarmArn() == null) {
            return false;
        }
        if (other.getAlarmArn() != null && !other.getAlarmArn().equals(this.getAlarmArn())) {
            return false;
        }
        if (other.getAlarmDescription() == null ^ this.getAlarmDescription() == null) {
            return false;
        }
        if (other.getAlarmDescription() != null && !other.getAlarmDescription().equals(this.getAlarmDescription())) {
            return false;
        }
        if (other.getAlarmConfigurationUpdatedTimestamp() == null ^ this.getAlarmConfigurationUpdatedTimestamp() == null) {
            return false;
        }
        if (other.getAlarmConfigurationUpdatedTimestamp() != null && !other.getAlarmConfigurationUpdatedTimestamp().equals(this.getAlarmConfigurationUpdatedTimestamp())) {
            return false;
        }
        if (other.isActionsEnabled() == null ^ this.isActionsEnabled() == null) {
            return false;
        }
        if (other.isActionsEnabled() != null && !other.isActionsEnabled().equals(this.isActionsEnabled())) {
            return false;
        }
        if (other.getOKActions() == null ^ this.getOKActions() == null) {
            return false;
        }
        if (other.getOKActions() != null && !((Object)other.getOKActions()).equals(this.getOKActions())) {
            return false;
        }
        if (other.getAlarmActions() == null ^ this.getAlarmActions() == null) {
            return false;
        }
        if (other.getAlarmActions() != null && !((Object)other.getAlarmActions()).equals(this.getAlarmActions())) {
            return false;
        }
        if (other.getInsufficientDataActions() == null ^ this.getInsufficientDataActions() == null) {
            return false;
        }
        if (other.getInsufficientDataActions() != null && !((Object)other.getInsufficientDataActions()).equals(this.getInsufficientDataActions())) {
            return false;
        }
        if (other.getStateValue() == null ^ this.getStateValue() == null) {
            return false;
        }
        if (other.getStateValue() != null && !other.getStateValue().equals(this.getStateValue())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getStateReasonData() == null ^ this.getStateReasonData() == null) {
            return false;
        }
        if (other.getStateReasonData() != null && !other.getStateReasonData().equals(this.getStateReasonData())) {
            return false;
        }
        if (other.getStateUpdatedTimestamp() == null ^ this.getStateUpdatedTimestamp() == null) {
            return false;
        }
        if (other.getStateUpdatedTimestamp() != null && !other.getStateUpdatedTimestamp().equals(this.getStateUpdatedTimestamp())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getStatistic() == null ^ this.getStatistic() == null) {
            return false;
        }
        if (other.getStatistic() != null && !other.getStatistic().equals(this.getStatistic())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !((Object)other.getDimensions()).equals(this.getDimensions())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        if (other.getUnit() != null && !other.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (other.getEvaluationPeriods() == null ^ this.getEvaluationPeriods() == null) {
            return false;
        }
        if (other.getEvaluationPeriods() != null && !other.getEvaluationPeriods().equals(this.getEvaluationPeriods())) {
            return false;
        }
        if (other.getThreshold() == null ^ this.getThreshold() == null) {
            return false;
        }
        if (other.getThreshold() != null && !other.getThreshold().equals(this.getThreshold())) {
            return false;
        }
        if (other.getComparisonOperator() == null ^ this.getComparisonOperator() == null) {
            return false;
        }
        return other.getComparisonOperator() == null || other.getComparisonOperator().equals(this.getComparisonOperator());
    }
}

