/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstimateTemplateCostRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String templateBody;
    private String templateURL;
    private ListWithAutoConstructFlag<Parameter> parameters;

    public String getTemplateBody() {
        return this.templateBody;
    }

    public void setTemplateBody(String templateBody) {
        this.templateBody = templateBody;
    }

    public EstimateTemplateCostRequest withTemplateBody(String templateBody) {
        this.templateBody = templateBody;
        return this;
    }

    public String getTemplateURL() {
        return this.templateURL;
    }

    public void setTemplateURL(String templateURL) {
        this.templateURL = templateURL;
    }

    public EstimateTemplateCostRequest withTemplateURL(String templateURL) {
        this.templateURL = templateURL;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ListWithAutoConstructFlag();
            this.parameters.setAutoConstruct(true);
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public EstimateTemplateCostRequest withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public EstimateTemplateCostRequest withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ListWithAutoConstructFlag parametersCopy = new ListWithAutoConstructFlag(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTemplateBody() != null) {
            sb.append("TemplateBody: " + this.getTemplateBody() + ",");
        }
        if (this.getTemplateURL() != null) {
            sb.append("TemplateURL: " + this.getTemplateURL() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTemplateBody() == null ? 0 : this.getTemplateBody().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateURL() == null ? 0 : this.getTemplateURL().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimateTemplateCostRequest)) {
            return false;
        }
        EstimateTemplateCostRequest other = (EstimateTemplateCostRequest)obj;
        if (other.getTemplateBody() == null ^ this.getTemplateBody() == null) {
            return false;
        }
        if (other.getTemplateBody() != null && !other.getTemplateBody().equals(this.getTemplateBody())) {
            return false;
        }
        if (other.getTemplateURL() == null ^ this.getTemplateURL() == null) {
            return false;
        }
        if (other.getTemplateURL() != null && !other.getTemplateURL().equals(this.getTemplateURL())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || ((Object)other.getParameters()).equals(this.getParameters());
    }
}

