/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.PipelineObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutPipelineDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String pipelineId;
    private ListWithAutoConstructFlag<PipelineObject> pipelineObjects;

    public String getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public PutPipelineDefinitionRequest withPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
        return this;
    }

    public List<PipelineObject> getPipelineObjects() {
        if (this.pipelineObjects == null) {
            this.pipelineObjects = new ListWithAutoConstructFlag();
            this.pipelineObjects.setAutoConstruct(true);
        }
        return this.pipelineObjects;
    }

    public void setPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        if (pipelineObjects == null) {
            this.pipelineObjects = null;
            return;
        }
        ListWithAutoConstructFlag pipelineObjectsCopy = new ListWithAutoConstructFlag(pipelineObjects.size());
        pipelineObjectsCopy.addAll(pipelineObjects);
        this.pipelineObjects = pipelineObjectsCopy;
    }

    public PutPipelineDefinitionRequest withPipelineObjects(PipelineObject ... pipelineObjects) {
        if (this.getPipelineObjects() == null) {
            this.setPipelineObjects(new ArrayList<PipelineObject>(pipelineObjects.length));
        }
        for (PipelineObject value : pipelineObjects) {
            this.getPipelineObjects().add(value);
        }
        return this;
    }

    public PutPipelineDefinitionRequest withPipelineObjects(Collection<PipelineObject> pipelineObjects) {
        if (pipelineObjects == null) {
            this.pipelineObjects = null;
        } else {
            ListWithAutoConstructFlag pipelineObjectsCopy = new ListWithAutoConstructFlag(pipelineObjects.size());
            pipelineObjectsCopy.addAll(pipelineObjects);
            this.pipelineObjects = pipelineObjectsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: " + this.getPipelineId() + ",");
        }
        if (this.getPipelineObjects() != null) {
            sb.append("PipelineObjects: " + this.getPipelineObjects());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineObjects() == null ? 0 : ((Object)this.getPipelineObjects()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPipelineDefinitionRequest)) {
            return false;
        }
        PutPipelineDefinitionRequest other = (PutPipelineDefinitionRequest)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getPipelineObjects() == null ^ this.getPipelineObjects() == null) {
            return false;
        }
        return other.getPipelineObjects() == null || ((Object)other.getPipelineObjects()).equals(this.getPipelineObjects());
    }
}

