/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CopyImageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyImageRequestMarshaller
implements Marshaller<Request<CopyImageRequest>, CopyImageRequest> {
    @Override
    public Request<CopyImageRequest> marshall(CopyImageRequest copyImageRequest) {
        if (copyImageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyImageRequest> request = new DefaultRequest<CopyImageRequest>(copyImageRequest, "AmazonEC2");
        request.addParameter("Action", "CopyImage");
        request.addParameter("Version", "2013-02-01");
        if (copyImageRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString(copyImageRequest.getSourceRegion()));
        }
        if (copyImageRequest.getSourceImageId() != null) {
            request.addParameter("SourceImageId", StringUtils.fromString(copyImageRequest.getSourceImageId()));
        }
        if (copyImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(copyImageRequest.getName()));
        }
        if (copyImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(copyImageRequest.getDescription()));
        }
        if (copyImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(copyImageRequest.getClientToken()));
        }
        return request;
    }
}

