/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeSpotPriceHistoryRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Date startTime;
    private Date endTime;
    private ListWithAutoConstructFlag<String> instanceTypes;
    private ListWithAutoConstructFlag<String> productDescriptions;
    private ListWithAutoConstructFlag<Filter> filters;
    private String availabilityZone;
    private Integer maxResults;
    private String nextToken;

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public DescribeSpotPriceHistoryRequest withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public DescribeSpotPriceHistoryRequest withEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<String> getInstanceTypes() {
        if (this.instanceTypes == null) {
            this.instanceTypes = new ListWithAutoConstructFlag();
            this.instanceTypes.setAutoConstruct(true);
        }
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        ListWithAutoConstructFlag instanceTypesCopy = new ListWithAutoConstructFlag(instanceTypes.size());
        instanceTypesCopy.addAll(instanceTypes);
        this.instanceTypes = instanceTypesCopy;
    }

    public DescribeSpotPriceHistoryRequest withInstanceTypes(String ... instanceTypes) {
        if (this.getInstanceTypes() == null) {
            this.setInstanceTypes(new ArrayList<String>(instanceTypes.length));
        }
        for (String value : instanceTypes) {
            this.getInstanceTypes().add(value);
        }
        return this;
    }

    public DescribeSpotPriceHistoryRequest withInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
        } else {
            ListWithAutoConstructFlag instanceTypesCopy = new ListWithAutoConstructFlag(instanceTypes.size());
            instanceTypesCopy.addAll(instanceTypes);
            this.instanceTypes = instanceTypesCopy;
        }
        return this;
    }

    public List<String> getProductDescriptions() {
        if (this.productDescriptions == null) {
            this.productDescriptions = new ListWithAutoConstructFlag();
            this.productDescriptions.setAutoConstruct(true);
        }
        return this.productDescriptions;
    }

    public void setProductDescriptions(Collection<String> productDescriptions) {
        if (productDescriptions == null) {
            this.productDescriptions = null;
            return;
        }
        ListWithAutoConstructFlag productDescriptionsCopy = new ListWithAutoConstructFlag(productDescriptions.size());
        productDescriptionsCopy.addAll(productDescriptions);
        this.productDescriptions = productDescriptionsCopy;
    }

    public DescribeSpotPriceHistoryRequest withProductDescriptions(String ... productDescriptions) {
        if (this.getProductDescriptions() == null) {
            this.setProductDescriptions(new ArrayList<String>(productDescriptions.length));
        }
        for (String value : productDescriptions) {
            this.getProductDescriptions().add(value);
        }
        return this;
    }

    public DescribeSpotPriceHistoryRequest withProductDescriptions(Collection<String> productDescriptions) {
        if (productDescriptions == null) {
            this.productDescriptions = null;
        } else {
            ListWithAutoConstructFlag productDescriptionsCopy = new ListWithAutoConstructFlag(productDescriptions.size());
            productDescriptionsCopy.addAll(productDescriptions);
            this.productDescriptions = productDescriptionsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeSpotPriceHistoryRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeSpotPriceHistoryRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public DescribeSpotPriceHistoryRequest withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeSpotPriceHistoryRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeSpotPriceHistoryRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: " + this.getEndTime() + ",");
        }
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: " + this.getInstanceTypes() + ",");
        }
        if (this.getProductDescriptions() != null) {
            sb.append("ProductDescriptions: " + this.getProductDescriptions() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : ((Object)this.getInstanceTypes()).hashCode());
        hashCode = 31 * hashCode + (this.getProductDescriptions() == null ? 0 : ((Object)this.getProductDescriptions()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryRequest)) {
            return false;
        }
        DescribeSpotPriceHistoryRequest other = (DescribeSpotPriceHistoryRequest)obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !((Object)other.getInstanceTypes()).equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getProductDescriptions() == null ^ this.getProductDescriptions() == null) {
            return false;
        }
        if (other.getProductDescriptions() != null && !((Object)other.getProductDescriptions()).equals(this.getProductDescriptions())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !((Object)other.getFilters()).equals(this.getFilters())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

