/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.CreateJobOutput;
import com.amazonaws.services.elastictranscoder.model.CreateJobPlaylist;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.JobInput;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonElasticTranscoder");
        String target = "EtsCustomerService.CreateJob";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-09-25/jobs";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            List<CreateJobPlaylist> playlistsList;
            List<CreateJobOutput> outputsList;
            CreateJobOutput output;
            JobInput input;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createJobRequest.getPipelineId() != null) {
                jsonWriter.key("PipelineId").value(createJobRequest.getPipelineId());
            }
            if ((input = createJobRequest.getInput()) != null) {
                jsonWriter.key("Input");
                jsonWriter.object();
                if (input.getKey() != null) {
                    jsonWriter.key("Key").value(input.getKey());
                }
                if (input.getFrameRate() != null) {
                    jsonWriter.key("FrameRate").value(input.getFrameRate());
                }
                if (input.getResolution() != null) {
                    jsonWriter.key("Resolution").value(input.getResolution());
                }
                if (input.getAspectRatio() != null) {
                    jsonWriter.key("AspectRatio").value(input.getAspectRatio());
                }
                if (input.getInterlaced() != null) {
                    jsonWriter.key("Interlaced").value(input.getInterlaced());
                }
                if (input.getContainer() != null) {
                    jsonWriter.key("Container").value(input.getContainer());
                }
                jsonWriter.endObject();
            }
            if ((output = createJobRequest.getOutput()) != null) {
                jsonWriter.key("Output");
                jsonWriter.object();
                if (output.getKey() != null) {
                    jsonWriter.key("Key").value(output.getKey());
                }
                if (output.getThumbnailPattern() != null) {
                    jsonWriter.key("ThumbnailPattern").value(output.getThumbnailPattern());
                }
                if (output.getRotate() != null) {
                    jsonWriter.key("Rotate").value(output.getRotate());
                }
                if (output.getPresetId() != null) {
                    jsonWriter.key("PresetId").value(output.getPresetId());
                }
                if (output.getSegmentDuration() != null) {
                    jsonWriter.key("SegmentDuration").value(output.getSegmentDuration());
                }
                jsonWriter.endObject();
            }
            if ((outputsList = createJobRequest.getOutputs()) != null) {
                jsonWriter.key("Outputs");
                jsonWriter.array();
                for (CreateJobOutput outputsListValue : outputsList) {
                    if (outputsListValue == null) continue;
                    jsonWriter.object();
                    if (outputsListValue.getKey() != null) {
                        jsonWriter.key("Key").value(outputsListValue.getKey());
                    }
                    if (outputsListValue.getThumbnailPattern() != null) {
                        jsonWriter.key("ThumbnailPattern").value(outputsListValue.getThumbnailPattern());
                    }
                    if (outputsListValue.getRotate() != null) {
                        jsonWriter.key("Rotate").value(outputsListValue.getRotate());
                    }
                    if (outputsListValue.getPresetId() != null) {
                        jsonWriter.key("PresetId").value(outputsListValue.getPresetId());
                    }
                    if (outputsListValue.getSegmentDuration() != null) {
                        jsonWriter.key("SegmentDuration").value(outputsListValue.getSegmentDuration());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createJobRequest.getOutputKeyPrefix() != null) {
                jsonWriter.key("OutputKeyPrefix").value(createJobRequest.getOutputKeyPrefix());
            }
            if ((playlistsList = createJobRequest.getPlaylists()) != null) {
                jsonWriter.key("Playlists");
                jsonWriter.array();
                for (CreateJobPlaylist playlistsListValue : playlistsList) {
                    List<String> outputKeysList;
                    if (playlistsListValue == null) continue;
                    jsonWriter.object();
                    if (playlistsListValue.getName() != null) {
                        jsonWriter.key("Name").value(playlistsListValue.getName());
                    }
                    if (playlistsListValue.getFormat() != null) {
                        jsonWriter.key("Format").value(playlistsListValue.getFormat());
                    }
                    if ((outputKeysList = playlistsListValue.getOutputKeys()) != null) {
                        jsonWriter.key("OutputKeys");
                        jsonWriter.array();
                        for (String outputKeysListValue : outputKeysList) {
                            if (outputKeysListValue == null) continue;
                            jsonWriter.value(outputKeysListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

