/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutItemRequestMarshaller
implements Marshaller<Request<PutItemRequest>, PutItemRequest> {
    @Override
    public Request<PutItemRequest> marshall(PutItemRequest putItemRequest) {
        if (putItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutItemRequest> request = new DefaultRequest<PutItemRequest>(putItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.PutItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(putItemRequest.getTableName());
            }
            if (putItemRequest.getItem() != null) {
                jsonWriter.key("Item");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> itemListValue : putItemRequest.getItem().entrySet()) {
                    List<ByteBuffer> bSList;
                    List<String> nSList;
                    List<String> sSList;
                    if (itemListValue.getValue() == null) continue;
                    jsonWriter.key(itemListValue.getKey());
                    jsonWriter.object();
                    if (itemListValue.getValue().getS() != null) {
                        jsonWriter.key("S").value(itemListValue.getValue().getS());
                    }
                    if (itemListValue.getValue().getN() != null) {
                        jsonWriter.key("N").value(itemListValue.getValue().getN());
                    }
                    if (itemListValue.getValue().getB() != null) {
                        jsonWriter.key("B").value(itemListValue.getValue().getB());
                    }
                    if ((sSList = itemListValue.getValue().getSS()) != null) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList) {
                            if (sSListValue == null) continue;
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = itemListValue.getValue().getNS()) != null) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList) {
                            if (nSListValue == null) continue;
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((bSList = itemListValue.getValue().getBS()) != null) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, ExpectedAttributeValue> expectedListValue : putItemRequest.getExpected().entrySet()) {
                    if (expectedListValue.getValue() == null) continue;
                    jsonWriter.key(expectedListValue.getKey());
                    jsonWriter.object();
                    AttributeValue value = expectedListValue.getValue().getValue();
                    if (value != null) {
                        List<ByteBuffer> bSList;
                        List<String> nSList;
                        List<String> sSList;
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if ((sSList = value.getSS()) != null) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if ((nSList = value.getNS()) != null) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if ((bSList = value.getBS()) != null) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (expectedListValue.getValue().isExists() != null) {
                        jsonWriter.key("Exists").value(expectedListValue.getValue().isExists());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (putItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(putItemRequest.getReturnValues());
            }
            if (putItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value(putItemRequest.getReturnConsumedCapacity());
            }
            if (putItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value(putItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

