/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWS4Signer
extends AbstractAWSSigner {
    protected static final String ALGORITHM = "AWS4-HMAC-SHA256";
    protected static final String TERMINATOR = "aws4_request";
    protected String serviceName;
    protected String regionName;
    protected Date overriddenDate;
    protected static final Log log = LogFactory.getLog(AWS4Signer.class);

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) throws AmazonClientException {
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        this.addHostHeader(request);
        String scope = this.getScope(request);
        InputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        payloadStream.mark(-1);
        String contentSha256 = BinaryUtils.toHex(this.hash(payloadStream));
        try {
            payloadStream.reset();
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to reset stream after calculating AWS4 signature", e);
        }
        request.addHeader("X-Amz-Date", this.getDateTimeStamp(this.getDateFromRequest(request)));
        request.addHeader("x-amz-content-sha256", contentSha256);
        String signingCredentials = sanitizedCredentials.getAWSAccessKeyId() + "/" + scope;
        byte[] signature = this.computeSignature(request, ALGORITHM, contentSha256, sanitizedCredentials);
        String credentialsAuthorizationHeader = "Credential=" + signingCredentials;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + this.getSignedHeadersString(request);
        String signatureAuthorizationHeader = "Signature=" + BinaryUtils.toHex(signature);
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        request.addHeader("Authorization", authorizationHeader);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addHeader("x-amz-security-token", credentials.getSessionToken());
    }

    protected String extractRegionName(URI endpoint) {
        if (this.regionName != null) {
            return this.regionName;
        }
        return AwsHostNameUtils.parseRegionName(endpoint);
    }

    protected String extractServiceName(URI endpoint) {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        return AwsHostNameUtils.parseServiceName(endpoint);
    }

    void overrideDate(Date overriddenDate) {
        this.overriddenDate = overriddenDate;
    }

    protected String getCanonicalizedHeaderString(Request<?> request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            buffer.append(header.toLowerCase().replaceAll("\\s+", " ") + ":" + request.getHeaders().get(header).replaceAll("\\s+", " "));
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected String getSignedHeadersString(Request<?> request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>();
        sortedHeaders.addAll(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(header.toLowerCase());
        }
        return buffer.toString();
    }

    protected String getCanonicalRequest(Request<?> request, String contentSha256) {
        String canonicalRequest = request.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(request.getResourcePath()) + "\n" + this.getCanonicalizedQueryString(request) + "\n" + this.getCanonicalizedHeaderString(request) + "\n" + this.getSignedHeadersString(request) + "\n" + contentSha256;
        log.debug((Object)("AWS4 Canonical Request: '\"" + canonicalRequest + "\""));
        return canonicalRequest;
    }

    protected String getStringToSign(String algorithm, String dateTime, String scope, String canonicalRequest) {
        String stringToSign = algorithm + "\n" + dateTime + "\n" + scope + "\n" + BinaryUtils.toHex(this.hash(canonicalRequest));
        log.debug((Object)("AWS4 String to Sign: '\"" + stringToSign + "\""));
        return stringToSign;
    }

    protected byte[] computeSignature(Request<?> request, String algorithm, String contentSha256, AWSCredentials sanitizedCredentials) {
        String regionName = this.extractRegionName(request.getEndpoint());
        String serviceName = this.extractServiceName(request.getEndpoint());
        Date date = this.getDateFromRequest(request);
        String dateTime = this.getDateTimeStamp(date);
        String dateStamp = this.getDateStamp(date);
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + TERMINATOR;
        String stringToSign = this.getStringToSign(algorithm, dateTime, scope, this.getCanonicalRequest(request, contentSha256));
        byte[] kSecret = ("AWS4" + sanitizedCredentials.getAWSSecretKey()).getBytes();
        byte[] kDate = this.sign(dateStamp, kSecret, SigningAlgorithm.HmacSHA256);
        byte[] kRegion = this.sign(regionName, kDate, SigningAlgorithm.HmacSHA256);
        byte[] kService = this.sign(serviceName, kRegion, SigningAlgorithm.HmacSHA256);
        byte[] kSigning = this.sign(TERMINATOR, kService, SigningAlgorithm.HmacSHA256);
        byte[] signature = this.sign(stringToSign.getBytes(), kSigning, SigningAlgorithm.HmacSHA256);
        return signature;
    }

    protected String getDateTimeStamp(Date date) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return dateTimeFormat.format(date);
    }

    protected String getDateStamp(Date date) {
        SimpleDateFormat dateStampFormat = new SimpleDateFormat("yyyyMMdd");
        dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return dateStampFormat.format(date);
    }

    protected Date getDateFromRequest(Request<?> request) {
        Date date = this.getSignatureDate(request.getTimeOffset());
        if (this.overriddenDate != null) {
            date = this.overriddenDate;
        }
        return date;
    }

    protected void addHostHeader(Request<?> request) {
        String hostHeader = request.getEndpoint().getHost();
        if (HttpUtils.isUsingNonDefaultPort(request.getEndpoint())) {
            hostHeader = hostHeader + ":" + request.getEndpoint().getPort();
        }
        request.addHeader("Host", hostHeader);
    }

    protected String getScope(Request<?> request) {
        String regionName = this.extractRegionName(request.getEndpoint());
        String serviceName = this.extractServiceName(request.getEndpoint());
        Date date = this.getDateFromRequest(request);
        String dateStamp = this.getDateStamp(date);
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + TERMINATOR;
        return scope;
    }
}

