/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RepeatableCipherInputStream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.crypto.AdjustedRangeInputStream;
import com.amazonaws.services.s3.internal.crypto.ByteRangeCapturingInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherFactory;
import com.amazonaws.services.s3.internal.crypto.EncryptionInstruction;
import com.amazonaws.services.s3.internal.crypto.JceEncryptionConstants;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionUtils {
    private static final String INSTRUCTION_SUFFIX = ".instruction";

    @Deprecated
    public static PutObjectRequest encryptRequestUsingMetadata(PutObjectRequest request, EncryptionMaterials materials, Provider cryptoProvider) {
        EncryptionInstruction instruction = EncryptionUtils.generateInstruction(materials, cryptoProvider);
        PutObjectRequest encryptedObjectRequest = EncryptionUtils.encryptRequestUsingInstruction(request, instruction);
        EncryptionUtils.updateMetadataWithEncryptionInstruction(request, instruction);
        return encryptedObjectRequest;
    }

    @Deprecated
    public static S3Object decryptObjectUsingMetadata(S3Object object, EncryptionMaterials materials, Provider cryptoProvider) {
        EncryptionInstruction instruction = EncryptionUtils.buildInstructionFromObjectMetadata(object, materials, cryptoProvider);
        return EncryptionUtils.decryptObjectUsingInstruction(object, instruction);
    }

    @Deprecated
    public static EncryptionInstruction generateInstruction(EncryptionMaterials materials, Provider cryptoProvider) {
        return EncryptionUtils.generateInstruction(new StaticEncryptionMaterialsProvider(materials), cryptoProvider);
    }

    public static EncryptionInstruction generateInstruction(EncryptionMaterialsProvider materialsProvider, Provider cryptoProvider) {
        SecretKey envelopeSymmetricKey = EncryptionUtils.generateOneTimeUseSymmetricKey();
        CipherFactory cipherFactory = new CipherFactory(envelopeSymmetricKey, 1, null, cryptoProvider);
        EncryptionMaterials materials = materialsProvider.getEncryptionMaterials();
        byte[] encryptedEnvelopeSymmetricKey = EncryptionUtils.getEncryptedSymmetricKey(envelopeSymmetricKey, materials, cryptoProvider);
        return new EncryptionInstruction(materials.getMaterialsDescription(), encryptedEnvelopeSymmetricKey, envelopeSymmetricKey, cipherFactory);
    }

    @Deprecated
    public static EncryptionInstruction buildInstructionFromInstructionFile(S3Object instructionFile, EncryptionMaterials materials, Provider cryptoProvider) {
        return EncryptionUtils.buildInstructionFromInstructionFile(instructionFile, new StaticEncryptionMaterialsProvider(materials), cryptoProvider);
    }

    public static EncryptionInstruction buildInstructionFromInstructionFile(S3Object instructionFile, EncryptionMaterialsProvider materialsProvider, Provider cryptoProvider) {
        JSONObject instructionJSON = EncryptionUtils.parseJSONInstruction(instructionFile);
        try {
            byte[] encryptedSymmetricKeyBytes = instructionJSON.getString("x-amz-key").getBytes();
            byte[] initVectorBytes = instructionJSON.getString("x-amz-iv").getBytes();
            String materialsDescriptionString = instructionJSON.getString("x-amz-matdesc");
            Map<String, String> materialsDescription = EncryptionUtils.convertJSONToMap(materialsDescriptionString);
            encryptedSymmetricKeyBytes = Base64.decodeBase64((byte[])encryptedSymmetricKeyBytes);
            initVectorBytes = Base64.decodeBase64((byte[])initVectorBytes);
            if (encryptedSymmetricKeyBytes == null || initVectorBytes == null || materialsDescription == null) {
                throw new AmazonClientException(String.format("Necessary encryption info not found in the instruction file '%s' in bucket '%s'", instructionFile.getKey(), instructionFile.getBucketName()));
            }
            EncryptionMaterials materials = EncryptionUtils.retrieveOriginalMaterials(materialsDescription, materialsProvider);
            if (materials == null) {
                throw new AmazonClientException(String.format("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file '%s' in bucket '%s'.", instructionFile.getKey(), instructionFile.getBucketName()));
            }
            SecretKey symmetricKey = EncryptionUtils.getDecryptedSymmetricKey(encryptedSymmetricKeyBytes, materials, cryptoProvider);
            CipherFactory cipherFactory = new CipherFactory(symmetricKey, 2, initVectorBytes, cryptoProvider);
            return new EncryptionInstruction(materialsDescription, encryptedSymmetricKeyBytes, symmetricKey, cipherFactory);
        }
        catch (JSONException e) {
            throw new AmazonClientException("Unable to parse retrieved instruction file : " + e.getMessage());
        }
    }

    @Deprecated
    public static EncryptionInstruction buildInstructionFromObjectMetadata(S3Object object, EncryptionMaterials materials, Provider cryptoProvider) {
        return EncryptionUtils.buildInstructionFromObjectMetadata(object, new StaticEncryptionMaterialsProvider(materials), cryptoProvider);
    }

    public static EncryptionInstruction buildInstructionFromObjectMetadata(S3Object object, EncryptionMaterialsProvider materialsProvider, Provider cryptoProvider) {
        ObjectMetadata metadata = object.getObjectMetadata();
        byte[] encryptedSymmetricKeyBytes = EncryptionUtils.getCryptoBytesFromMetadata("x-amz-key", metadata);
        byte[] initVectorBytes = EncryptionUtils.getCryptoBytesFromMetadata("x-amz-iv", metadata);
        String materialsDescriptionString = EncryptionUtils.getStringFromMetadata("x-amz-matdesc", metadata);
        Map<String, String> materialsDescription = EncryptionUtils.convertJSONToMap(materialsDescriptionString);
        if (encryptedSymmetricKeyBytes == null || initVectorBytes == null || materialsDescription == null) {
            throw new AmazonClientException(String.format("Necessary encryption info not found in the headers of file '%s' in bucket '%s'", object.getKey(), object.getBucketName()));
        }
        EncryptionMaterials materials = EncryptionUtils.retrieveOriginalMaterials(materialsDescription, materialsProvider);
        if (materials == null) {
            throw new AmazonClientException(String.format("Unable to retrieve the encryption materials that originally encrypted file '%s' in bucket '%s'.", object.getKey(), object.getBucketName()));
        }
        SecretKey symmetricKey = EncryptionUtils.getDecryptedSymmetricKey(encryptedSymmetricKeyBytes, materials, cryptoProvider);
        CipherFactory cipherFactory = new CipherFactory(symmetricKey, 2, initVectorBytes, cryptoProvider);
        return new EncryptionInstruction(materialsDescription, encryptedSymmetricKeyBytes, symmetricKey, cipherFactory);
    }

    public static PutObjectRequest encryptRequestUsingInstruction(PutObjectRequest request, EncryptionInstruction instruction) {
        long cryptoContentLength;
        long originalContentLength;
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("x-amz-unencrypted-content-md5", metadata.getContentMD5());
        }
        if ((originalContentLength = EncryptionUtils.getUnencryptedContentLength(request, metadata)) >= 0L) {
            metadata.addUserMetadata("x-amz-unencrypted-content-length", Long.toString(originalContentLength));
        }
        if ((cryptoContentLength = EncryptionUtils.calculateCryptoContentLength(instruction.getSymmetricCipher(), request, metadata)) >= 0L) {
            metadata.setContentLength(cryptoContentLength);
        }
        request.setMetadata(metadata);
        request.setInputStream(EncryptionUtils.getEncryptedInputStream(request, instruction.getCipherFactory()));
        request.setFile(null);
        return request;
    }

    public static S3Object decryptObjectUsingInstruction(S3Object object, EncryptionInstruction instruction) {
        S3ObjectInputStream objectContent = object.getObjectContent();
        RepeatableCipherInputStream decryptedInputStream = new RepeatableCipherInputStream(objectContent, instruction.getCipherFactory());
        object.setObjectContent(new S3ObjectInputStream(decryptedInputStream, objectContent.getHttpRequest()));
        return object;
    }

    public static PutObjectRequest createInstructionPutRequest(PutObjectRequest request, EncryptionInstruction instruction) {
        JSONObject instructionJSON = EncryptionUtils.convertInstructionToJSONObject(instruction);
        byte[] instructionBytes = instructionJSON.toString().getBytes();
        ByteArrayInputStream instructionInputStream = new ByteArrayInputStream(instructionBytes);
        ObjectMetadata metadata = request.getMetadata();
        metadata.setContentLength(instructionBytes.length);
        metadata.addUserMetadata("x-amz-crypto-instr-file", "");
        request.setKey(request.getKey() + INSTRUCTION_SUFFIX);
        request.setMetadata(metadata);
        request.setInputStream(instructionInputStream);
        return request;
    }

    public static PutObjectRequest createInstructionPutRequest(String bucketName, String key, EncryptionInstruction instruction) {
        JSONObject instructionJSON = EncryptionUtils.convertInstructionToJSONObject(instruction);
        byte[] instructionBytes = instructionJSON.toString().getBytes();
        ByteArrayInputStream instructionInputStream = new ByteArrayInputStream(instructionBytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(instructionBytes.length);
        metadata.addUserMetadata("x-amz-crypto-instr-file", "");
        return new PutObjectRequest(bucketName, key + INSTRUCTION_SUFFIX, instructionInputStream, metadata);
    }

    public static GetObjectRequest createInstructionGetRequest(GetObjectRequest request) {
        return new GetObjectRequest(request.getBucketName(), request.getKey() + INSTRUCTION_SUFFIX, request.getVersionId());
    }

    public static DeleteObjectRequest createInstructionDeleteObjectRequest(DeleteObjectRequest request) {
        return new DeleteObjectRequest(request.getBucketName(), request.getKey() + INSTRUCTION_SUFFIX);
    }

    public static boolean isEncryptionInfoInMetadata(S3Object retrievedObject) {
        Map<String, String> metadata = retrievedObject.getObjectMetadata().getUserMetadata();
        if (metadata == null) {
            return false;
        }
        return metadata.containsKey("x-amz-iv") && metadata.containsKey("x-amz-key") && metadata.containsKey("x-amz-matdesc");
    }

    public static boolean isEncryptionInfoInInstructionFile(S3Object instructionFile) {
        if (instructionFile == null) {
            return false;
        }
        Map<String, String> metadata = instructionFile.getObjectMetadata().getUserMetadata();
        if (metadata == null) {
            return false;
        }
        return metadata.containsKey("x-amz-crypto-instr-file");
    }

    public static long[] getAdjustedCryptoRange(long[] range) {
        if (range == null || range[0] > range[1]) {
            return null;
        }
        long[] adjustedCryptoRange = new long[]{EncryptionUtils.getCipherBlockLowerBound(range[0]), EncryptionUtils.getCipherBlockUpperBound(range[1])};
        return adjustedCryptoRange;
    }

    public static S3Object adjustOutputToDesiredRange(S3Object object, long[] range) {
        if (range == null || range[0] > range[1]) {
            return object;
        }
        try {
            S3ObjectInputStream objectContent = object.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            object.setObjectContent(new S3ObjectInputStream(adjustedRangeContents, objectContent.getHttpRequest()));
            return object;
        }
        catch (IOException e) {
            throw new AmazonClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    public static SecretKey generateOneTimeUseSymmetricKey() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
            generator.init(JceEncryptionConstants.SYMMETRIC_KEY_LENGTH, new SecureRandom());
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    public static Cipher createSymmetricCipher(SecretKey symmetricCryptoKey, int encryptMode, Provider cryptoProvider, byte[] initVector) {
        try {
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(JceEncryptionConstants.SYMMETRIC_CIPHER_METHOD, cryptoProvider) : Cipher.getInstance(JceEncryptionConstants.SYMMETRIC_CIPHER_METHOD);
            if (initVector != null) {
                cipher.init(encryptMode, (Key)symmetricCryptoKey, new IvParameterSpec(initVector));
            } else {
                cipher.init(encryptMode, symmetricCryptoKey);
            }
            return cipher;
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to build cipher: " + e.getMessage() + "\nMake sure you have the JCE unlimited strength policy files installed and " + "configured for your JVM: http://www.ngs.ac.uk/tools/jcepolicyfiles", e);
        }
    }

    public static byte[] getEncryptedSymmetricKey(SecretKey toBeEncrypted, EncryptionMaterials materials, Provider cryptoProvider) {
        Key keyToDoEncryption = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        try {
            byte[] toBeEncryptedBytes = toBeEncrypted.getEncoded();
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(keyToDoEncryption.getAlgorithm(), cryptoProvider) : Cipher.getInstance(keyToDoEncryption.getAlgorithm());
            cipher.init(1, keyToDoEncryption);
            return cipher.doFinal(toBeEncryptedBytes);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to encrypt symmetric key: " + e.getMessage(), e);
        }
    }

    private static SecretKey getDecryptedSymmetricKey(byte[] encryptedSymmetricKeyBytes, EncryptionMaterials materials, Provider cryptoProvider) {
        Key keyToDoDecryption = materials.getKeyPair() != null ? materials.getKeyPair().getPrivate() : materials.getSymmetricKey();
        try {
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(keyToDoDecryption.getAlgorithm(), cryptoProvider) : Cipher.getInstance(keyToDoDecryption.getAlgorithm());
            cipher.init(2, keyToDoDecryption);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(encryptedSymmetricKeyBytes);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, JceEncryptionConstants.SYMMETRIC_KEY_ALGORITHM);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to decrypt symmetric key from object metadata : " + e.getMessage(), e);
        }
    }

    private static InputStream getEncryptedInputStream(PutObjectRequest request, CipherFactory cipherFactory) {
        try {
            InputStream originalInputStream = request.getInputStream();
            if (request.getFile() != null) {
                originalInputStream = new RepeatableFileInputStream(request.getFile());
            }
            return new RepeatableCipherInputStream(originalInputStream, cipherFactory);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    public static InputStream getEncryptedInputStream(UploadPartRequest request, CipherFactory cipherFactory) {
        try {
            InputStream originalInputStream = request.getInputStream();
            if (request.getFile() != null) {
                originalInputStream = new InputSubstream(new RepeatableFileInputStream(request.getFile()), request.getFileOffset(), request.getPartSize(), request.isLastPart());
            }
            originalInputStream = new RepeatableCipherInputStream(originalInputStream, cipherFactory);
            if (!request.isLastPart()) {
                originalInputStream = new InputSubstream(originalInputStream, 0L, request.getPartSize(), false);
            }
            long partSize = request.getPartSize();
            int cipherBlockSize = cipherFactory.createCipher().getBlockSize();
            return new ByteRangeCapturingInputStream(originalInputStream, partSize - (long)cipherBlockSize, partSize);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    private static byte[] getCryptoBytesFromMetadata(String headerName, ObjectMetadata metadata) throws NullPointerException {
        Map<String, String> userMetadata = metadata.getUserMetadata();
        if (userMetadata == null || !userMetadata.containsKey(headerName)) {
            return null;
        }
        byte[] valueBytes = userMetadata.get(headerName).getBytes();
        return Base64.decodeBase64((byte[])valueBytes);
    }

    private static String getStringFromMetadata(String headerName, ObjectMetadata metadata) throws NullPointerException {
        Map<String, String> userMetadata = metadata.getUserMetadata();
        if (userMetadata == null || !userMetadata.containsKey(headerName)) {
            return null;
        }
        return userMetadata.get(headerName);
    }

    private static Map<String, String> convertJSONToMap(String descriptionJSONString) {
        if (descriptionJSONString == null) {
            return null;
        }
        try {
            JSONObject descriptionJSON = new JSONObject(descriptionJSONString);
            Iterator keysIterator = descriptionJSON.keys();
            HashMap<String, String> materialsDescription = new HashMap<String, String>();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                materialsDescription.put(key, descriptionJSON.getString(key));
            }
            return materialsDescription;
        }
        catch (JSONException e) {
            throw new AmazonClientException("Unable to parse encryption materials description from metadata :" + e.getMessage());
        }
    }

    public static void updateMetadataWithEncryptionInstruction(PutObjectRequest request, EncryptionInstruction instruction) {
        byte[] keyBytesToStoreInMetadata = instruction.getEncryptedSymmetricKey();
        Cipher symmetricCipher = instruction.getSymmetricCipher();
        Map<String, String> materialsDescription = instruction.getMaterialsDescription();
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (request.getFile() != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            metadata.setContentType(mimetypes.getMimetype(request.getFile()));
        }
        EncryptionUtils.updateMetadata(metadata, keyBytesToStoreInMetadata, symmetricCipher, materialsDescription);
        request.setMetadata(metadata);
    }

    private static void updateMetadata(ObjectMetadata metadata, byte[] keyBytesToStoreInMetadata, Cipher symmetricCipher, Map<String, String> materialsDescription) {
        if (keyBytesToStoreInMetadata != null) {
            keyBytesToStoreInMetadata = Base64.encodeBase64((byte[])keyBytesToStoreInMetadata);
            metadata.addUserMetadata("x-amz-key", new String(keyBytesToStoreInMetadata));
        }
        byte[] initVectorBytes = symmetricCipher.getIV();
        initVectorBytes = Base64.encodeBase64((byte[])initVectorBytes);
        metadata.addUserMetadata("x-amz-iv", new String(initVectorBytes));
        JSONObject descriptionJSON = new JSONObject(materialsDescription);
        metadata.addUserMetadata("x-amz-matdesc", descriptionJSON.toString());
    }

    public static ObjectMetadata updateMetadataWithEncryptionInfo(InitiateMultipartUploadRequest request, byte[] keyBytesToStoreInMetadata, Cipher symmetricCipher, Map<String, String> materialsDescription) {
        ObjectMetadata metadata = request.getObjectMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        EncryptionUtils.updateMetadata(metadata, keyBytesToStoreInMetadata, symmetricCipher, materialsDescription);
        return metadata;
    }

    private static EncryptionMaterials retrieveOriginalMaterials(Map<String, String> materialsDescription, EncryptionMaterialsAccessor accessor) {
        if (accessor == null) {
            return null;
        }
        return accessor.getEncryptionMaterials(materialsDescription);
    }

    private static long calculateCryptoContentLength(Cipher symmetricCipher, PutObjectRequest request, ObjectMetadata metadata) {
        long plaintextLength = EncryptionUtils.getUnencryptedContentLength(request, metadata);
        if (plaintextLength == 0L) {
            return 0L;
        }
        if (plaintextLength < 0L) {
            return -1L;
        }
        long cipherBlockSize = symmetricCipher.getBlockSize();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }

    public static long calculateCryptoContentLength(Cipher symmetricCipher, UploadPartRequest request) {
        long plaintextLength;
        if (request.getFile() != null) {
            plaintextLength = request.getPartSize() > 0L ? request.getPartSize() : request.getFile().length();
        } else if (request.getInputStream() != null) {
            plaintextLength = request.getPartSize();
        } else {
            return -1L;
        }
        long cipherBlockSize = symmetricCipher.getBlockSize();
        long offset = cipherBlockSize - plaintextLength % cipherBlockSize;
        return plaintextLength + offset;
    }

    private static long getUnencryptedContentLength(PutObjectRequest request, ObjectMetadata metadata) {
        if (request.getFile() != null) {
            return request.getFile().length();
        }
        if (request.getInputStream() != null && metadata.getContentLength() > 0L) {
            return metadata.getContentLength();
        }
        return -1L;
    }

    private static JSONObject convertInstructionToJSONObject(EncryptionInstruction instruction) {
        JSONObject instructionJSON = new JSONObject();
        try {
            JSONObject materialsDescriptionJSON = new JSONObject(instruction.getMaterialsDescription());
            byte[] initVector = instruction.getSymmetricCipher().getIV();
            initVector = Base64.encodeBase64((byte[])initVector);
            byte[] encryptedKeyBytes = instruction.getEncryptedSymmetricKey();
            encryptedKeyBytes = Base64.encodeBase64((byte[])encryptedKeyBytes);
            instructionJSON.put("x-amz-matdesc", materialsDescriptionJSON.toString());
            instructionJSON.put("x-amz-key", new String(encryptedKeyBytes));
            instructionJSON.put("x-amz-iv", new String(initVector));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return instructionJSON;
    }

    private static JSONObject parseJSONInstruction(S3Object instructionObject) {
        try {
            String instructionString = EncryptionUtils.convertStreamToString(instructionObject.getObjectContent());
            return new JSONObject(instructionString);
        }
        catch (Exception e) {
            throw new AmazonClientException("Error parsing JSON instruction file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    private static long getCipherBlockLowerBound(long leftmostBytePosition) {
        long cipherBlockSize = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE;
        long offset = leftmostBytePosition % cipherBlockSize;
        long lowerBound = leftmostBytePosition - offset - cipherBlockSize;
        if (lowerBound < 0L) {
            return 0L;
        }
        return lowerBound;
    }

    private static long getCipherBlockUpperBound(long rightmostBytePosition) {
        long cipherBlockSize = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE;
        long offset = cipherBlockSize - rightmostBytePosition % cipherBlockSize;
        return rightmostBytePosition + offset + cipherBlockSize;
    }
}

