/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.amazonaws.util.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JSONObject> {
    public JsonErrorUnmarshaller() {
    }

    protected JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(JSONObject json) throws Exception {
        String message = "";
        if (json.has("message")) {
            message = json.getString("message");
        }
        AmazonServiceException ase = this.newException(message);
        String errorCode = this.parseErrorCode(json);
        ase.setErrorCode(errorCode);
        return ase;
    }

    public String parseErrorCode(JSONObject json) throws Exception {
        String type;
        int separator;
        if (json.has("__type") && (separator = (type = json.getString("__type")).lastIndexOf("#")) > 0) {
            return type.substring(separator + 1);
        }
        return null;
    }
}

