/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront.model.InvalidationBatch;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateInvalidationRequestMarshaller
implements Marshaller<Request<CreateInvalidationRequest>, CreateInvalidationRequest> {
    @Override
    public Request<CreateInvalidationRequest> marshall(CreateInvalidationRequest createInvalidationRequest) {
        InvalidationBatch invalidationBatchInvalidationBatch;
        if (createInvalidationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateInvalidationRequest> request = new DefaultRequest<CreateInvalidationRequest>(createInvalidationRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-03-15/distribution/{DistributionId}/invalidation";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", this.getString(createInvalidationRequest.getDistributionId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2012-03-15/");
        if (createInvalidationRequest != null && (invalidationBatchInvalidationBatch = createInvalidationRequest.getInvalidationBatch()) != null) {
            List<String> pathsList;
            xmlWriter.startElement("InvalidationBatch");
            if (invalidationBatchInvalidationBatch != null && (pathsList = invalidationBatchInvalidationBatch.getPaths()) != null && pathsList.size() > 0) {
                int pathsListIndex = 1;
                for (String pathsListValue : pathsList) {
                    xmlWriter.startElement("Path");
                    xmlWriter.value(pathsListValue);
                    xmlWriter.endElement();
                    ++pathsListIndex;
                }
            }
            if (invalidationBatchInvalidationBatch.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(invalidationBatchInvalidationBatch.getCallerReference()).endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes().length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

