/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowAsync;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleWorkflowAsyncClient
extends AmazonSimpleWorkflowClient
implements AmazonSimpleWorkflowAsync {
    private ExecutorService executorService;

    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSimpleWorkflowAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> deprecateWorkflowTypeAsync(final DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.deprecateWorkflowType(deprecateWorkflowTypeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deprecateDomainAsync(final DeprecateDomainRequest deprecateDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.deprecateDomain(deprecateDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> registerWorkflowTypeAsync(final RegisterWorkflowTypeRequest registerWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.registerWorkflowType(registerWorkflowTypeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<WorkflowTypeInfos> listWorkflowTypesAsync(final ListWorkflowTypesRequest listWorkflowTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowTypeInfos>(){

            @Override
            public WorkflowTypeInfos call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.listWorkflowTypes(listWorkflowTypesRequest);
            }
        });
    }

    @Override
    public Future<Run> startWorkflowExecutionAsync(final StartWorkflowExecutionRequest startWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Run>(){

            @Override
            public Run call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.startWorkflowExecution(startWorkflowExecutionRequest);
            }
        });
    }

    @Override
    public Future<Void> signalWorkflowExecutionAsync(final SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.signalWorkflowExecution(signalWorkflowExecutionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DomainInfos> listDomainsAsync(final ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainInfos>(){

            @Override
            public DomainInfos call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.listDomains(listDomainsRequest);
            }
        });
    }

    @Override
    public Future<Void> requestCancelWorkflowExecutionAsync(final RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.requestCancelWorkflowExecution(requestCancelWorkflowExecutionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<WorkflowTypeDetail> describeWorkflowTypeAsync(final DescribeWorkflowTypeRequest describeWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowTypeDetail>(){

            @Override
            public WorkflowTypeDetail call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.describeWorkflowType(describeWorkflowTypeRequest);
            }
        });
    }

    @Override
    public Future<Void> deprecateActivityTypeAsync(final DeprecateActivityTypeRequest deprecateActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.deprecateActivityType(deprecateActivityTypeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionCount> countClosedWorkflowExecutionsAsync(final CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowExecutionCount>(){

            @Override
            public WorkflowExecutionCount call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.countClosedWorkflowExecutions(countClosedWorkflowExecutionsRequest);
            }
        });
    }

    @Override
    public Future<PendingTaskCount> countPendingActivityTasksAsync(final CountPendingActivityTasksRequest countPendingActivityTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PendingTaskCount>(){

            @Override
            public PendingTaskCount call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.countPendingActivityTasks(countPendingActivityTasksRequest);
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskCanceledAsync(final RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.respondActivityTaskCanceled(respondActivityTaskCanceledRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> respondDecisionTaskCompletedAsync(final RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.respondDecisionTaskCompleted(respondDecisionTaskCompletedRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskCompletedAsync(final RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.respondActivityTaskCompleted(respondActivityTaskCompletedRequest);
                return null;
            }
        });
    }

    @Override
    public Future<ActivityTask> pollForActivityTaskAsync(final PollForActivityTaskRequest pollForActivityTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivityTask>(){

            @Override
            public ActivityTask call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.pollForActivityTask(pollForActivityTaskRequest);
            }
        });
    }

    @Override
    public Future<WorkflowExecutionCount> countOpenWorkflowExecutionsAsync(final CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowExecutionCount>(){

            @Override
            public WorkflowExecutionCount call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.countOpenWorkflowExecutions(countOpenWorkflowExecutionsRequest);
            }
        });
    }

    @Override
    public Future<ActivityTypeDetail> describeActivityTypeAsync(final DescribeActivityTypeRequest describeActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivityTypeDetail>(){

            @Override
            public ActivityTypeDetail call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.describeActivityType(describeActivityTypeRequest);
            }
        });
    }

    @Override
    public Future<WorkflowExecutionInfos> listOpenWorkflowExecutionsAsync(final ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowExecutionInfos>(){

            @Override
            public WorkflowExecutionInfos call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.listOpenWorkflowExecutions(listOpenWorkflowExecutionsRequest);
            }
        });
    }

    @Override
    public Future<History> getWorkflowExecutionHistoryAsync(final GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<History>(){

            @Override
            public History call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.getWorkflowExecutionHistory(getWorkflowExecutionHistoryRequest);
            }
        });
    }

    @Override
    public Future<Void> registerDomainAsync(final RegisterDomainRequest registerDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.registerDomain(registerDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> registerActivityTypeAsync(final RegisterActivityTypeRequest registerActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.registerActivityType(registerActivityTypeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionInfos> listClosedWorkflowExecutionsAsync(final ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowExecutionInfos>(){

            @Override
            public WorkflowExecutionInfos call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.listClosedWorkflowExecutions(listClosedWorkflowExecutionsRequest);
            }
        });
    }

    @Override
    public Future<ActivityTaskStatus> recordActivityTaskHeartbeatAsync(final RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivityTaskStatus>(){

            @Override
            public ActivityTaskStatus call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.recordActivityTaskHeartbeat(recordActivityTaskHeartbeatRequest);
            }
        });
    }

    @Override
    public Future<DecisionTask> pollForDecisionTaskAsync(final PollForDecisionTaskRequest pollForDecisionTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DecisionTask>(){

            @Override
            public DecisionTask call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.pollForDecisionTask(pollForDecisionTaskRequest);
            }
        });
    }

    @Override
    public Future<ActivityTypeInfos> listActivityTypesAsync(final ListActivityTypesRequest listActivityTypesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ActivityTypeInfos>(){

            @Override
            public ActivityTypeInfos call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.listActivityTypes(listActivityTypesRequest);
            }
        });
    }

    @Override
    public Future<DomainDetail> describeDomainAsync(final DescribeDomainRequest describeDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainDetail>(){

            @Override
            public DomainDetail call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.describeDomain(describeDomainRequest);
            }
        });
    }

    @Override
    public Future<Void> respondActivityTaskFailedAsync(final RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.respondActivityTaskFailed(respondActivityTaskFailedRequest);
                return null;
            }
        });
    }

    @Override
    public Future<PendingTaskCount> countPendingDecisionTasksAsync(final CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PendingTaskCount>(){

            @Override
            public PendingTaskCount call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.countPendingDecisionTasks(countPendingDecisionTasksRequest);
            }
        });
    }

    @Override
    public Future<Void> terminateWorkflowExecutionAsync(final TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleWorkflowAsyncClient.this.terminateWorkflowExecution(terminateWorkflowExecutionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<WorkflowExecutionDetail> describeWorkflowExecutionAsync(final DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<WorkflowExecutionDetail>(){

            @Override
            public WorkflowExecutionDetail call() throws Exception {
                return AmazonSimpleWorkflowAsyncClient.this.describeWorkflowExecution(describeWorkflowExecutionRequest);
            }
        });
    }
}

