/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClientFactory;
import com.amazonaws.http.HttpMethodReleaseInputStream;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.CustomBackoffStrategy;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.ResponseMetadataCache;
import com.amazonaws.util.TimingInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonHttpClient {
    private static final Log requestLog;
    static final Log log;
    private HttpClient httpClient;
    private static final String BYTES_PROCESSED_COUNTER = "bytes-processed";
    private static final String RESPONSE_PROCESSING_SUBMEASUREMENT = "response-processing";
    private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
    private final ClientConfiguration config;
    private ResponseMetadataCache responseMetadataCache = new ResponseMetadataCache(50);
    private static final Random random;
    private static HttpRequestFactory httpRequestFactory;
    private static HttpClientFactory httpClientFactory;
    public static final String PROFILING_SYSTEM_PROPERTY = "com.amazonaws.sdk.enableRuntimeProfiling";

    public AmazonHttpClient(ClientConfiguration clientConfiguration) {
        this.config = clientConfiguration;
        this.httpClient = httpClientFactory.createHttpClient(this.config);
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    public <T> T execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        long startTime = System.currentTimeMillis();
        if (executionContext == null) {
            throw new AmazonClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler> requestHandlers = executionContext.getRequestHandlers();
        if (requestHandlers == null) {
            requestHandlers = new ArrayList<RequestHandler>();
        }
        for (RequestHandler requestHandler : requestHandlers) {
            requestHandler.beforeRequest(request);
        }
        try {
            TimingInfo timingInfo = new TimingInfo(startTime);
            executionContext.setTimingInfo(timingInfo);
            T t = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
            timingInfo.setEndTime(System.currentTimeMillis());
            for (RequestHandler handler : requestHandlers) {
                try {
                    handler.afterResponse(request, t, timingInfo);
                }
                catch (ClassCastException cce) {}
            }
            return t;
        }
        catch (AmazonClientException e) {
            for (RequestHandler handler : requestHandlers) {
                handler.afterError(request, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeHelper(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        boolean leaveHttpConnectionOpen = false;
        this.httpClient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        if (requestLog.isDebugEnabled()) {
            requestLog.debug((Object)("Sending Request: " + request.toString()));
        }
        this.applyRequestData(request);
        int retryCount = 0;
        URI redirectedURI = null;
        HttpEntity entity = null;
        AmazonServiceException exception = null;
        HashMap<String, String> originalParameters = new HashMap<String, String>();
        originalParameters.putAll(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>();
        originalHeaders.putAll(request.getHeaders());
        while (true) {
            HttpRequestBase httpRequest;
            if (retryCount > 0) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
            }
            if (executionContext.getSigner() != null && executionContext.getCredentials() != null) {
                executionContext.getSigner().sign(request, executionContext.getCredentials());
            }
            if ((httpRequest = httpRequestFactory.createHttpRequest(request, this.config, entity, executionContext)) instanceof HttpEntityEnclosingRequest) {
                entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            }
            if (redirectedURI != null) {
                httpRequest.setURI(redirectedURI);
            }
            org.apache.http.HttpResponse response = null;
            try {
                InputStream content;
                if (retryCount > 0) {
                    this.pauseExponentially(retryCount, exception, executionContext.getCustomBackoffStrategy());
                    if (entity != null && (content = entity.getContent()).markSupported()) {
                        content.reset();
                    }
                }
                exception = null;
                ++retryCount;
                response = this.httpClient.execute((HttpUriRequest)httpRequest);
                if (this.isRequestSuccessful(response)) {
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    content = this.handleResponse(request, responseHandler, httpRequest, response, executionContext);
                    return (T)content;
                }
                if (this.isTemporaryRedirect(response)) {
                    Header[] locationHeaders = response.getHeaders("location");
                    String redirectedLocation = locationHeaders[0].getValue();
                    log.debug((Object)("Redirecting to: " + redirectedLocation));
                    redirectedURI = URI.create(redirectedLocation);
                    httpRequest.setURI(redirectedURI);
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                exception = this.handleErrorResponse(request, errorResponseHandler, httpRequest, response);
                if (this.shouldRetry(httpRequest, exception, retryCount)) continue;
                throw exception;
            }
            catch (IOException ioe) {
                log.warn((Object)("Unable to execute HTTP request: " + ioe.getMessage()));
                if (this.shouldRetry(httpRequest, ioe, retryCount)) continue;
                throw new AmazonClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
            }
            finally {
                if (leaveHttpConnectionOpen) continue;
                try {
                    response.getEntity().getContent().close();
                }
                catch (Throwable t) {}
                continue;
            }
            break;
        }
    }

    private void applyRequestData(Request<?> request) {
        if (request.getOriginalRequest() != null && request.getOriginalRequest().getRequestClientOptions() != null && request.getOriginalRequest().getRequestClientOptions().getClientMarker() != null) {
            request.addHeader("User-Agent", AmazonHttpClient.createUserAgentString(this.config.getUserAgent(), request.getOriginalRequest().getRequestClientOptions().getClientMarker()));
        }
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString + " " + userAgent;
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private boolean shouldRetry(HttpRequestBase method, Exception exception, int retries) {
        HttpEntity entity;
        if (retries > this.config.getMaxErrorRetry()) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            return false;
        }
        if (exception instanceof NoHttpResponseException || exception instanceof SocketException || exception instanceof SocketTimeoutException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            }
            return true;
        }
        if (exception instanceof AmazonServiceException) {
            AmazonServiceException ase = (AmazonServiceException)exception;
            if (ase.getStatusCode() == 500 || ase.getStatusCode() == 503) {
                return true;
            }
            if (this.isThrottlingException(ase)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporaryRedirect(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status == 307 && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private boolean isRequestSuccessful(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    private <T> T handleResponse(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse, ExecutionContext executionContext) throws IOException {
        HttpResponse httpResponse = this.createResponse(method, request, apacheHttpResponse);
        if (responseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)method;
            httpResponse.setContent(new HttpMethodReleaseInputStream(httpEntityEnclosingRequest));
        }
        try {
            CountingInputStream countingInputStream = null;
            if (System.getProperty(PROFILING_SYSTEM_PROPERTY) != null) {
                countingInputStream = new CountingInputStream(httpResponse.getContent());
                httpResponse.setContent(countingInputStream);
            }
            long startTime = System.currentTimeMillis();
            AmazonWebServiceResponse<T> awsResponse = responseHandler.handle(httpResponse);
            long endTime = System.currentTimeMillis();
            if (System.getProperty(PROFILING_SYSTEM_PROPERTY) != null && executionContext.getTimingInfo() != null) {
                TimingInfo timingInfo = executionContext.getTimingInfo();
                TimingInfo responseProcessingTiming = new TimingInfo(startTime, endTime);
                timingInfo.addSubMeasurement(RESPONSE_PROCESSING_SUBMEASUREMENT, responseProcessingTiming);
                if (countingInputStream != null) {
                    responseProcessingTiming.addCounter(BYTES_PROCESSED_COUNTER, countingInputStream.getByteCount());
                }
            }
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata");
            }
            this.responseMetadataCache.add(request.getOriginalRequest(), awsResponse.getResponseMetadata());
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((Object)("Received successful response: " + apacheHttpResponse.getStatusLine().getStatusCode() + ", AWS Request ID: " + awsResponse.getRequestId()));
            }
            return awsResponse.getResult();
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + ")";
            log.warn((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, e);
        }
    }

    private AmazonServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<AmazonServiceException> errorResponseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        int status = apacheHttpResponse.getStatusLine().getStatusCode();
        HttpResponse response = this.createResponse(method, request, apacheHttpResponse);
        if (errorResponseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityEnclosingRequest = (HttpEntityEnclosingRequestBase)method;
            response.setContent(new HttpMethodReleaseInputStream((HttpEntityEnclosingRequest)entityEnclosingRequest));
        }
        AmazonServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
            requestLog.debug((Object)("Received error response: " + exception.toString()));
        }
        catch (Exception e) {
            if (status == 413) {
                exception = new AmazonServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(413);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (status == 503 && "Service Unavailable".equalsIgnoreCase(apacheHttpResponse.getStatusLine().getReasonPhrase())) {
                exception = new AmazonServiceException("Service unavailable");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(503);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + ")";
            log.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, e);
        }
        exception.setStatusCode(status);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private void pauseExponentially(int retries, AmazonServiceException previousException, CustomBackoffStrategy backoffStrategy) {
        long delay = 0L;
        if (backoffStrategy != null) {
            delay = backoffStrategy.getBackoffPeriod(retries);
        } else {
            long scaleFactor = 300L;
            if (this.isThrottlingException(previousException)) {
                scaleFactor = 500 + random.nextInt(100);
            }
            delay = (long)(Math.pow(2.0, retries) * (double)scaleFactor);
        }
        delay = Math.min(delay, 20000L);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    private boolean isThrottlingException(AmazonServiceException ase) {
        if (ase == null) {
            return false;
        }
        return "Throttling".equals(ase.getErrorCode()) || "ThrottlingException".equals(ase.getErrorCode()) || "ProvisionedThroughputExceededException".equals(ase.getErrorCode());
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    static {
        String jvmVersion;
        requestLog = LogFactory.getLog((String)"com.amazonaws.request");
        log = LogFactory.getLog(AmazonHttpClient.class);
        random = new Random();
        httpRequestFactory = new HttpRequestFactory();
        httpClientFactory = new HttpClientFactory();
        List<String> problematicJvmVersions = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17");
        if (problematicJvmVersions.contains(jvmVersion = System.getProperty("java.version"))) {
            log.warn((Object)("Detected a possible problem with the current JVM version (" + jvmVersion + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update."));
        }
    }
}

