/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSetFailover;
import com.amazonaws.services.route53.model.ResourceRecordSetRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRecordSet {
    private String name;
    private String type;
    private String setIdentifier;
    private Long weight;
    private String region;
    private String failover;
    private Long tTL;
    private List<ResourceRecord> resourceRecords;
    private AliasTarget aliasTarget;
    private String healthCheckId;

    public ResourceRecordSet() {
    }

    public ResourceRecordSet(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ResourceRecordSet(String name, RRType type) {
        this.name = name;
        this.type = type.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceRecordSet withName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceRecordSet withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(RRType type) {
        this.type = type.toString();
    }

    public ResourceRecordSet withType(RRType type) {
        this.type = type.toString();
        return this;
    }

    public String getSetIdentifier() {
        return this.setIdentifier;
    }

    public void setSetIdentifier(String setIdentifier) {
        this.setIdentifier = setIdentifier;
    }

    public ResourceRecordSet withSetIdentifier(String setIdentifier) {
        this.setIdentifier = setIdentifier;
        return this;
    }

    public Long getWeight() {
        return this.weight;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }

    public ResourceRecordSet withWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public ResourceRecordSet withRegion(String region) {
        this.region = region;
        return this;
    }

    public void setRegion(ResourceRecordSetRegion region) {
        this.region = region.toString();
    }

    public ResourceRecordSet withRegion(ResourceRecordSetRegion region) {
        this.region = region.toString();
        return this;
    }

    public String getFailover() {
        return this.failover;
    }

    public void setFailover(String failover) {
        this.failover = failover;
    }

    public ResourceRecordSet withFailover(String failover) {
        this.failover = failover;
        return this;
    }

    public void setFailover(ResourceRecordSetFailover failover) {
        this.failover = failover.toString();
    }

    public ResourceRecordSet withFailover(ResourceRecordSetFailover failover) {
        this.failover = failover.toString();
        return this;
    }

    public Long getTTL() {
        return this.tTL;
    }

    public void setTTL(Long tTL) {
        this.tTL = tTL;
    }

    public ResourceRecordSet withTTL(Long tTL) {
        this.tTL = tTL;
        return this;
    }

    public List<ResourceRecord> getResourceRecords() {
        if (this.resourceRecords == null) {
            this.resourceRecords = new ArrayList<ResourceRecord>();
        }
        return this.resourceRecords;
    }

    public void setResourceRecords(Collection<ResourceRecord> resourceRecords) {
        if (resourceRecords == null) {
            this.resourceRecords = null;
            return;
        }
        ArrayList<ResourceRecord> resourceRecordsCopy = new ArrayList<ResourceRecord>(resourceRecords.size());
        resourceRecordsCopy.addAll(resourceRecords);
        this.resourceRecords = resourceRecordsCopy;
    }

    public ResourceRecordSet withResourceRecords(ResourceRecord ... resourceRecords) {
        if (this.getResourceRecords() == null) {
            this.setResourceRecords(new ArrayList<ResourceRecord>(resourceRecords.length));
        }
        for (ResourceRecord value : resourceRecords) {
            this.getResourceRecords().add(value);
        }
        return this;
    }

    public ResourceRecordSet withResourceRecords(Collection<ResourceRecord> resourceRecords) {
        if (resourceRecords == null) {
            this.resourceRecords = null;
        } else {
            ArrayList<ResourceRecord> resourceRecordsCopy = new ArrayList<ResourceRecord>(resourceRecords.size());
            resourceRecordsCopy.addAll(resourceRecords);
            this.resourceRecords = resourceRecordsCopy;
        }
        return this;
    }

    public AliasTarget getAliasTarget() {
        return this.aliasTarget;
    }

    public void setAliasTarget(AliasTarget aliasTarget) {
        this.aliasTarget = aliasTarget;
    }

    public ResourceRecordSet withAliasTarget(AliasTarget aliasTarget) {
        this.aliasTarget = aliasTarget;
        return this;
    }

    public String getHealthCheckId() {
        return this.healthCheckId;
    }

    public void setHealthCheckId(String healthCheckId) {
        this.healthCheckId = healthCheckId;
    }

    public ResourceRecordSet withHealthCheckId(String healthCheckId) {
        this.healthCheckId = healthCheckId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ", ");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ", ");
        }
        if (this.getSetIdentifier() != null) {
            sb.append("SetIdentifier: " + this.getSetIdentifier() + ", ");
        }
        if (this.getWeight() != null) {
            sb.append("Weight: " + this.getWeight() + ", ");
        }
        if (this.getRegion() != null) {
            sb.append("Region: " + this.getRegion() + ", ");
        }
        if (this.getFailover() != null) {
            sb.append("Failover: " + this.getFailover() + ", ");
        }
        if (this.getTTL() != null) {
            sb.append("TTL: " + this.getTTL() + ", ");
        }
        if (this.getResourceRecords() != null) {
            sb.append("ResourceRecords: " + this.getResourceRecords() + ", ");
        }
        if (this.getAliasTarget() != null) {
            sb.append("AliasTarget: " + this.getAliasTarget() + ", ");
        }
        if (this.getHealthCheckId() != null) {
            sb.append("HealthCheckId: " + this.getHealthCheckId() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSetIdentifier() == null ? 0 : this.getSetIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getWeight() == null ? 0 : this.getWeight().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getFailover() == null ? 0 : this.getFailover().hashCode());
        hashCode = 31 * hashCode + (this.getTTL() == null ? 0 : this.getTTL().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRecords() == null ? 0 : ((Object)this.getResourceRecords()).hashCode());
        hashCode = 31 * hashCode + (this.getAliasTarget() == null ? 0 : this.getAliasTarget().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckId() == null ? 0 : this.getHealthCheckId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecordSet)) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSetIdentifier() == null ^ this.getSetIdentifier() == null) {
            return false;
        }
        if (other.getSetIdentifier() != null && !other.getSetIdentifier().equals(this.getSetIdentifier())) {
            return false;
        }
        if (other.getWeight() == null ^ this.getWeight() == null) {
            return false;
        }
        if (other.getWeight() != null && !other.getWeight().equals(this.getWeight())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getFailover() == null ^ this.getFailover() == null) {
            return false;
        }
        if (other.getFailover() != null && !other.getFailover().equals(this.getFailover())) {
            return false;
        }
        if (other.getTTL() == null ^ this.getTTL() == null) {
            return false;
        }
        if (other.getTTL() != null && !other.getTTL().equals(this.getTTL())) {
            return false;
        }
        if (other.getResourceRecords() == null ^ this.getResourceRecords() == null) {
            return false;
        }
        if (other.getResourceRecords() != null && !((Object)other.getResourceRecords()).equals(this.getResourceRecords())) {
            return false;
        }
        if (other.getAliasTarget() == null ^ this.getAliasTarget() == null) {
            return false;
        }
        if (other.getAliasTarget() != null && !other.getAliasTarget().equals(this.getAliasTarget())) {
            return false;
        }
        if (other.getHealthCheckId() == null ^ this.getHealthCheckId() == null) {
            return false;
        }
        return other.getHealthCheckId() == null || other.getHealthCheckId().equals(this.getHealthCheckId());
    }
}

