/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartWorkflowExecutionRequestMarshaller
implements Marshaller<Request<StartWorkflowExecutionRequest>, StartWorkflowExecutionRequest> {
    @Override
    public Request<StartWorkflowExecutionRequest> marshall(StartWorkflowExecutionRequest startWorkflowExecutionRequest) {
        if (startWorkflowExecutionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartWorkflowExecutionRequest> request = new DefaultRequest<StartWorkflowExecutionRequest>(startWorkflowExecutionRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.StartWorkflowExecution";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            TaskList taskListTaskList;
            WorkflowType workflowTypeWorkflowType;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (startWorkflowExecutionRequest.getDomain() != null) {
                jsonWriter.key("domain").value(startWorkflowExecutionRequest.getDomain());
            }
            if (startWorkflowExecutionRequest.getWorkflowId() != null) {
                jsonWriter.key("workflowId").value(startWorkflowExecutionRequest.getWorkflowId());
            }
            if (startWorkflowExecutionRequest != null && (workflowTypeWorkflowType = startWorkflowExecutionRequest.getWorkflowType()) != null) {
                jsonWriter.key("workflowType").object();
                if (workflowTypeWorkflowType.getName() != null) {
                    jsonWriter.key("name").value(workflowTypeWorkflowType.getName());
                }
                if (workflowTypeWorkflowType.getVersion() != null) {
                    jsonWriter.key("version").value(workflowTypeWorkflowType.getVersion());
                }
                jsonWriter.endObject();
            }
            if (startWorkflowExecutionRequest != null && (taskListTaskList = startWorkflowExecutionRequest.getTaskList()) != null) {
                jsonWriter.key("taskList").object();
                if (taskListTaskList.getName() != null) {
                    jsonWriter.key("name").value(taskListTaskList.getName());
                }
                jsonWriter.endObject();
            }
            if (startWorkflowExecutionRequest.getInput() != null) {
                jsonWriter.key("input").value(startWorkflowExecutionRequest.getInput());
            }
            if (startWorkflowExecutionRequest.getExecutionStartToCloseTimeout() != null) {
                jsonWriter.key("executionStartToCloseTimeout").value(startWorkflowExecutionRequest.getExecutionStartToCloseTimeout());
            }
            if (startWorkflowExecutionRequest != null) {
                List<String> tagListList = startWorkflowExecutionRequest.getTagList();
                int tagListListIndex = 0;
                if (tagListList != null && tagListList.size() > 0) {
                    jsonWriter.key("tagList").array();
                    for (String tagListListValue : tagListList) {
                        if (tagListListValue != null) {
                            jsonWriter.value(tagListListValue);
                        } else {
                            jsonWriter.value(null);
                        }
                        ++tagListListIndex;
                    }
                    jsonWriter.endArray();
                }
            }
            if (startWorkflowExecutionRequest.getTaskStartToCloseTimeout() != null) {
                jsonWriter.key("taskStartToCloseTimeout").value(startWorkflowExecutionRequest.getTaskStartToCloseTimeout());
            }
            if (startWorkflowExecutionRequest.getChildPolicy() != null) {
                jsonWriter.key("childPolicy").value(startWorkflowExecutionRequest.getChildPolicy());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

