/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.ec2.AmazonEC2Async;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.ActivateLicenseRequest;
import com.amazonaws.services.ec2.model.AllocateAddressRequest;
import com.amazonaws.services.ec2.model.AllocateAddressResult;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.AssociateAddressResult;
import com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.AssociateRouteTableRequest;
import com.amazonaws.services.ec2.model.AssociateRouteTableResult;
import com.amazonaws.services.ec2.model.AttachInternetGatewayRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.AttachVolumeResult;
import com.amazonaws.services.ec2.model.AttachVpnGatewayRequest;
import com.amazonaws.services.ec2.model.AttachVpnGatewayResult;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.BundleInstanceResult;
import com.amazonaws.services.ec2.model.CancelBundleTaskRequest;
import com.amazonaws.services.ec2.model.CancelBundleTaskResult;
import com.amazonaws.services.ec2.model.CancelConversionTaskRequest;
import com.amazonaws.services.ec2.model.CancelExportTaskRequest;
import com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.CancelReservedInstancesListingResult;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest;
import com.amazonaws.services.ec2.model.ConfirmProductInstanceResult;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayResult;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsResult;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskResult;
import com.amazonaws.services.ec2.model.CreateInternetGatewayRequest;
import com.amazonaws.services.ec2.model.CreateInternetGatewayResult;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.CreateNetworkAclRequest;
import com.amazonaws.services.ec2.model.CreateNetworkAclResult;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.CreatePlacementGroupRequest;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingResult;
import com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.amazonaws.services.ec2.model.CreateRouteTableRequest;
import com.amazonaws.services.ec2.model.CreateRouteTableResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.CreateSnapshotRequest;
import com.amazonaws.services.ec2.model.CreateSnapshotResult;
import com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionResult;
import com.amazonaws.services.ec2.model.CreateSubnetRequest;
import com.amazonaws.services.ec2.model.CreateSubnetResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.amazonaws.services.ec2.model.CreateVpcResult;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRequest;
import com.amazonaws.services.ec2.model.CreateVpnConnectionResult;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest;
import com.amazonaws.services.ec2.model.CreateVpnGatewayRequest;
import com.amazonaws.services.ec2.model.CreateVpnGatewayResult;
import com.amazonaws.services.ec2.model.DeactivateLicenseRequest;
import com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest;
import com.amazonaws.services.ec2.model.DeleteKeyPairRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkAclRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DeletePlacementGroupRequest;
import com.amazonaws.services.ec2.model.DeleteRouteRequest;
import com.amazonaws.services.ec2.model.DeleteRouteTableRequest;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.DeleteSubnetRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DeleteVolumeRequest;
import com.amazonaws.services.ec2.model.DeleteVpcRequest;
import com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest;
import com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest;
import com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest;
import com.amazonaws.services.ec2.model.DeregisterImageRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeBundleTasksRequest;
import com.amazonaws.services.ec2.model.DescribeBundleTasksResult;
import com.amazonaws.services.ec2.model.DescribeConversionTasksRequest;
import com.amazonaws.services.ec2.model.DescribeConversionTasksResult;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysResult;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsResult;
import com.amazonaws.services.ec2.model.DescribeExportTasksRequest;
import com.amazonaws.services.ec2.model.DescribeExportTasksResult;
import com.amazonaws.services.ec2.model.DescribeImageAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeImageAttributeResult;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeLicensesRequest;
import com.amazonaws.services.ec2.model.DescribeLicensesResult;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesResult;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsResult;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesResult;
import com.amazonaws.services.ec2.model.DescribeRouteTablesRequest;
import com.amazonaws.services.ec2.model.DescribeRouteTablesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotAttributeResult;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotsResult;
import com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeVolumeAttributeResult;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusResult;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsResult;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysResult;
import com.amazonaws.services.ec2.model.DetachInternetGatewayRequest;
import com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.services.ec2.model.DetachVolumeResult;
import com.amazonaws.services.ec2.model.DetachVpnGatewayRequest;
import com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.amazonaws.services.ec2.model.DisassociateRouteTableRequest;
import com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest;
import com.amazonaws.services.ec2.model.EnableVolumeIORequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputResult;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.GetPasswordDataResult;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.ImportInstanceResult;
import com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.amazonaws.services.ec2.model.ImportKeyPairResult;
import com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.amazonaws.services.ec2.model.ImportVolumeResult;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest;
import com.amazonaws.services.ec2.model.MonitorInstancesRequest;
import com.amazonaws.services.ec2.model.MonitorInstancesResult;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingResult;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.services.ec2.model.RegisterImageResult;
import com.amazonaws.services.ec2.model.ReleaseAddressRequest;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationResult;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationResult;
import com.amazonaws.services.ec2.model.ReportInstanceStatusRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.ResetImageAttributeRequest;
import com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2AsyncClient
extends AmazonEC2Client
implements AmazonEC2Async {
    private ExecutorService executorService;

    public AmazonEC2AsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonEC2AsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonEC2AsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonEC2AsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonEC2AsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonEC2AsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> rebootInstancesAsync(final RebootInstancesRequest rebootInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.rebootInstances(rebootInstancesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesResult> describeReservedInstancesAsync(final DescribeReservedInstancesRequest describeReservedInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesResult>(){

            @Override
            public DescribeReservedInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstances(describeReservedInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeAvailabilityZonesResult> describeAvailabilityZonesAsync(final DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAvailabilityZonesResult>(){

            @Override
            public DescribeAvailabilityZonesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeAvailabilityZones(describeAvailabilityZonesRequest);
            }
        });
    }

    @Override
    public Future<DetachVolumeResult> detachVolumeAsync(final DetachVolumeRequest detachVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DetachVolumeResult>(){

            @Override
            public DetachVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.detachVolume(detachVolumeRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteKeyPairAsync(final DeleteKeyPairRequest deleteKeyPairRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteKeyPair(deleteKeyPairRequest);
                return null;
            }
        });
    }

    @Override
    public Future<UnmonitorInstancesResult> unmonitorInstancesAsync(final UnmonitorInstancesRequest unmonitorInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnmonitorInstancesResult>(){

            @Override
            public UnmonitorInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.unmonitorInstances(unmonitorInstancesRequest);
            }
        });
    }

    @Override
    public Future<AttachVpnGatewayResult> attachVpnGatewayAsync(final AttachVpnGatewayRequest attachVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachVpnGatewayResult>(){

            @Override
            public AttachVpnGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachVpnGateway(attachVpnGatewayRequest);
            }
        });
    }

    @Override
    public Future<CreateImageResult> createImageAsync(final CreateImageRequest createImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateImageResult>(){

            @Override
            public CreateImageResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createImage(createImageRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteSecurityGroupAsync(final DeleteSecurityGroupRequest deleteSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSecurityGroup(deleteSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateInstanceExportTaskResult> createInstanceExportTaskAsync(final CreateInstanceExportTaskRequest createInstanceExportTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInstanceExportTaskResult>(){

            @Override
            public CreateInstanceExportTaskResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createInstanceExportTask(createInstanceExportTaskRequest);
            }
        });
    }

    @Override
    public Future<Void> authorizeSecurityGroupEgressAsync(final AuthorizeSecurityGroupEgressRequest authorizeSecurityGroupEgressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.authorizeSecurityGroupEgress(authorizeSecurityGroupEgressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<GetPasswordDataResult> getPasswordDataAsync(final GetPasswordDataRequest getPasswordDataRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetPasswordDataResult>(){

            @Override
            public GetPasswordDataResult call() throws Exception {
                return AmazonEC2AsyncClient.this.getPasswordData(getPasswordDataRequest);
            }
        });
    }

    @Override
    public Future<Void> associateDhcpOptionsAsync(final AssociateDhcpOptionsRequest associateDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.associateDhcpOptions(associateDhcpOptionsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<StopInstancesResult> stopInstancesAsync(final StopInstancesRequest stopInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StopInstancesResult>(){

            @Override
            public StopInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.stopInstances(stopInstancesRequest);
            }
        });
    }

    @Override
    public Future<ImportKeyPairResult> importKeyPairAsync(final ImportKeyPairRequest importKeyPairRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportKeyPairResult>(){

            @Override
            public ImportKeyPairResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importKeyPair(importKeyPairRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkInterfaceAsync(final DeleteNetworkInterfaceRequest deleteNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteNetworkInterface(deleteNetworkInterfaceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateSecurityGroupResult> createSecurityGroupAsync(final CreateSecurityGroupRequest createSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSecurityGroupResult>(){

            @Override
            public CreateSecurityGroupResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSecurityGroup(createSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<DescribeSpotPriceHistoryResult> describeSpotPriceHistoryAsync(final DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotPriceHistoryResult>(){

            @Override
            public DescribeSpotPriceHistoryResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotPriceHistory(describeSpotPriceHistoryRequest);
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfacesResult> describeNetworkInterfacesAsync(final DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkInterfacesResult>(){

            @Override
            public DescribeNetworkInterfacesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeNetworkInterfaces(describeNetworkInterfacesRequest);
            }
        });
    }

    @Override
    public Future<DescribeRegionsResult> describeRegionsAsync(final DescribeRegionsRequest describeRegionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRegionsResult>(){

            @Override
            public DescribeRegionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeRegions(describeRegionsRequest);
            }
        });
    }

    @Override
    public Future<CreateReservedInstancesListingResult> createReservedInstancesListingAsync(final CreateReservedInstancesListingRequest createReservedInstancesListingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateReservedInstancesListingResult>(){

            @Override
            public CreateReservedInstancesListingResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createReservedInstancesListing(createReservedInstancesListingRequest);
            }
        });
    }

    @Override
    public Future<CreateDhcpOptionsResult> createDhcpOptionsAsync(final CreateDhcpOptionsRequest createDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDhcpOptionsResult>(){

            @Override
            public CreateDhcpOptionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createDhcpOptions(createDhcpOptionsRequest);
            }
        });
    }

    @Override
    public Future<Void> resetSnapshotAttributeAsync(final ResetSnapshotAttributeRequest resetSnapshotAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetSnapshotAttribute(resetSnapshotAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRouteAsync(final DeleteRouteRequest deleteRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteRoute(deleteRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeInternetGatewaysResult> describeInternetGatewaysAsync(final DescribeInternetGatewaysRequest describeInternetGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInternetGatewaysResult>(){

            @Override
            public DescribeInternetGatewaysResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInternetGateways(describeInternetGatewaysRequest);
            }
        });
    }

    @Override
    public Future<ImportVolumeResult> importVolumeAsync(final ImportVolumeRequest importVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportVolumeResult>(){

            @Override
            public ImportVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importVolume(importVolumeRequest);
            }
        });
    }

    @Override
    public Future<DescribeSecurityGroupsResult> describeSecurityGroupsAsync(final DescribeSecurityGroupsRequest describeSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSecurityGroupsResult>(){

            @Override
            public DescribeSecurityGroupsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSecurityGroups(describeSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<Void> detachVpnGatewayAsync(final DetachVpnGatewayRequest detachVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.detachVpnGateway(detachVpnGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deregisterImageAsync(final DeregisterImageRequest deregisterImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deregisterImage(deregisterImageRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSpotDatafeedSubscriptionResult> describeSpotDatafeedSubscriptionAsync(final DescribeSpotDatafeedSubscriptionRequest describeSpotDatafeedSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotDatafeedSubscriptionResult>(){

            @Override
            public DescribeSpotDatafeedSubscriptionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotDatafeedSubscription(describeSpotDatafeedSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteTags(deleteTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSubnetAsync(final DeleteSubnetRequest deleteSubnetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSubnet(deleteSubnetRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateVpnGatewayResult> createVpnGatewayAsync(final CreateVpnGatewayRequest createVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpnGatewayResult>(){

            @Override
            public CreateVpnGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpnGateway(createVpnGatewayRequest);
            }
        });
    }

    @Override
    public Future<Void> enableVolumeIOAsync(final EnableVolumeIORequest enableVolumeIORequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.enableVolumeIO(enableVolumeIORequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnGatewayAsync(final DeleteVpnGatewayRequest deleteVpnGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpnGateway(deleteVpnGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<AttachVolumeResult> attachVolumeAsync(final AttachVolumeRequest attachVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachVolumeResult>(){

            @Override
            public AttachVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachVolume(attachVolumeRequest);
            }
        });
    }

    @Override
    public Future<DescribeLicensesResult> describeLicensesAsync(final DescribeLicensesRequest describeLicensesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLicensesResult>(){

            @Override
            public DescribeLicensesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeLicenses(describeLicensesRequest);
            }
        });
    }

    @Override
    public Future<DescribeVolumeStatusResult> describeVolumeStatusAsync(final DescribeVolumeStatusRequest describeVolumeStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumeStatusResult>(){

            @Override
            public DescribeVolumeStatusResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVolumeStatus(describeVolumeStatusRequest);
            }
        });
    }

    @Override
    public Future<Void> activateLicenseAsync(final ActivateLicenseRequest activateLicenseRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.activateLicense(activateLicenseRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetImageAttributeAsync(final ResetImageAttributeRequest resetImageAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetImageAttribute(resetImageAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVpnConnectionsResult> describeVpnConnectionsAsync(final DescribeVpnConnectionsRequest describeVpnConnectionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpnConnectionsResult>(){

            @Override
            public DescribeVpnConnectionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpnConnections(describeVpnConnectionsRequest);
            }
        });
    }

    @Override
    public Future<Void> enableVgwRoutePropagationAsync(final EnableVgwRoutePropagationRequest enableVgwRoutePropagationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.enableVgwRoutePropagation(enableVgwRoutePropagationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(final CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSnapshot(createSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteVolumeAsync(final DeleteVolumeRequest deleteVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVolume(deleteVolumeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateNetworkInterfaceResult> createNetworkInterfaceAsync(final CreateNetworkInterfaceRequest createNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateNetworkInterfaceResult>(){

            @Override
            public CreateNetworkInterfaceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createNetworkInterface(createNetworkInterfaceRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpcsResult> describeVpcsAsync(final DescribeVpcsRequest describeVpcsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpcsResult>(){

            @Override
            public DescribeVpcsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpcs(describeVpcsRequest);
            }
        });
    }

    @Override
    public Future<Void> unassignPrivateIpAddressesAsync(final UnassignPrivateIpAddressesRequest unassignPrivateIpAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.unassignPrivateIpAddresses(unassignPrivateIpAddressesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<AssociateAddressResult> associateAddressAsync(final AssociateAddressRequest associateAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateAddressResult>(){

            @Override
            public AssociateAddressResult call() throws Exception {
                return AmazonEC2AsyncClient.this.associateAddress(associateAddressRequest);
            }
        });
    }

    @Override
    public Future<Void> cancelConversionTaskAsync(final CancelConversionTaskRequest cancelConversionTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.cancelConversionTask(cancelConversionTaskRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deactivateLicenseAsync(final DeactivateLicenseRequest deactivateLicenseRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deactivateLicense(deactivateLicenseRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteCustomerGatewayAsync(final DeleteCustomerGatewayRequest deleteCustomerGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteCustomerGateway(deleteCustomerGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createNetworkAclEntryAsync(final CreateNetworkAclEntryRequest createNetworkAclEntryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createNetworkAclEntry(createNetworkAclEntryRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(final DescribeExportTasksRequest describeExportTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeExportTasksResult>(){

            @Override
            public DescribeExportTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeExportTasks(describeExportTasksRequest);
            }
        });
    }

    @Override
    public Future<Void> detachInternetGatewayAsync(final DetachInternetGatewayRequest detachInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.detachInternetGateway(detachInternetGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateRouteTableResult> createRouteTableAsync(final CreateRouteTableRequest createRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateRouteTableResult>(){

            @Override
            public CreateRouteTableResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createRouteTable(createRouteTableRequest);
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(final DescribeVolumesRequest describeVolumesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVolumes(describeVolumesRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesListingsResult> describeReservedInstancesListingsAsync(final DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesListingsResult>(){

            @Override
            public DescribeReservedInstancesListingsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstancesListings(describeReservedInstancesListingsRequest);
            }
        });
    }

    @Override
    public Future<Void> reportInstanceStatusAsync(final ReportInstanceStatusRequest reportInstanceStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.reportInstanceStatus(reportInstanceStatusRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeRouteTablesResult> describeRouteTablesAsync(final DescribeRouteTablesRequest describeRouteTablesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeRouteTablesResult>(){

            @Override
            public DescribeRouteTablesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeRouteTables(describeRouteTablesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDhcpOptionsResult> describeDhcpOptionsAsync(final DescribeDhcpOptionsRequest describeDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDhcpOptionsResult>(){

            @Override
            public DescribeDhcpOptionsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeDhcpOptions(describeDhcpOptionsRequest);
            }
        });
    }

    @Override
    public Future<MonitorInstancesResult> monitorInstancesAsync(final MonitorInstancesRequest monitorInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<MonitorInstancesResult>(){

            @Override
            public MonitorInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.monitorInstances(monitorInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeNetworkAclsResult> describeNetworkAclsAsync(final DescribeNetworkAclsRequest describeNetworkAclsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkAclsResult>(){

            @Override
            public DescribeNetworkAclsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeNetworkAcls(describeNetworkAclsRequest);
            }
        });
    }

    @Override
    public Future<DescribeBundleTasksResult> describeBundleTasksAsync(final DescribeBundleTasksRequest describeBundleTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeBundleTasksResult>(){

            @Override
            public DescribeBundleTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeBundleTasks(describeBundleTasksRequest);
            }
        });
    }

    @Override
    public Future<ImportInstanceResult> importInstanceAsync(final ImportInstanceRequest importInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ImportInstanceResult>(){

            @Override
            public ImportInstanceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.importInstance(importInstanceRequest);
            }
        });
    }

    @Override
    public Future<Void> revokeSecurityGroupIngressAsync(final RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.revokeSecurityGroupIngress(revokeSecurityGroupIngressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<GetConsoleOutputResult> getConsoleOutputAsync(final GetConsoleOutputRequest getConsoleOutputRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetConsoleOutputResult>(){

            @Override
            public GetConsoleOutputResult call() throws Exception {
                return AmazonEC2AsyncClient.this.getConsoleOutput(getConsoleOutputRequest);
            }
        });
    }

    @Override
    public Future<CreateInternetGatewayResult> createInternetGatewayAsync(final CreateInternetGatewayRequest createInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateInternetGatewayResult>(){

            @Override
            public CreateInternetGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createInternetGateway(createInternetGatewayRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteVpnConnectionRouteAsync(final DeleteVpnConnectionRouteRequest deleteVpnConnectionRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpnConnectionRoute(deleteVpnConnectionRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> detachNetworkInterfaceAsync(final DetachNetworkInterfaceRequest detachNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.detachNetworkInterface(detachNetworkInterfaceRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyImageAttributeAsync(final ModifyImageAttributeRequest modifyImageAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyImageAttribute(modifyImageAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateCustomerGatewayResult> createCustomerGatewayAsync(final CreateCustomerGatewayRequest createCustomerGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateCustomerGatewayResult>(){

            @Override
            public CreateCustomerGatewayResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createCustomerGateway(createCustomerGatewayRequest);
            }
        });
    }

    @Override
    public Future<CreateSpotDatafeedSubscriptionResult> createSpotDatafeedSubscriptionAsync(final CreateSpotDatafeedSubscriptionRequest createSpotDatafeedSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSpotDatafeedSubscriptionResult>(){

            @Override
            public CreateSpotDatafeedSubscriptionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSpotDatafeedSubscription(createSpotDatafeedSubscriptionRequest);
            }
        });
    }

    @Override
    public Future<Void> attachInternetGatewayAsync(final AttachInternetGatewayRequest attachInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.attachInternetGateway(attachInternetGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpnConnectionAsync(final DeleteVpnConnectionRequest deleteVpnConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpnConnection(deleteVpnConnectionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeConversionTasksResult> describeConversionTasksAsync(final DescribeConversionTasksRequest describeConversionTasksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConversionTasksResult>(){

            @Override
            public DescribeConversionTasksResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeConversionTasks(describeConversionTasksRequest);
            }
        });
    }

    @Override
    public Future<CreateVpnConnectionResult> createVpnConnectionAsync(final CreateVpnConnectionRequest createVpnConnectionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpnConnectionResult>(){

            @Override
            public CreateVpnConnectionResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpnConnection(createVpnConnectionRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstanceAttributeResult> describeInstanceAttributeAsync(final DescribeInstanceAttributeRequest describeInstanceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceAttributeResult>(){

            @Override
            public DescribeInstanceAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInstanceAttribute(describeInstanceAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeSubnetsResult> describeSubnetsAsync(final DescribeSubnetsRequest describeSubnetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSubnetsResult>(){

            @Override
            public DescribeSubnetsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSubnets(describeSubnetsRequest);
            }
        });
    }

    @Override
    public Future<RunInstancesResult> runInstancesAsync(final RunInstancesRequest runInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RunInstancesResult>(){

            @Override
            public RunInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.runInstances(runInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribePlacementGroupsResult> describePlacementGroupsAsync(final DescribePlacementGroupsRequest describePlacementGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribePlacementGroupsResult>(){

            @Override
            public DescribePlacementGroupsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describePlacementGroups(describePlacementGroupsRequest);
            }
        });
    }

    @Override
    public Future<AssociateRouteTableResult> associateRouteTableAsync(final AssociateRouteTableRequest associateRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssociateRouteTableResult>(){

            @Override
            public AssociateRouteTableResult call() throws Exception {
                return AmazonEC2AsyncClient.this.associateRouteTable(associateRouteTableRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstancesResult> describeInstancesAsync(final DescribeInstancesRequest describeInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstancesResult>(){

            @Override
            public DescribeInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInstances(describeInstancesRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkAclAsync(final DeleteNetworkAclRequest deleteNetworkAclRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteNetworkAcl(deleteNetworkAclRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyVolumeAttributeAsync(final ModifyVolumeAttributeRequest modifyVolumeAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyVolumeAttribute(modifyVolumeAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(final DescribeImagesRequest describeImagesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeImages(describeImagesRequest);
            }
        });
    }

    @Override
    public Future<StartInstancesResult> startInstancesAsync(final StartInstancesRequest startInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartInstancesResult>(){

            @Override
            public StartInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.startInstances(startInstancesRequest);
            }
        });
    }

    @Override
    public Future<CancelReservedInstancesListingResult> cancelReservedInstancesListingAsync(final CancelReservedInstancesListingRequest cancelReservedInstancesListingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelReservedInstancesListingResult>(){

            @Override
            public CancelReservedInstancesListingResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelReservedInstancesListing(cancelReservedInstancesListingRequest);
            }
        });
    }

    @Override
    public Future<Void> modifyInstanceAttributeAsync(final ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyInstanceAttribute(modifyInstanceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDhcpOptionsAsync(final DeleteDhcpOptionsRequest deleteDhcpOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteDhcpOptions(deleteDhcpOptionsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> authorizeSecurityGroupIngressAsync(final AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.authorizeSecurityGroupIngress(authorizeSecurityGroupIngressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSpotInstanceRequestsResult> describeSpotInstanceRequestsAsync(final DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSpotInstanceRequestsResult>(){

            @Override
            public DescribeSpotInstanceRequestsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSpotInstanceRequests(describeSpotInstanceRequestsRequest);
            }
        });
    }

    @Override
    public Future<CreateVpcResult> createVpcAsync(final CreateVpcRequest createVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVpcResult>(){

            @Override
            public CreateVpcResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVpc(createVpcRequest);
            }
        });
    }

    @Override
    public Future<DescribeCustomerGatewaysResult> describeCustomerGatewaysAsync(final DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCustomerGatewaysResult>(){

            @Override
            public DescribeCustomerGatewaysResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeCustomerGateways(describeCustomerGatewaysRequest);
            }
        });
    }

    @Override
    public Future<Void> cancelExportTaskAsync(final CancelExportTaskRequest cancelExportTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.cancelExportTask(cancelExportTaskRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createRouteAsync(final CreateRouteRequest createRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createRoute(createRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyNetworkInterfaceAttributeAsync(final ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifyNetworkInterfaceAttribute(modifyNetworkInterfaceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRouteTableAsync(final DeleteRouteTableRequest deleteRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteRouteTable(deleteRouteTableRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeNetworkInterfaceAttributeResult> describeNetworkInterfaceAttributeAsync(final DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeNetworkInterfaceAttributeResult>(){

            @Override
            public DescribeNetworkInterfaceAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeNetworkInterfaceAttribute(describeNetworkInterfaceAttributeRequest);
            }
        });
    }

    @Override
    public Future<RequestSpotInstancesResult> requestSpotInstancesAsync(final RequestSpotInstancesRequest requestSpotInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RequestSpotInstancesResult>(){

            @Override
            public RequestSpotInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.requestSpotInstances(requestSpotInstancesRequest);
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createTags(createTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeVolumeAttributeResult> describeVolumeAttributeAsync(final DescribeVolumeAttributeRequest describeVolumeAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVolumeAttributeResult>(){

            @Override
            public DescribeVolumeAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVolumeAttribute(describeVolumeAttributeRequest);
            }
        });
    }

    @Override
    public Future<AttachNetworkInterfaceResult> attachNetworkInterfaceAsync(final AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AttachNetworkInterfaceResult>(){

            @Override
            public AttachNetworkInterfaceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.attachNetworkInterface(attachNetworkInterfaceRequest);
            }
        });
    }

    @Override
    public Future<Void> replaceRouteAsync(final ReplaceRouteRequest replaceRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.replaceRoute(replaceRouteRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeTags(describeTagsRequest);
            }
        });
    }

    @Override
    public Future<CancelBundleTaskResult> cancelBundleTaskAsync(final CancelBundleTaskRequest cancelBundleTaskRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelBundleTaskResult>(){

            @Override
            public CancelBundleTaskResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelBundleTask(cancelBundleTaskRequest);
            }
        });
    }

    @Override
    public Future<Void> disableVgwRoutePropagationAsync(final DisableVgwRoutePropagationRequest disableVgwRoutePropagationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.disableVgwRoutePropagation(disableVgwRoutePropagationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CancelSpotInstanceRequestsResult> cancelSpotInstanceRequestsAsync(final CancelSpotInstanceRequestsRequest cancelSpotInstanceRequestsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CancelSpotInstanceRequestsResult>(){

            @Override
            public CancelSpotInstanceRequestsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.cancelSpotInstanceRequests(cancelSpotInstanceRequestsRequest);
            }
        });
    }

    @Override
    public Future<PurchaseReservedInstancesOfferingResult> purchaseReservedInstancesOfferingAsync(final PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PurchaseReservedInstancesOfferingResult>(){

            @Override
            public PurchaseReservedInstancesOfferingResult call() throws Exception {
                return AmazonEC2AsyncClient.this.purchaseReservedInstancesOffering(purchaseReservedInstancesOfferingRequest);
            }
        });
    }

    @Override
    public Future<Void> modifySnapshotAttributeAsync(final ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.modifySnapshotAttribute(modifySnapshotAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<TerminateInstancesResult> terminateInstancesAsync(final TerminateInstancesRequest terminateInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstancesResult>(){

            @Override
            public TerminateInstancesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.terminateInstances(terminateInstancesRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteSpotDatafeedSubscriptionAsync(final DeleteSpotDatafeedSubscriptionRequest deleteSpotDatafeedSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSpotDatafeedSubscription(deleteSpotDatafeedSubscriptionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteInternetGatewayAsync(final DeleteInternetGatewayRequest deleteInternetGatewayRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteInternetGateway(deleteInternetGatewayRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotAttributeResult> describeSnapshotAttributeAsync(final DescribeSnapshotAttributeRequest describeSnapshotAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotAttributeResult>(){

            @Override
            public DescribeSnapshotAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSnapshotAttribute(describeSnapshotAttributeRequest);
            }
        });
    }

    @Override
    public Future<ReplaceRouteTableAssociationResult> replaceRouteTableAssociationAsync(final ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplaceRouteTableAssociationResult>(){

            @Override
            public ReplaceRouteTableAssociationResult call() throws Exception {
                return AmazonEC2AsyncClient.this.replaceRouteTableAssociation(replaceRouteTableAssociationRequest);
            }
        });
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(final DescribeAddressesRequest describeAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAddressesResult>(){

            @Override
            public DescribeAddressesResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeAddresses(describeAddressesRequest);
            }
        });
    }

    @Override
    public Future<DescribeImageAttributeResult> describeImageAttributeAsync(final DescribeImageAttributeRequest describeImageAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeImageAttributeResult>(){

            @Override
            public DescribeImageAttributeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeImageAttribute(describeImageAttributeRequest);
            }
        });
    }

    @Override
    public Future<DescribeKeyPairsResult> describeKeyPairsAsync(final DescribeKeyPairsRequest describeKeyPairsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeKeyPairsResult>(){

            @Override
            public DescribeKeyPairsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeKeyPairs(describeKeyPairsRequest);
            }
        });
    }

    @Override
    public Future<ConfirmProductInstanceResult> confirmProductInstanceAsync(final ConfirmProductInstanceRequest confirmProductInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ConfirmProductInstanceResult>(){

            @Override
            public ConfirmProductInstanceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.confirmProductInstance(confirmProductInstanceRequest);
            }
        });
    }

    @Override
    public Future<Void> disassociateRouteTableAsync(final DisassociateRouteTableRequest disassociateRouteTableRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.disassociateRouteTable(disassociateRouteTableRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> revokeSecurityGroupEgressAsync(final RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.revokeSecurityGroupEgress(revokeSecurityGroupEgressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteNetworkAclEntryAsync(final DeleteNetworkAclEntryRequest deleteNetworkAclEntryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteNetworkAclEntry(deleteNetworkAclEntryRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateVolumeResult> createVolumeAsync(final CreateVolumeRequest createVolumeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVolumeResult>(){

            @Override
            public CreateVolumeResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createVolume(createVolumeRequest);
            }
        });
    }

    @Override
    public Future<DescribeInstanceStatusResult> describeInstanceStatusAsync(final DescribeInstanceStatusRequest describeInstanceStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeInstanceStatusResult>(){

            @Override
            public DescribeInstanceStatusResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeInstanceStatus(describeInstanceStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeVpnGatewaysResult> describeVpnGatewaysAsync(final DescribeVpnGatewaysRequest describeVpnGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeVpnGatewaysResult>(){

            @Override
            public DescribeVpnGatewaysResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeVpnGateways(describeVpnGatewaysRequest);
            }
        });
    }

    @Override
    public Future<CreateSubnetResult> createSubnetAsync(final CreateSubnetRequest createSubnetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateSubnetResult>(){

            @Override
            public CreateSubnetResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createSubnet(createSubnetRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedInstancesOfferingsResult> describeReservedInstancesOfferingsAsync(final DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedInstancesOfferingsResult>(){

            @Override
            public DescribeReservedInstancesOfferingsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeReservedInstancesOfferings(describeReservedInstancesOfferingsRequest);
            }
        });
    }

    @Override
    public Future<Void> assignPrivateIpAddressesAsync(final AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.assignPrivateIpAddresses(assignPrivateIpAddressesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSnapshotAsync(final DeleteSnapshotRequest deleteSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteSnapshot(deleteSnapshotRequest);
                return null;
            }
        });
    }

    @Override
    public Future<ReplaceNetworkAclAssociationResult> replaceNetworkAclAssociationAsync(final ReplaceNetworkAclAssociationRequest replaceNetworkAclAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReplaceNetworkAclAssociationResult>(){

            @Override
            public ReplaceNetworkAclAssociationResult call() throws Exception {
                return AmazonEC2AsyncClient.this.replaceNetworkAclAssociation(replaceNetworkAclAssociationRequest);
            }
        });
    }

    @Override
    public Future<Void> disassociateAddressAsync(final DisassociateAddressRequest disassociateAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.disassociateAddress(disassociateAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createPlacementGroupAsync(final CreatePlacementGroupRequest createPlacementGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createPlacementGroup(createPlacementGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<BundleInstanceResult> bundleInstanceAsync(final BundleInstanceRequest bundleInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BundleInstanceResult>(){

            @Override
            public BundleInstanceResult call() throws Exception {
                return AmazonEC2AsyncClient.this.bundleInstance(bundleInstanceRequest);
            }
        });
    }

    @Override
    public Future<Void> deletePlacementGroupAsync(final DeletePlacementGroupRequest deletePlacementGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deletePlacementGroup(deletePlacementGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVpcAsync(final DeleteVpcRequest deleteVpcRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.deleteVpc(deleteVpcRequest);
                return null;
            }
        });
    }

    @Override
    public Future<AllocateAddressResult> allocateAddressAsync(final AllocateAddressRequest allocateAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AllocateAddressResult>(){

            @Override
            public AllocateAddressResult call() throws Exception {
                return AmazonEC2AsyncClient.this.allocateAddress(allocateAddressRequest);
            }
        });
    }

    @Override
    public Future<Void> releaseAddressAsync(final ReleaseAddressRequest releaseAddressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.releaseAddress(releaseAddressRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> resetInstanceAttributeAsync(final ResetInstanceAttributeRequest resetInstanceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetInstanceAttribute(resetInstanceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CreateKeyPairResult> createKeyPairAsync(final CreateKeyPairRequest createKeyPairRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateKeyPairResult>(){

            @Override
            public CreateKeyPairResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createKeyPair(createKeyPairRequest);
            }
        });
    }

    @Override
    public Future<Void> replaceNetworkAclEntryAsync(final ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.replaceNetworkAclEntry(replaceNetworkAclEntryRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(final DescribeSnapshotsRequest describeSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                return AmazonEC2AsyncClient.this.describeSnapshots(describeSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<CreateNetworkAclResult> createNetworkAclAsync(final CreateNetworkAclRequest createNetworkAclRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateNetworkAclResult>(){

            @Override
            public CreateNetworkAclResult call() throws Exception {
                return AmazonEC2AsyncClient.this.createNetworkAcl(createNetworkAclRequest);
            }
        });
    }

    @Override
    public Future<RegisterImageResult> registerImageAsync(final RegisterImageRequest registerImageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterImageResult>(){

            @Override
            public RegisterImageResult call() throws Exception {
                return AmazonEC2AsyncClient.this.registerImage(registerImageRequest);
            }
        });
    }

    @Override
    public Future<Void> resetNetworkInterfaceAttributeAsync(final ResetNetworkInterfaceAttributeRequest resetNetworkInterfaceAttributeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.resetNetworkInterfaceAttribute(resetNetworkInterfaceAttributeRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createVpnConnectionRouteAsync(final CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonEC2AsyncClient.this.createVpnConnectionRoute(createVpnConnectionRouteRequest);
                return null;
            }
        });
    }
}

