/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudWatchAsyncClient
extends AmazonCloudWatchClient
implements AmazonCloudWatchAsync {
    private ExecutorService executorService;

    public AmazonCloudWatchAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCloudWatchAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> putMetricAlarmAsync(final PutMetricAlarmRequest putMetricAlarmRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudWatchAsyncClient.this.putMetricAlarm(putMetricAlarmRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putMetricDataAsync(final PutMetricDataRequest putMetricDataRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudWatchAsyncClient.this.putMetricData(putMetricDataRequest);
                return null;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(final ListMetricsRequest listMetricsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListMetricsResult>(){

            @Override
            public ListMetricsResult call() throws Exception {
                return AmazonCloudWatchAsyncClient.this.listMetrics(listMetricsRequest);
            }
        });
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(final GetMetricStatisticsRequest getMetricStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetMetricStatisticsResult>(){

            @Override
            public GetMetricStatisticsResult call() throws Exception {
                return AmazonCloudWatchAsyncClient.this.getMetricStatistics(getMetricStatisticsRequest);
            }
        });
    }

    @Override
    public Future<Void> disableAlarmActionsAsync(final DisableAlarmActionsRequest disableAlarmActionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudWatchAsyncClient.this.disableAlarmActions(disableAlarmActionsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(final DescribeAlarmsRequest describeAlarmsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAlarmsResult>(){

            @Override
            public DescribeAlarmsResult call() throws Exception {
                return AmazonCloudWatchAsyncClient.this.describeAlarms(describeAlarmsRequest);
            }
        });
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(final DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAlarmsForMetricResult>(){

            @Override
            public DescribeAlarmsForMetricResult call() throws Exception {
                return AmazonCloudWatchAsyncClient.this.describeAlarmsForMetric(describeAlarmsForMetricRequest);
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(final DescribeAlarmHistoryRequest describeAlarmHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAlarmHistoryResult>(){

            @Override
            public DescribeAlarmHistoryResult call() throws Exception {
                return AmazonCloudWatchAsyncClient.this.describeAlarmHistory(describeAlarmHistoryRequest);
            }
        });
    }

    @Override
    public Future<Void> enableAlarmActionsAsync(final EnableAlarmActionsRequest enableAlarmActionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudWatchAsyncClient.this.enableAlarmActions(enableAlarmActionsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAlarmsAsync(final DeleteAlarmsRequest deleteAlarmsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudWatchAsyncClient.this.deleteAlarms(deleteAlarmsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setAlarmStateAsync(final SetAlarmStateRequest setAlarmStateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudWatchAsyncClient.this.setAlarmState(setAlarmStateRequest);
                return null;
            }
        });
    }
}

