/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.transform.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    @Override
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        if (listResourceRecordSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListResourceRecordSetsRequest> request = new DefaultRequest<ListResourceRecordSetsRequest>(listResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2011-05-05/hostedzone/{Id}/rrset?type={Type}&name={Name}&identifier={Identifier}&maxitems={MaxItems}";
        uriResourcePath = uriResourcePath.replace("{Id}", this.getString(listResourceRecordSetsRequest.getHostedZoneId()));
        uriResourcePath = uriResourcePath.replace("{Name}", this.getString(listResourceRecordSetsRequest.getStartRecordName()));
        uriResourcePath = uriResourcePath.replace("{Type}", this.getString(listResourceRecordSetsRequest.getStartRecordType()));
        uriResourcePath = uriResourcePath.replace("{Identifier}", this.getString(listResourceRecordSetsRequest.getStartRecordIdentifier()));
        uriResourcePath = uriResourcePath.replace("{MaxItems}", this.getString(listResourceRecordSetsRequest.getMaxItems()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("&")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

