/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.datamodeling.internal;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodb.datamodeling.internal.PaginatedList;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedScanList<T>
extends PaginatedList<T> {
    private final ScanRequest scanRequest;
    private ScanResult scanResult;

    public PaginatedScanList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, int size, ScanRequest scanRequest, ScanResult scanResult) {
        super(mapper, clazz, dynamo, size);
        this.scanRequest = scanRequest;
        this.scanResult = scanResult;
        this.unmarshallResults(scanResult.getItems());
    }

    @Override
    protected synchronized boolean hasMoreResults() {
        return this.scanResult.getLastEvaluatedKey() != null;
    }

    @Override
    protected synchronized void loadNextResult() {
        this.scanRequest.setExclusiveStartKey(this.scanResult.getLastEvaluatedKey());
        this.scanResult = this.dynamo.scan(PaginatedScanList.applyUserAgent(this.scanRequest));
        this.unmarshallResults(this.scanResult.getItems());
    }
}

