/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPartsRequestMarshaller
implements Marshaller<Request<ListPartsRequest>, ListPartsRequest> {
    @Override
    public Request<ListPartsRequest> marshall(ListPartsRequest listPartsRequest) {
        if (listPartsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPartsRequest> request = new DefaultRequest<ListPartsRequest>(listPartsRequest, "AmazonGlacier");
        String target = "Glacier.ListParts";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}?marker={marker};limit={limit}";
        uriResourcePath = uriResourcePath.replace("{accountId}", this.getString(listPartsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", this.getString(listPartsRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{uploadId}", this.getString(listPartsRequest.getUploadId()));
        uriResourcePath = uriResourcePath.replace("{marker}", this.getString(listPartsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{limit}", this.getString(listPartsRequest.getLimit()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

