/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.handlers;

import com.amazonaws.AmazonClientException;
import com.amazonaws.handlers.RequestHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainFactory {
    public List<RequestHandler> newRequestHandlerChain(String resource) {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        try {
            String requestHandlerClassName;
            InputStream input = this.getClass().getResourceAsStream(resource);
            if (input == null) {
                return handlers;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((requestHandlerClassName = reader.readLine()) != null) {
                if ((requestHandlerClassName = requestHandlerClassName.trim()).equals("")) continue;
                Class<?> requestHandlerClass = this.getClass().getClassLoader().loadClass(requestHandlerClassName);
                Object requestHandlerObject = requestHandlerClass.newInstance();
                if (requestHandlerObject instanceof RequestHandler) {
                    handlers.add((RequestHandler)requestHandlerObject);
                    continue;
                }
                throw new AmazonClientException("Unable to instantiate request handler chain for client.  Listed request handler ('" + requestHandlerClassName + "') " + "does not implement the RequestHandler interface.");
            }
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to instantiate request handler chain for client: " + e.getMessage(), e);
        }
        return handlers;
    }
}

