/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncScope;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionContextImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericActivityClientImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowClientImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.HistoryHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.WorkflowClockImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.WorkfowContextImpl;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.EventType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.StartTimerFailedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.TimerFiredEventAttributes;
import com.amazonaws.services.simpleworkflow.model.TimerStartedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionSignaledEventAttributes;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionStartedEventAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncDecider {
    private static final Log log = LogFactory.getLog(AsyncDecider.class);
    private final WorkflowDefinitionFactory workflowDefinitionFactory;
    private WorkflowDefinition definition;
    private final HistoryHelper historyHelper;
    private final DecisionsHelper decisionsHelper;
    private final GenericActivityClientImpl activityClient;
    private final GenericWorkflowClientImpl workflowClient;
    private final WorkflowClockImpl workflowClock;
    private final DecisionContext context;
    private WorkflowAsyncScope workflowAsyncScope;
    private boolean cancelRequested;
    private WorkfowContextImpl workflowContext;
    private boolean unhandledDecision;
    private boolean completed;
    private Throwable failure;

    public AsyncDecider(WorkflowDefinitionFactory workflowDefinitionFactory, HistoryHelper historyHelper, DecisionsHelper decisionsHelper) throws Exception {
        this.workflowDefinitionFactory = workflowDefinitionFactory;
        this.historyHelper = historyHelper;
        this.decisionsHelper = decisionsHelper;
        this.activityClient = new GenericActivityClientImpl(decisionsHelper);
        DecisionTask decisionTask = historyHelper.getDecisionTask();
        this.workflowContext = new WorkfowContextImpl(decisionTask);
        this.workflowClient = new GenericWorkflowClientImpl(decisionsHelper, this.workflowContext);
        this.workflowClock = new WorkflowClockImpl(decisionsHelper);
        this.context = new DecisionContextImpl(this.activityClient, this.workflowClient, this.workflowClock, this.workflowContext);
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    private void handleWorkflowExecutionStarted(HistoryEvent event) {
        this.workflowAsyncScope = new WorkflowExecuteAsyncScope(event);
    }

    private void processEvent(HistoryEvent event, EventType eventType) throws Throwable {
        switch (eventType) {
            case ActivityTaskCanceled: {
                this.activityClient.handleActivityTaskCanceled(event);
                break;
            }
            case ActivityTaskCompleted: {
                this.activityClient.handleActivityTaskCompleted(event);
                break;
            }
            case ActivityTaskFailed: {
                this.activityClient.handleActivityTaskFailed(event);
                break;
            }
            case ActivityTaskStarted: {
                this.activityClient.handleActivityTaskStarted(event.getActivityTaskStartedEventAttributes());
                break;
            }
            case ActivityTaskTimedOut: {
                this.activityClient.handleActivityTaskTimedOut(event);
                break;
            }
            case ExternalWorkflowExecutionCancelRequested: {
                this.workflowClient.handleChildWorkflowExecutionCancelRequested(event);
                break;
            }
            case ChildWorkflowExecutionCanceled: {
                this.workflowClient.handleChildWorkflowExecutionCanceled(event);
                break;
            }
            case ChildWorkflowExecutionCompleted: {
                this.workflowClient.handleChildWorkflowExecutionCompleted(event);
                break;
            }
            case ChildWorkflowExecutionFailed: {
                this.workflowClient.handleChildWorkflowExecutionFailed(event);
                break;
            }
            case ChildWorkflowExecutionStarted: {
                this.workflowClient.handleChildWorkflowExecutionStarted(event);
                break;
            }
            case ChildWorkflowExecutionTerminated: {
                this.workflowClient.handleChildWorkflowExecutionTerminated(event);
                break;
            }
            case ChildWorkflowExecutionTimedOut: {
                this.workflowClient.handleChildWorkflowExecutionTimedOut(event);
                break;
            }
            case DecisionTaskCompleted: {
                this.handleDecisionTaskCompleted(event);
                break;
            }
            case DecisionTaskScheduled: {
                break;
            }
            case DecisionTaskStarted: {
                this.handleDecisionTaskStarted(event);
                break;
            }
            case DecisionTaskTimedOut: {
                break;
            }
            case ExternalWorkflowExecutionSignaled: {
                this.workflowClient.handleExternalWorkflowExecutionSignaled(event);
                break;
            }
            case ScheduleActivityTaskFailed: {
                this.activityClient.handleScheduleActivityTaskFailed(event);
                break;
            }
            case SignalExternalWorkflowExecutionFailed: {
                this.workflowClient.handleSignalExternalWorkflowExecutionFailed(event);
                break;
            }
            case StartChildWorkflowExecutionFailed: {
                this.workflowClient.handleStartChildWorkflowExecutionFailed(event);
                break;
            }
            case StartTimerFailed: {
                this.handleStartTimerFailed(event);
                break;
            }
            case TimerFired: {
                this.handleTimerFired(event);
                break;
            }
            case WorkflowExecutionCancelRequested: {
                this.handleWorkflowExecutionCancelRequested(event);
                break;
            }
            case WorkflowExecutionSignaled: {
                this.handleWorkflowExecutionSignaled(event);
                break;
            }
            case WorkflowExecutionStarted: {
                this.handleWorkflowExecutionStarted(event);
                break;
            }
            case WorkflowExecutionTerminated: {
                break;
            }
            case WorkflowExecutionTimedOut: {
                break;
            }
            case ActivityTaskScheduled: {
                this.decisionsHelper.handleActivityTaskScheduled(event);
                break;
            }
            case ActivityTaskCancelRequested: {
                this.decisionsHelper.handleActivityTaskCancelRequested(event);
                break;
            }
            case RequestCancelActivityTaskFailed: {
                this.decisionsHelper.handleRequestCancelActivityTaskFailed(event);
                break;
            }
            case MarkerRecorded: {
                break;
            }
            case WorkflowExecutionCompleted: {
                break;
            }
            case CompleteWorkflowExecutionFailed: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleCompleteWorkflowExecutionFailed(event);
                break;
            }
            case WorkflowExecutionFailed: {
                break;
            }
            case FailWorkflowExecutionFailed: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleFailWorkflowExecutionFailed(event);
                break;
            }
            case WorkflowExecutionCanceled: {
                break;
            }
            case CancelWorkflowExecutionFailed: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleCancelWorkflowExecutionFailed(event);
                break;
            }
            case WorkflowExecutionContinuedAsNew: {
                break;
            }
            case ContinueAsNewWorkflowExecutionFailed: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleContinueAsNewWorkflowExecutionFailed(event);
                break;
            }
            case TimerStarted: {
                this.handleTimerStarted(event);
                break;
            }
            case TimerCanceled: {
                this.workflowClock.handleTimerCanceled(event);
                break;
            }
            case SignalExternalWorkflowExecutionInitiated: {
                this.decisionsHelper.handleSignalExternalWorkflowExecutionInitiated(event);
                break;
            }
            case RequestCancelExternalWorkflowExecutionInitiated: {
                this.decisionsHelper.handleRequestCancelExternalWorkflowExecutionInitiated(event);
                break;
            }
            case RequestCancelExternalWorkflowExecutionFailed: {
                this.decisionsHelper.handleRequestCancelExternalWorkflowExecutionFailed(event);
                break;
            }
            case StartChildWorkflowExecutionInitiated: {
                this.decisionsHelper.handleStartChildWorkflowExecutionInitiated(event);
                break;
            }
            case CancelTimerFailed: {
                this.decisionsHelper.handleCancelTimerFailed(event);
            }
        }
    }

    private void eventLoop(HistoryEvent event) throws Throwable {
        if (this.completed) {
            return;
        }
        try {
            this.completed = this.workflowAsyncScope.eventLoop();
        }
        catch (CancellationException e) {
            if (!this.cancelRequested) {
                this.failure = e;
            }
            this.completed = true;
        }
        catch (Throwable e) {
            this.failure = e;
            this.completed = true;
        }
    }

    private void completeWorkflow() {
        if (this.completed && !this.unhandledDecision) {
            if (this.failure != null) {
                this.decisionsHelper.failWorkflowExecution(this.failure);
            } else if (this.cancelRequested) {
                this.decisionsHelper.cancelWorkflowExecution();
            } else {
                ContinueAsNewWorkflowExecutionParameters continueAsNewOnCompletion = this.workflowContext.getContinueAsNewOnCompletion();
                if (continueAsNewOnCompletion != null) {
                    this.decisionsHelper.continueAsNewWorkflowExecution(continueAsNewOnCompletion);
                } else {
                    Promise<String> output = this.workflowAsyncScope.getOutput();
                    if (output != null && output.isReady()) {
                        String workflowOutput = output.get();
                        this.decisionsHelper.completeWorkflowExecution(workflowOutput);
                    } else {
                        this.decisionsHelper.completeWorkflowExecution(null);
                    }
                }
            }
        }
    }

    private void handleDecisionTaskStarted(HistoryEvent event) throws Throwable {
    }

    private void handleWorkflowExecutionCancelRequested(HistoryEvent event) throws Throwable {
        this.workflowContext.setCancelRequested(true);
        this.workflowAsyncScope.cancel(new CancellationException());
        this.cancelRequested = true;
    }

    private void handleStartTimerFailed(HistoryEvent event) {
        StartTimerFailedEventAttributes attributes = event.getStartTimerFailedEventAttributes();
        String timerId = attributes.getTimerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.workflowClock.handleStartTimerFailed(event);
    }

    private void handleTimerFired(HistoryEvent event) throws Throwable {
        TimerFiredEventAttributes attributes = event.getTimerFiredEventAttributes();
        String timerId = attributes.getTimerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.workflowClock.handleTimerFired(event.getEventId(), attributes);
    }

    private void handleTimerStarted(HistoryEvent event) {
        TimerStartedEventAttributes attributes = event.getTimerStartedEventAttributes();
        String timerId = attributes.getTimerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.decisionsHelper.handleTimerStarted(event);
    }

    private void handleWorkflowExecutionSignaled(HistoryEvent event) throws Throwable {
        assert (event.getEventType().equals(EventType.WorkflowExecutionSignaled.toString()));
        final WorkflowExecutionSignaledEventAttributes signalAttributes = event.getWorkflowExecutionSignaledEventAttributes();
        if (this.completed) {
            this.workflowAsyncScope = new UnhandledSignalAsyncScope(this.workflowAsyncScope.getOutput(), this.workflowAsyncScope.getFailure(), this.workflowAsyncScope.isCancelRequested());
            this.completed = false;
        }
        new Task(this.workflowAsyncScope, new Promise[0]){

            protected void doExecute() throws Throwable {
                AsyncDecider.this.definition.signalRecieved(signalAttributes.getSignalName(), signalAttributes.getInput());
            }
        };
    }

    private void handleDecisionTaskCompleted(HistoryEvent event) {
        this.decisionsHelper.handleDecisionCompletion(event.getDecisionTaskCompletedEventAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decide() throws Exception {
        block34: {
            try {
                this.definition = this.workflowDefinitionFactory.getWorkflowDefinition(this.context);
                if (this.definition == null) {
                    throw new IllegalStateException("Unknown workflow type: " + this.context.getWorkflowContext().getWorkflowType());
                }
                long lastNonReplayedEventId = this.historyHelper.getLastNonReplayEventId();
                HistoryHelper.EventsIterator eventsIterator = this.historyHelper.getEvents();
                ArrayList reordered = null;
                do {
                    ArrayList<HistoryEvent> decisionStartToCompletionEvents = new ArrayList<HistoryEvent>();
                    ArrayList<HistoryEvent> decisionCompletionToStartEvents = new ArrayList<HistoryEvent>();
                    boolean concurrentToDecision = true;
                    int lastDecisionIndex = -1;
                    while (eventsIterator.hasNext()) {
                        HistoryEvent event = eventsIterator.next();
                        EventType eventType = EventType.valueOf(event.getEventType());
                        if (eventType == EventType.DecisionTaskCompleted) {
                            this.decisionsHelper.setWorkflowContextData(event.getDecisionTaskCompletedEventAttributes().getExecutionContext());
                            concurrentToDecision = false;
                            continue;
                        }
                        if (eventType == EventType.DecisionTaskStarted) {
                            this.decisionsHelper.handleDecisionTaskStartedEvent();
                            if (eventsIterator.isNextDecisionTimedOut()) continue;
                            long replayCurrentTimeMilliseconds = event.getEventTimestamp().getTime();
                            this.workflowClock.setReplayCurrentTimeMilliseconds(replayCurrentTimeMilliseconds);
                            break;
                        }
                        if (eventType == EventType.DecisionTaskScheduled || eventType == EventType.DecisionTaskTimedOut) continue;
                        if (concurrentToDecision) {
                            decisionStartToCompletionEvents.add(event);
                            continue;
                        }
                        if (this.isDecisionEvent(eventType)) {
                            lastDecisionIndex = decisionCompletionToStartEvents.size();
                        }
                        decisionCompletionToStartEvents.add(event);
                    }
                    int size = decisionStartToCompletionEvents.size() + decisionStartToCompletionEvents.size();
                    reordered = new ArrayList(size);
                    if (lastDecisionIndex >= 0) {
                        reordered.addAll(decisionCompletionToStartEvents.subList(0, lastDecisionIndex + 1));
                    }
                    reordered.addAll(decisionStartToCompletionEvents);
                    if (decisionCompletionToStartEvents.size() > lastDecisionIndex + 1) {
                        reordered.addAll(decisionCompletionToStartEvents.subList(lastDecisionIndex + 1, decisionCompletionToStartEvents.size()));
                    }
                    for (HistoryEvent event : reordered) {
                        if (event.getEventId() >= lastNonReplayedEventId) {
                            this.workflowClock.setReplaying(false);
                        }
                        EventType eventType = EventType.valueOf(event.getEventType());
                        this.processEvent(event, eventType);
                        this.eventLoop(event);
                    }
                    this.completeWorkflow();
                } while (eventsIterator.hasNext());
                if (this.unhandledDecision) {
                    this.unhandledDecision = false;
                    this.completeWorkflow();
                }
            }
            catch (AmazonServiceException e) {
                if (e.getErrorType() == AmazonServiceException.ErrorType.Client && !"ThrottlingException".equals(e.getErrorCode())) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Failing workflow " + this.workflowContext.getWorkflowExecution()), (Throwable)e);
                    }
                    this.decisionsHelper.failWorkflowDueToUnexpectedError(e);
                    break block34;
                }
                throw e;
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Failing workflow " + this.workflowContext.getWorkflowExecution()), e);
                }
                this.decisionsHelper.failWorkflowDueToUnexpectedError(e);
            }
            finally {
                try {
                    this.decisionsHelper.setWorkflowContextData(this.definition.getWorkflowState());
                }
                catch (WorkflowException e) {
                    this.decisionsHelper.setWorkflowContextData(e.getDetails());
                }
                catch (Throwable e) {
                    this.decisionsHelper.setWorkflowContextData(e.getMessage());
                }
                this.workflowDefinitionFactory.deleteWorkflowDefinition(this.definition);
            }
        }
    }

    private boolean isDecisionEvent(EventType eventType) {
        switch (eventType) {
            case ScheduleActivityTaskFailed: 
            case SignalExternalWorkflowExecutionFailed: 
            case StartChildWorkflowExecutionFailed: 
            case StartTimerFailed: 
            case ActivityTaskScheduled: 
            case ActivityTaskCancelRequested: 
            case RequestCancelActivityTaskFailed: 
            case MarkerRecorded: 
            case WorkflowExecutionCompleted: 
            case CompleteWorkflowExecutionFailed: 
            case WorkflowExecutionFailed: 
            case FailWorkflowExecutionFailed: 
            case WorkflowExecutionCanceled: 
            case CancelWorkflowExecutionFailed: 
            case WorkflowExecutionContinuedAsNew: 
            case ContinueAsNewWorkflowExecutionFailed: 
            case TimerStarted: 
            case TimerCanceled: 
            case SignalExternalWorkflowExecutionInitiated: 
            case RequestCancelExternalWorkflowExecutionInitiated: 
            case RequestCancelExternalWorkflowExecutionFailed: 
            case StartChildWorkflowExecutionInitiated: 
            case CancelTimerFailed: {
                return true;
            }
        }
        return false;
    }

    public List<AsyncTaskInfo> getAsynchronousThreadDump() {
        this.checkAsynchronousThreadDumpState();
        return this.workflowAsyncScope.getAsynchronousThreadDump();
    }

    public String getAsynchronousThreadDumpAsString() {
        this.checkAsynchronousThreadDumpState();
        return this.workflowAsyncScope.getAsynchronousThreadDumpAsString();
    }

    private void checkAsynchronousThreadDumpState() {
        if (this.workflowAsyncScope == null) {
            throw new IllegalStateException("workflow hasn't started yet");
        }
        if (this.decisionsHelper.isWorkflowFailed()) {
            throw new IllegalStateException("Cannot get AsynchronousThreadDump of a failed workflow", this.decisionsHelper.getWorkflowFailureCause());
        }
    }

    public DecisionsHelper getDecisionsHelper() {
        return this.decisionsHelper;
    }

    public WorkflowDefinition getWorkflowDefinition() {
        return this.definition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnhandledSignalAsyncScope
    extends WorkflowAsyncScope {
        private final Promise<String> output;
        private Throwable failure;
        private boolean cancellation;

        public UnhandledSignalAsyncScope(Promise<String> output, Throwable failure, boolean cancellation) {
            this.output = output;
            this.failure = failure;
            this.cancellation = cancellation;
        }

        @Override
        protected void doAsync() throws Throwable {
        }

        @Override
        public Promise<String> getOutput() {
            return this.output;
        }

        @Override
        public boolean isCancelRequested() {
            return super.isCancelRequested() || this.cancellation;
        }

        @Override
        public Throwable getFailure() {
            Throwable result = super.getFailure();
            if (this.failure != null) {
                result = this.failure;
            }
            return result;
        }

        @Override
        public boolean eventLoop() throws Throwable {
            boolean completed = super.eventLoop();
            if (completed && this.failure != null) {
                throw this.failure;
            }
            return completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WorkflowExecuteAsyncScope
    extends WorkflowAsyncScope {
        private final WorkflowExecutionStartedEventAttributes attributes;
        private Promise<String> output;

        public WorkflowExecuteAsyncScope(HistoryEvent event) {
            assert (event.getEventType().equals(EventType.WorkflowExecutionStarted.toString()));
            this.attributes = event.getWorkflowExecutionStartedEventAttributes();
        }

        @Override
        protected void doAsync() throws Throwable {
            this.output = AsyncDecider.this.definition.execute(this.attributes.getInput());
        }

        @Override
        public Promise<String> getOutput() {
            return this.output;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class WorkflowAsyncScope
    extends AsyncScope {
        public WorkflowAsyncScope() {
            super(false, true);
        }

        public abstract Promise<String> getOutput();
    }
}

