/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShutdownGatewayRequestMarshaller
implements Marshaller<Request<ShutdownGatewayRequest>, ShutdownGatewayRequest> {
    @Override
    public Request<ShutdownGatewayRequest> marshall(ShutdownGatewayRequest shutdownGatewayRequest) {
        if (shutdownGatewayRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ShutdownGatewayRequest> request = new DefaultRequest<ShutdownGatewayRequest>(shutdownGatewayRequest, "AWSStorageGateway");
        String target = "StorageGateway_20120430.ShutdownGateway";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (shutdownGatewayRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value(shutdownGatewayRequest.getGatewayARN());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

