/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticache.AmazonElastiCache;
import com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheParameterGroup;
import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesResult;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ReservedCacheNode;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.transform.AuthorizationAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.AuthorizationNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.AuthorizeCacheSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheClusterAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheClusterNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheClusterStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheParameterGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheParameterGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheParameterGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheParameterGroupStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheSecurityGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheSecurityGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheSecurityGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CacheSecurityGroupStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ClusterQuotaForCustomerExceededExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.CreateCacheClusterRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.CreateCacheParameterGroupRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.CreateCacheSecurityGroupRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DeleteCacheClusterRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DeleteCacheParameterGroupRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DeleteCacheSecurityGroupRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheClustersRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheClustersResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheParameterGroupsRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheParameterGroupsResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheParametersRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheParametersResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheSecurityGroupsRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeCacheSecurityGroupsResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeEngineDefaultParametersRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeReservedCacheNodesOfferingsRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeReservedCacheNodesOfferingsResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeReservedCacheNodesRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.DescribeReservedCacheNodesResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.EngineDefaultsStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.InsufficientCacheClusterCapacityExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.InvalidCacheClusterStateExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.InvalidCacheParameterGroupStateExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.InvalidCacheSecurityGroupStateExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.InvalidParameterCombinationExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ModifyCacheClusterRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.ModifyCacheParameterGroupRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.ModifyCacheParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.NodeQuotaForClusterExceededExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.NodeQuotaForCustomerExceededExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.PurchaseReservedCacheNodesOfferingRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.RebootCacheClusterRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.ReservedCacheNodeAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ReservedCacheNodeNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ReservedCacheNodeQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ReservedCacheNodeStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ReservedCacheNodesOfferingNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.ResetCacheParameterGroupRequestMarshaller;
import com.amazonaws.services.elasticache.model.transform.ResetCacheParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.elasticache.model.transform.RevokeCacheSecurityGroupIngressRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElastiCacheClient
extends AmazonWebServiceClient
implements AmazonElastiCache {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private QueryStringSigner signer;

    public AmazonElastiCacheClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElastiCacheClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElastiCacheClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElastiCacheClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new NodeQuotaForCustomerExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientCacheClusterCapacityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheParameterGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ClusterQuotaForCustomerExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheClusterAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterCombinationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheClusterNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheParameterGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheSecurityGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCacheParameterGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheSecurityGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCacheClusterStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheSecurityGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCacheSecurityGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CacheParameterGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedCacheNodeAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedCacheNodesOfferingNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NodeQuotaForClusterExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedCacheNodeNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedCacheNodeQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticache.us-east-1.amazonaws.com/");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticache/request.handlers"));
    }

    @Override
    public ModifyCacheParameterGroupResult modifyCacheParameterGroup(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyCacheParameterGroupRequest> request = new ModifyCacheParameterGroupRequestMarshaller().marshall(modifyCacheParameterGroupRequest);
        return this.invoke(request, new ModifyCacheParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public CacheSecurityGroup authorizeCacheSecurityGroupIngress(AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<AuthorizeCacheSecurityGroupIngressRequest> request = new AuthorizeCacheSecurityGroupIngressRequestMarshaller().marshall(authorizeCacheSecurityGroupIngressRequest);
        return this.invoke(request, new CacheSecurityGroupStaxUnmarshaller());
    }

    @Override
    public CacheCluster rebootCacheCluster(RebootCacheClusterRequest rebootCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<RebootCacheClusterRequest> request = new RebootCacheClusterRequestMarshaller().marshall(rebootCacheClusterRequest);
        return this.invoke(request, new CacheClusterStaxUnmarshaller());
    }

    @Override
    public DescribeReservedCacheNodesOfferingsResult describeReservedCacheNodesOfferings(DescribeReservedCacheNodesOfferingsRequest describeReservedCacheNodesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedCacheNodesOfferingsRequest> request = new DescribeReservedCacheNodesOfferingsRequestMarshaller().marshall(describeReservedCacheNodesOfferingsRequest);
        return this.invoke(request, new DescribeReservedCacheNodesOfferingsResultStaxUnmarshaller());
    }

    @Override
    public CacheCluster deleteCacheCluster(DeleteCacheClusterRequest deleteCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteCacheClusterRequest> request = new DeleteCacheClusterRequestMarshaller().marshall(deleteCacheClusterRequest);
        return this.invoke(request, new CacheClusterStaxUnmarshaller());
    }

    @Override
    public CacheCluster createCacheCluster(CreateCacheClusterRequest createCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateCacheClusterRequest> request = new CreateCacheClusterRequestMarshaller().marshall(createCacheClusterRequest);
        return this.invoke(request, new CacheClusterStaxUnmarshaller());
    }

    @Override
    public CacheSecurityGroup revokeCacheSecurityGroupIngress(RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<RevokeCacheSecurityGroupIngressRequest> request = new RevokeCacheSecurityGroupIngressRequestMarshaller().marshall(revokeCacheSecurityGroupIngressRequest);
        return this.invoke(request, new CacheSecurityGroupStaxUnmarshaller());
    }

    @Override
    public CacheParameterGroup createCacheParameterGroup(CreateCacheParameterGroupRequest createCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateCacheParameterGroupRequest> request = new CreateCacheParameterGroupRequestMarshaller().marshall(createCacheParameterGroupRequest);
        return this.invoke(request, new CacheParameterGroupStaxUnmarshaller());
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventsRequest> request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
        return this.invoke(request, new DescribeEventsResultStaxUnmarshaller());
    }

    @Override
    public DescribeReservedCacheNodesResult describeReservedCacheNodes(DescribeReservedCacheNodesRequest describeReservedCacheNodesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedCacheNodesRequest> request = new DescribeReservedCacheNodesRequestMarshaller().marshall(describeReservedCacheNodesRequest);
        return this.invoke(request, new DescribeReservedCacheNodesResultStaxUnmarshaller());
    }

    @Override
    public DescribeCacheParameterGroupsResult describeCacheParameterGroups(DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeCacheParameterGroupsRequest> request = new DescribeCacheParameterGroupsRequestMarshaller().marshall(describeCacheParameterGroupsRequest);
        return this.invoke(request, new DescribeCacheParameterGroupsResultStaxUnmarshaller());
    }

    @Override
    public void deleteCacheParameterGroup(DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteCacheParameterGroupRequest> request = new DeleteCacheParameterGroupRequestMarshaller().marshall(deleteCacheParameterGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteCacheSecurityGroup(DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteCacheSecurityGroupRequest> request = new DeleteCacheSecurityGroupRequestMarshaller().marshall(deleteCacheSecurityGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public ReservedCacheNode purchaseReservedCacheNodesOffering(PurchaseReservedCacheNodesOfferingRequest purchaseReservedCacheNodesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        Request<PurchaseReservedCacheNodesOfferingRequest> request = new PurchaseReservedCacheNodesOfferingRequestMarshaller().marshall(purchaseReservedCacheNodesOfferingRequest);
        return this.invoke(request, new ReservedCacheNodeStaxUnmarshaller());
    }

    @Override
    public DescribeCacheClustersResult describeCacheClusters(DescribeCacheClustersRequest describeCacheClustersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeCacheClustersRequest> request = new DescribeCacheClustersRequestMarshaller().marshall(describeCacheClustersRequest);
        return this.invoke(request, new DescribeCacheClustersResultStaxUnmarshaller());
    }

    @Override
    public CacheCluster modifyCacheCluster(ModifyCacheClusterRequest modifyCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyCacheClusterRequest> request = new ModifyCacheClusterRequestMarshaller().marshall(modifyCacheClusterRequest);
        return this.invoke(request, new CacheClusterStaxUnmarshaller());
    }

    @Override
    public DescribeCacheSecurityGroupsResult describeCacheSecurityGroups(DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeCacheSecurityGroupsRequest> request = new DescribeCacheSecurityGroupsRequestMarshaller().marshall(describeCacheSecurityGroupsRequest);
        return this.invoke(request, new DescribeCacheSecurityGroupsResultStaxUnmarshaller());
    }

    @Override
    public CacheSecurityGroup createCacheSecurityGroup(CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateCacheSecurityGroupRequest> request = new CreateCacheSecurityGroupRequestMarshaller().marshall(createCacheSecurityGroupRequest);
        return this.invoke(request, new CacheSecurityGroupStaxUnmarshaller());
    }

    @Override
    public DescribeCacheParametersResult describeCacheParameters(DescribeCacheParametersRequest describeCacheParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeCacheParametersRequest> request = new DescribeCacheParametersRequestMarshaller().marshall(describeCacheParametersRequest);
        return this.invoke(request, new DescribeCacheParametersResultStaxUnmarshaller());
    }

    @Override
    public EngineDefaults describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEngineDefaultParametersRequest> request = new DescribeEngineDefaultParametersRequestMarshaller().marshall(describeEngineDefaultParametersRequest);
        return this.invoke(request, new EngineDefaultsStaxUnmarshaller());
    }

    @Override
    public ResetCacheParameterGroupResult resetCacheParameterGroup(ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResetCacheParameterGroupRequest> request = new ResetCacheParameterGroupRequestMarshaller().marshall(resetCacheParameterGroupRequest);
        return this.invoke(request, new ResetCacheParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public DescribeReservedCacheNodesOfferingsResult describeReservedCacheNodesOfferings() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedCacheNodesOfferings(new DescribeReservedCacheNodesOfferingsRequest());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    @Override
    public DescribeReservedCacheNodesResult describeReservedCacheNodes() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedCacheNodes(new DescribeReservedCacheNodesRequest());
    }

    @Override
    public DescribeCacheParameterGroupsResult describeCacheParameterGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeCacheParameterGroups(new DescribeCacheParameterGroupsRequest());
    }

    @Override
    public DescribeCacheClustersResult describeCacheClusters() throws AmazonServiceException, AmazonClientException {
        return this.describeCacheClusters(new DescribeCacheClustersRequest());
    }

    @Override
    public DescribeCacheSecurityGroupsResult describeCacheSecurityGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeCacheSecurityGroups(new DescribeCacheSecurityGroupsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

