/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    @Override
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ScanRequest> request = new DefaultRequest<ScanRequest>(scanRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.Scan";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            Key exclusiveStartKey;
            List<String> attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (scanRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(scanRequest.getTableName());
            }
            if ((attributesToGetList = scanRequest.getAttributesToGet()) != null && attributesToGetList.size() > 0) {
                jsonWriter.key("AttributesToGet").array();
                for (String string : attributesToGetList) {
                    jsonWriter.value(string);
                }
                jsonWriter.endArray();
            }
            if (scanRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(scanRequest.getLimit());
            }
            if (scanRequest.isCount() != null) {
                jsonWriter.key("Count").value(scanRequest.isCount());
            }
            if (scanRequest.getScanFilter() != null) {
                jsonWriter.key("ScanFilter").object();
                for (Map.Entry entry : scanRequest.getScanFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key((String)entry.getKey());
                    jsonWriter.object();
                    List<AttributeValue> attributeValueListList = ((Condition)entry.getValue()).getAttributeValueList();
                    if (attributeValueListList != null && attributeValueListList.size() > 0) {
                        jsonWriter.key("AttributeValueList").array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            List<String> nSList;
                            List<String> sSList;
                            jsonWriter.object();
                            if (attributeValueListListValue.getS() != null) {
                                jsonWriter.key("S").value(attributeValueListListValue.getS());
                            }
                            if (attributeValueListListValue.getN() != null) {
                                jsonWriter.key("N").value(attributeValueListListValue.getN());
                            }
                            if ((sSList = attributeValueListListValue.getSS()) != null && sSList.size() > 0) {
                                jsonWriter.key("SS").array();
                                for (String sSListValue : sSList) {
                                    jsonWriter.value(sSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if ((nSList = attributeValueListListValue.getNS()) != null && nSList.size() > 0) {
                                jsonWriter.key("NS").array();
                                for (String nSListValue : nSList) {
                                    jsonWriter.value(nSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if (((Condition)entry.getValue()).getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value(((Condition)entry.getValue()).getComparisonOperator());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if ((exclusiveStartKey = scanRequest.getExclusiveStartKey()) != null) {
                AttributeValue rangeKeyElement;
                jsonWriter.key("ExclusiveStartKey").object();
                AttributeValue attributeValue = exclusiveStartKey.getHashKeyElement();
                if (attributeValue != null) {
                    List<String> nSList;
                    List<String> sSList;
                    jsonWriter.key("HashKeyElement").object();
                    if (attributeValue.getS() != null) {
                        jsonWriter.key("S").value(attributeValue.getS());
                    }
                    if (attributeValue.getN() != null) {
                        jsonWriter.key("N").value(attributeValue.getN());
                    }
                    if ((sSList = attributeValue.getSS()) != null && sSList.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : sSList) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = attributeValue.getNS()) != null && nSList.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if ((rangeKeyElement = exclusiveStartKey.getRangeKeyElement()) != null) {
                    List<String> nSList;
                    List<String> sSList;
                    jsonWriter.key("RangeKeyElement").object();
                    if (rangeKeyElement.getS() != null) {
                        jsonWriter.key("S").value(rangeKeyElement.getS());
                    }
                    if (rangeKeyElement.getN() != null) {
                        jsonWriter.key("N").value(rangeKeyElement.getN());
                    }
                    if ((sSList = rangeKeyElement.getSS()) != null && sSList.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : sSList) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = rangeKeyElement.getNS()) != null && nSList.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String string = stringWriter.toString();
            byte[] content = string.getBytes("UTF-8");
            request.setContent(new StringInputStream(string));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

