/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleInstanceRequestMarshaller
implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {
    @Override
    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {
        S3Storage s3StorageS3;
        Storage storageStorage;
        if (bundleInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BundleInstanceRequest> request = new DefaultRequest<BundleInstanceRequest>(bundleInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2011-05-15");
        if (bundleInstanceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(bundleInstanceRequest.getInstanceId()));
        }
        if ((storageStorage = bundleInstanceRequest.getStorage()) != null && (s3StorageS3 = storageStorage.getS3()) != null) {
            if (s3StorageS3.getBucket() != null) {
                request.addParameter("Storage.S3.Bucket", StringUtils.fromString(s3StorageS3.getBucket()));
            }
            if (s3StorageS3.getPrefix() != null) {
                request.addParameter("Storage.S3.Prefix", StringUtils.fromString(s3StorageS3.getPrefix()));
            }
            if (s3StorageS3.getAWSAccessKeyId() != null) {
                request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString(s3StorageS3.getAWSAccessKeyId()));
            }
            if (s3StorageS3.getUploadPolicy() != null) {
                request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString(s3StorageS3.getUploadPolicy()));
            }
            if (s3StorageS3.getUploadPolicySignature() != null) {
                request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString(s3StorageS3.getUploadPolicySignature()));
            }
        }
        return request;
    }
}

