/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.cloudformation.AmazonCloudFormationAsync;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudFormationAsyncClient
extends AmazonCloudFormationClient
implements AmazonCloudFormationAsync {
    private ExecutorService executorService;

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCloudFormationAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ListStacksResult> listStacksAsync(final ListStacksRequest listStacksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStacksResult>(){

            @Override
            public ListStacksResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.listStacks(listStacksRequest);
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(final CreateStackRequest createStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.createStack(createStackRequest);
            }
        });
    }

    @Override
    public Future<ValidateTemplateResult> validateTemplateAsync(final ValidateTemplateRequest validateTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ValidateTemplateResult>(){

            @Override
            public ValidateTemplateResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.validateTemplate(validateTemplateRequest);
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(final DescribeStacksRequest describeStacksRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStacks(describeStacksRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackEventsResult> describeStackEventsAsync(final DescribeStackEventsRequest describeStackEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackEventsResult>(){

            @Override
            public DescribeStackEventsResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStackEvents(describeStackEventsRequest);
            }
        });
    }

    @Override
    public Future<GetTemplateResult> getTemplateAsync(final GetTemplateRequest getTemplateRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTemplateResult>(){

            @Override
            public GetTemplateResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.getTemplate(getTemplateRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackResourceResult> describeStackResourceAsync(final DescribeStackResourceRequest describeStackResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackResourceResult>(){

            @Override
            public DescribeStackResourceResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStackResource(describeStackResourceRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteStackAsync(final DeleteStackRequest deleteStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonCloudFormationAsyncClient.this.deleteStack(deleteStackRequest);
                return null;
            }
        });
    }

    @Override
    public Future<ListStackResourcesResult> listStackResourcesAsync(final ListStackResourcesRequest listStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListStackResourcesResult>(){

            @Override
            public ListStackResourcesResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.listStackResources(listStackResourcesRequest);
            }
        });
    }

    @Override
    public Future<DescribeStackResourcesResult> describeStackResourcesAsync(final DescribeStackResourcesRequest describeStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeStackResourcesResult>(){

            @Override
            public DescribeStackResourcesResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.describeStackResources(describeStackResourcesRequest);
            }
        });
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(final UpdateStackRequest updateStackRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateStackResult>(){

            @Override
            public UpdateStackResult call() throws Exception {
                return AmazonCloudFormationAsyncClient.this.updateStack(updateStackRequest);
            }
        });
    }
}

