/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeScalingActivitiesRequestMarshaller
implements Marshaller<Request<DescribeScalingActivitiesRequest>, DescribeScalingActivitiesRequest> {
    @Override
    public Request<DescribeScalingActivitiesRequest> marshall(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        DefaultRequest<DescribeScalingActivitiesRequest> request = new DefaultRequest<DescribeScalingActivitiesRequest>(describeScalingActivitiesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeScalingActivities");
        request.addParameter("Version", "2011-01-01");
        if (describeScalingActivitiesRequest != null) {
            List<String> activityIdsList = describeScalingActivitiesRequest.getActivityIds();
            int activityIdsListIndex = 1;
            for (String activityIdsListValue : activityIdsList) {
                if (activityIdsListValue != null) {
                    request.addParameter("ActivityIds.member." + activityIdsListIndex, StringUtils.fromString(activityIdsListValue));
                }
                ++activityIdsListIndex;
            }
        }
        if (describeScalingActivitiesRequest != null && describeScalingActivitiesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(describeScalingActivitiesRequest.getAutoScalingGroupName()));
        }
        if (describeScalingActivitiesRequest != null && describeScalingActivitiesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeScalingActivitiesRequest.getMaxRecords()));
        }
        if (describeScalingActivitiesRequest != null && describeScalingActivitiesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScalingActivitiesRequest.getNextToken()));
        }
        return request;
    }
}

