/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    @Override
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        DefaultRequest<AddPermissionRequest> request = new DefaultRequest<AddPermissionRequest>(addPermissionRequest, "AmazonSQS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2009-02-01");
        if (addPermissionRequest != null && addPermissionRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(addPermissionRequest.getQueueUrl()));
        }
        if (addPermissionRequest != null && addPermissionRequest.getLabel() != null) {
            request.addParameter("Label", StringUtils.fromString(addPermissionRequest.getLabel()));
        }
        if (addPermissionRequest != null) {
            List<String> aWSAccountIdsList = addPermissionRequest.getAWSAccountIds();
            int aWSAccountIdsListIndex = 1;
            for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                if (aWSAccountIdsListValue != null) {
                    request.addParameter("AWSAccountId." + aWSAccountIdsListIndex, StringUtils.fromString(aWSAccountIdsListValue));
                }
                ++aWSAccountIdsListIndex;
            }
        }
        if (addPermissionRequest != null) {
            List<String> actionsList = addPermissionRequest.getActions();
            int actionsListIndex = 1;
            for (String actionsListValue : actionsList) {
                if (actionsListValue != null) {
                    request.addParameter("ActionName." + actionsListIndex, StringUtils.fromString(actionsListValue));
                }
                ++actionsListIndex;
            }
        }
        return request;
    }
}

