/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import com.amazonaws.services.cloudformation.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DeleteStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudFormationClient
extends AmazonWebServiceClient
implements AmazonCloudFormation {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    private QueryStringSigner signer;

    public AmazonCloudFormationClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudformation.us-east-1.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudformation/request.handlers"));
    }

    @Override
    public ListStacksResult listStacks(ListStacksRequest listStacksRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListStacksRequest> request = new ListStacksRequestMarshaller().marshall(listStacksRequest);
        return this.invoke(request, new ListStacksResultStaxUnmarshaller());
    }

    @Override
    public CreateStackResult createStack(CreateStackRequest createStackRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateStackRequest> request = new CreateStackRequestMarshaller().marshall(createStackRequest);
        return this.invoke(request, new CreateStackResultStaxUnmarshaller());
    }

    @Override
    public ValidateTemplateResult validateTemplate(ValidateTemplateRequest validateTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<ValidateTemplateRequest> request = new ValidateTemplateRequestMarshaller().marshall(validateTemplateRequest);
        return this.invoke(request, new ValidateTemplateResultStaxUnmarshaller());
    }

    @Override
    public DescribeStacksResult describeStacks(DescribeStacksRequest describeStacksRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStacksRequest> request = new DescribeStacksRequestMarshaller().marshall(describeStacksRequest);
        return this.invoke(request, new DescribeStacksResultStaxUnmarshaller());
    }

    @Override
    public DescribeStackEventsResult describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStackEventsRequest> request = new DescribeStackEventsRequestMarshaller().marshall(describeStackEventsRequest);
        return this.invoke(request, new DescribeStackEventsResultStaxUnmarshaller());
    }

    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest getTemplateRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetTemplateRequest> request = new GetTemplateRequestMarshaller().marshall(getTemplateRequest);
        return this.invoke(request, new GetTemplateResultStaxUnmarshaller());
    }

    @Override
    public DescribeStackResourceResult describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStackResourceRequest> request = new DescribeStackResourceRequestMarshaller().marshall(describeStackResourceRequest);
        return this.invoke(request, new DescribeStackResourceResultStaxUnmarshaller());
    }

    @Override
    public void deleteStack(DeleteStackRequest deleteStackRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteStackRequest> request = new DeleteStackRequestMarshaller().marshall(deleteStackRequest);
        this.invoke(request, null);
    }

    @Override
    public ListStackResourcesResult listStackResources(ListStackResourcesRequest listStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListStackResourcesRequest> request = new ListStackResourcesRequestMarshaller().marshall(listStackResourcesRequest);
        return this.invoke(request, new ListStackResourcesResultStaxUnmarshaller());
    }

    @Override
    public DescribeStackResourcesResult describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStackResourcesRequest> request = new DescribeStackResourcesRequestMarshaller().marshall(describeStackResourcesRequest);
        return this.invoke(request, new DescribeStackResourcesResultStaxUnmarshaller());
    }

    @Override
    public ListStacksResult listStacks() throws AmazonServiceException, AmazonClientException {
        return this.listStacks(new ListStacksRequest());
    }

    @Override
    public DescribeStacksResult describeStacks() throws AmazonServiceException, AmazonClientException {
        return this.describeStacks(new DescribeStacksRequest());
    }

    @Override
    public DescribeStackEventsResult describeStackEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeStackEvents(new DescribeStackEventsRequest());
    }

    @Override
    public DescribeStackResourcesResult describeStackResources() throws AmazonServiceException, AmazonClientException {
        return this.describeStackResources(new DescribeStackResourcesRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        if (request.getOriginalRequest().getRequestCredentials() != null) {
            this.signer.sign(request, request.getOriginalRequest().getRequestCredentials());
        } else {
            this.signer.sign(request, this.awsCredentials);
        }
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        ExecutionContext executionContext = this.createExecutionContext();
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

