/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.services.s3.model.ProgressEvent;
import com.amazonaws.services.s3.model.ProgressListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressReportingInputStream
extends FilterInputStream {
    private static final int NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListener listener;
    private int unnotifiedByteCount;

    public ProgressReportingInputStream(InputStream in, ProgressListener listener) {
        super(in);
        this.listener = listener;
    }

    public int read() throws IOException {
        int data = super.read();
        if (data != -1) {
            this.notify(1);
        }
        return data;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead != -1) {
            this.notify(bytesRead);
        }
        return bytesRead;
    }

    public void close() throws IOException {
        if (this.unnotifiedByteCount > 0) {
            this.listener.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
        super.close();
    }

    private void notify(int bytesRead) {
        this.unnotifiedByteCount += bytesRead;
        if (this.unnotifiedByteCount >= 8192) {
            this.listener.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
    }
}

