/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputSubstream
extends FilterInputStream {
    private long currentPosition = 0L;
    private final long requestedOffset;
    private final long requestedLength;
    private long markedPosition = 0L;

    public InputSubstream(InputStream in, long offset, long length) {
        super(in);
        this.requestedLength = length;
        this.requestedOffset = offset;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int bytesRead = this.read(b, 0, 1);
        if (bytesRead == -1) {
            return bytesRead;
        }
        return b[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (this.currentPosition < this.requestedOffset) {
            long skippedBytes = super.skip(this.requestedOffset - this.currentPosition);
            this.currentPosition += skippedBytes;
        }
        long bytesRemaining = this.requestedLength + this.requestedOffset - this.currentPosition;
        if (bytesRemaining <= 0L) {
            return -1;
        }
        len = (int)Math.min((long)len, bytesRemaining);
        int bytesRead = super.read(b, off, len);
        this.currentPosition += (long)bytesRead;
        return bytesRead;
    }

    public synchronized void mark(int readlimit) {
        this.markedPosition = this.currentPosition;
        super.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.currentPosition = this.markedPosition;
        super.reset();
    }

    public void close() throws IOException {
        if (this.in.available() <= 0) {
            super.close();
        }
    }

    public int available() throws IOException {
        long bytesRemaining = this.currentPosition < this.requestedOffset ? this.requestedLength : this.requestedLength + this.requestedOffset - this.currentPosition;
        return (int)Math.min(bytesRemaining, (long)super.available());
    }
}

