/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDBInstanceRequest
extends AmazonWebServiceRequest {
    private String dBInstanceIdentifier;
    private Integer allocatedStorage;
    private String dBInstanceClass;
    private List<String> dBSecurityGroups;
    private Boolean applyImmediately;
    private String masterUserPassword;
    private String dBParameterGroupName;
    private Integer backupRetentionPeriod;
    private String preferredBackupWindow;
    private String preferredMaintenanceWindow;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean allowMajorVersionUpgrade;
    private Boolean autoMinorVersionUpgrade;

    public ModifyDBInstanceRequest() {
    }

    public ModifyDBInstanceRequest(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public ModifyDBInstanceRequest withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public ModifyDBInstanceRequest withAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public ModifyDBInstanceRequest withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public List<String> getDBSecurityGroups() {
        if (this.dBSecurityGroups == null) {
            this.dBSecurityGroups = new ArrayList<String>();
        }
        return this.dBSecurityGroups;
    }

    public void setDBSecurityGroups(Collection<String> dBSecurityGroups) {
        ArrayList<String> dBSecurityGroupsCopy = new ArrayList<String>();
        if (dBSecurityGroups != null) {
            dBSecurityGroupsCopy.addAll(dBSecurityGroups);
        }
        this.dBSecurityGroups = dBSecurityGroupsCopy;
    }

    public ModifyDBInstanceRequest withDBSecurityGroups(String ... dBSecurityGroups) {
        for (String value : dBSecurityGroups) {
            this.getDBSecurityGroups().add(value);
        }
        return this;
    }

    public ModifyDBInstanceRequest withDBSecurityGroups(Collection<String> dBSecurityGroups) {
        ArrayList<String> dBSecurityGroupsCopy = new ArrayList<String>();
        if (dBSecurityGroups != null) {
            dBSecurityGroupsCopy.addAll(dBSecurityGroups);
        }
        this.dBSecurityGroups = dBSecurityGroupsCopy;
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public ModifyDBInstanceRequest withApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
        return this;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public ModifyDBInstanceRequest withMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
        return this;
    }

    public String getDBParameterGroupName() {
        return this.dBParameterGroupName;
    }

    public void setDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
    }

    public ModifyDBInstanceRequest withDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
        return this;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public ModifyDBInstanceRequest withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
        return this;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public ModifyDBInstanceRequest withPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public ModifyDBInstanceRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public ModifyDBInstanceRequest withMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
        return this;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public ModifyDBInstanceRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Boolean isAllowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
        this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
    }

    public ModifyDBInstanceRequest withAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
        this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        return this;
    }

    public Boolean getAllowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public ModifyDBInstanceRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("DBInstanceIdentifier: " + this.dBInstanceIdentifier + ", ");
        sb.append("AllocatedStorage: " + this.allocatedStorage + ", ");
        sb.append("DBInstanceClass: " + this.dBInstanceClass + ", ");
        sb.append("DBSecurityGroups: " + this.dBSecurityGroups + ", ");
        sb.append("ApplyImmediately: " + this.applyImmediately + ", ");
        sb.append("MasterUserPassword: " + this.masterUserPassword + ", ");
        sb.append("DBParameterGroupName: " + this.dBParameterGroupName + ", ");
        sb.append("BackupRetentionPeriod: " + this.backupRetentionPeriod + ", ");
        sb.append("PreferredBackupWindow: " + this.preferredBackupWindow + ", ");
        sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        sb.append("MultiAZ: " + this.multiAZ + ", ");
        sb.append("EngineVersion: " + this.engineVersion + ", ");
        sb.append("AllowMajorVersionUpgrade: " + this.allowMajorVersionUpgrade + ", ");
        sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        sb.append("}");
        return sb.toString();
    }
}

