/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCacheClusterRequest
extends AmazonWebServiceRequest {
    private String cacheClusterId;
    private Integer numCacheNodes;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private String cacheParameterGroupName;
    private List<String> cacheSecurityGroupNames;
    private String preferredAvailabilityZone;
    private String preferredMaintenanceWindow;
    private Integer port;
    private String notificationTopicArn;
    private Boolean autoMinorVersionUpgrade;

    public CreateCacheClusterRequest() {
    }

    public CreateCacheClusterRequest(String cacheClusterId, Integer numCacheNodes, String cacheNodeType, String engine, List<String> cacheSecurityGroupNames) {
        this.cacheClusterId = cacheClusterId;
        this.numCacheNodes = numCacheNodes;
        this.cacheNodeType = cacheNodeType;
        this.engine = engine;
        this.cacheSecurityGroupNames = cacheSecurityGroupNames;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public CreateCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public CreateCacheClusterRequest withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public CreateCacheClusterRequest withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public CreateCacheClusterRequest withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CreateCacheClusterRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public CreateCacheClusterRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public List<String> getCacheSecurityGroupNames() {
        if (this.cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = new ArrayList<String>();
        }
        return this.cacheSecurityGroupNames;
    }

    public void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        ArrayList<String> cacheSecurityGroupNamesCopy = new ArrayList<String>();
        if (cacheSecurityGroupNames != null) {
            cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
        }
        this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
    }

    public CreateCacheClusterRequest withCacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
        if (this.getCacheSecurityGroupNames() == null) {
            this.setCacheSecurityGroupNames(new ArrayList<String>());
        }
        for (String value : cacheSecurityGroupNames) {
            this.getCacheSecurityGroupNames().add(value);
        }
        return this;
    }

    public CreateCacheClusterRequest withCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        ArrayList<String> cacheSecurityGroupNamesCopy = new ArrayList<String>();
        if (cacheSecurityGroupNames != null) {
            cacheSecurityGroupNamesCopy.addAll(cacheSecurityGroupNames);
        }
        this.cacheSecurityGroupNames = cacheSecurityGroupNamesCopy;
        return this;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public CreateCacheClusterRequest withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public CreateCacheClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public CreateCacheClusterRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String getNotificationTopicArn() {
        return this.notificationTopicArn;
    }

    public void setNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
    }

    public CreateCacheClusterRequest withNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CreateCacheClusterRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("CacheClusterId: " + this.cacheClusterId + ", ");
        sb.append("NumCacheNodes: " + this.numCacheNodes + ", ");
        sb.append("CacheNodeType: " + this.cacheNodeType + ", ");
        sb.append("Engine: " + this.engine + ", ");
        sb.append("EngineVersion: " + this.engineVersion + ", ");
        sb.append("CacheParameterGroupName: " + this.cacheParameterGroupName + ", ");
        sb.append("CacheSecurityGroupNames: " + this.cacheSecurityGroupNames + ", ");
        sb.append("PreferredAvailabilityZone: " + this.preferredAvailabilityZone + ", ");
        sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        sb.append("Port: " + this.port + ", ");
        sb.append("NotificationTopicArn: " + this.notificationTopicArn + ", ");
        sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        sb.append("}");
        return sb.toString();
    }
}

